/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Splide: () => (/* binding */ Splide2),
/* harmony export */   SplideSlide: () => (/* binding */ SplideSlide),
/* harmony export */   SplideTrack: () => (/* binding */ SplideTrack)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// node_modules/@splidejs/splide/dist/js/splide.esm.js
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", { writable: false });
  return Constructor;
}
var MEDIA_PREFERS_REDUCED_MOTION = "(prefers-reduced-motion: reduce)";
var CREATED = 1;
var MOUNTED = 2;
var IDLE = 3;
var MOVING = 4;
var SCROLLING = 5;
var DRAGGING = 6;
var DESTROYED = 7;
var STATES = {
  CREATED,
  MOUNTED,
  IDLE,
  MOVING,
  SCROLLING,
  DRAGGING,
  DESTROYED
};
function empty(array) {
  array.length = 0;
}
function slice(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}
function apply(func) {
  return func.bind.apply(func, [null].concat(slice(arguments, 1)));
}
var nextTick = setTimeout;
var noop = function noop2() {
};
function raf(func) {
  return requestAnimationFrame(func);
}
function typeOf(type, subject) {
  return typeof subject === type;
}
function isObject(subject) {
  return !isNull(subject) && typeOf("object", subject);
}
var isArray = Array.isArray;
var isFunction = apply(typeOf, "function");
var isString = apply(typeOf, "string");
var isUndefined = apply(typeOf, "undefined");
function isNull(subject) {
  return subject === null;
}
function isHTMLElement(subject) {
  try {
    return subject instanceof (subject.ownerDocument.defaultView || window).HTMLElement;
  } catch (e) {
    return false;
  }
}
function toArray(value) {
  return isArray(value) ? value : [value];
}
function forEach(values, iteratee) {
  toArray(values).forEach(iteratee);
}
function includes(array, value) {
  return array.indexOf(value) > -1;
}
function push(array, items) {
  array.push.apply(array, toArray(items));
  return array;
}
function toggleClass(elm, classes, add) {
  if (elm) {
    forEach(classes, function(name) {
      if (name) {
        elm.classList[add ? "add" : "remove"](name);
      }
    });
  }
}
function addClass(elm, classes) {
  toggleClass(elm, isString(classes) ? classes.split(" ") : classes, true);
}
function append(parent, children2) {
  forEach(children2, parent.appendChild.bind(parent));
}
function before(nodes, ref) {
  forEach(nodes, function(node) {
    var parent = (ref || node).parentNode;
    if (parent) {
      parent.insertBefore(node, ref);
    }
  });
}
function matches(elm, selector) {
  return isHTMLElement(elm) && (elm["msMatchesSelector"] || elm.matches).call(elm, selector);
}
function children(parent, selector) {
  var children2 = parent ? slice(parent.children) : [];
  return selector ? children2.filter(function(child2) {
    return matches(child2, selector);
  }) : children2;
}
function child(parent, selector) {
  return selector ? children(parent, selector)[0] : parent.firstElementChild;
}
var ownKeys = Object.keys;
function forOwn(object, iteratee, right) {
  if (object) {
    (right ? ownKeys(object).reverse() : ownKeys(object)).forEach(function(key) {
      key !== "__proto__" && iteratee(object[key], key);
    });
  }
  return object;
}
function assign(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      object[key] = source[key];
    });
  });
  return object;
}
function merge(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      if (isArray(value)) {
        object[key] = value.slice();
      } else if (isObject(value)) {
        object[key] = merge({}, isObject(object[key]) ? object[key] : {}, value);
      } else {
        object[key] = value;
      }
    });
  });
  return object;
}
function omit(object, keys) {
  forEach(keys || ownKeys(object), function(key) {
    delete object[key];
  });
}
function removeAttribute(elms, attrs) {
  forEach(elms, function(elm) {
    forEach(attrs, function(attr) {
      elm && elm.removeAttribute(attr);
    });
  });
}
function setAttribute(elms, attrs, value) {
  if (isObject(attrs)) {
    forOwn(attrs, function(value2, name) {
      setAttribute(elms, name, value2);
    });
  } else {
    forEach(elms, function(elm) {
      isNull(value) || value === "" ? removeAttribute(elm, attrs) : elm.setAttribute(attrs, String(value));
    });
  }
}
function create(tag, attrs, parent) {
  var elm = document.createElement(tag);
  if (attrs) {
    isString(attrs) ? addClass(elm, attrs) : setAttribute(elm, attrs);
  }
  parent && append(parent, elm);
  return elm;
}
function style(elm, prop, value) {
  if (isUndefined(value)) {
    return getComputedStyle(elm)[prop];
  }
  if (!isNull(value)) {
    elm.style[prop] = "" + value;
  }
}
function display(elm, display2) {
  style(elm, "display", display2);
}
function focus(elm) {
  elm["setActive"] && elm["setActive"]() || elm.focus({
    preventScroll: true
  });
}
function getAttribute(elm, attr) {
  return elm.getAttribute(attr);
}
function hasClass(elm, className) {
  return elm && elm.classList.contains(className);
}
function rect(target) {
  return target.getBoundingClientRect();
}
function remove(nodes) {
  forEach(nodes, function(node) {
    if (node && node.parentNode) {
      node.parentNode.removeChild(node);
    }
  });
}
function parseHtml(html) {
  return child(new DOMParser().parseFromString(html, "text/html").body);
}
function prevent(e, stopPropagation) {
  e.preventDefault();
  if (stopPropagation) {
    e.stopPropagation();
    e.stopImmediatePropagation();
  }
}
function query(parent, selector) {
  return parent && parent.querySelector(selector);
}
function queryAll(parent, selector) {
  return selector ? slice(parent.querySelectorAll(selector)) : [];
}
function removeClass(elm, classes) {
  toggleClass(elm, classes, false);
}
function timeOf(e) {
  return e.timeStamp;
}
function unit(value) {
  return isString(value) ? value : value ? value + "px" : "";
}
var PROJECT_CODE = "splide";
var DATA_ATTRIBUTE = "data-" + PROJECT_CODE;
function assert(condition, message) {
  if (!condition) {
    throw new Error("[" + PROJECT_CODE + "] " + (message || ""));
  }
}
var min = Math.min;
var max = Math.max;
var floor = Math.floor;
var ceil = Math.ceil;
var abs = Math.abs;
function approximatelyEqual(x, y, epsilon) {
  return abs(x - y) < epsilon;
}
function between(number, x, y, exclusive) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return exclusive ? minimum < number && number < maximum : minimum <= number && number <= maximum;
}
function clamp(number, x, y) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return min(max(minimum, number), maximum);
}
function sign(x) {
  return +(x > 0) - +(x < 0);
}
function format(string, replacements) {
  forEach(replacements, function(replacement) {
    string = string.replace("%s", "" + replacement);
  });
  return string;
}
function pad(number) {
  return number < 10 ? "0" + number : "" + number;
}
var ids = {};
function uniqueId(prefix) {
  return "" + prefix + pad(ids[prefix] = (ids[prefix] || 0) + 1);
}
function EventBinder() {
  var listeners = [];
  function bind(targets, events, callback, options) {
    forEachEvent(targets, events, function(target, event, namespace) {
      var isEventTarget = "addEventListener" in target;
      var remover = isEventTarget ? target.removeEventListener.bind(target, event, callback, options) : target["removeListener"].bind(target, callback);
      isEventTarget ? target.addEventListener(event, callback, options) : target["addListener"](callback);
      listeners.push([target, event, namespace, callback, remover]);
    });
  }
  function unbind(targets, events, callback) {
    forEachEvent(targets, events, function(target, event, namespace) {
      listeners = listeners.filter(function(listener) {
        if (listener[0] === target && listener[1] === event && listener[2] === namespace && (!callback || listener[3] === callback)) {
          listener[4]();
          return false;
        }
        return true;
      });
    });
  }
  function dispatch(target, type, detail) {
    var e;
    var bubbles = true;
    if (typeof CustomEvent === "function") {
      e = new CustomEvent(type, {
        bubbles,
        detail
      });
    } else {
      e = document.createEvent("CustomEvent");
      e.initCustomEvent(type, bubbles, false, detail);
    }
    target.dispatchEvent(e);
    return e;
  }
  function forEachEvent(targets, events, iteratee) {
    forEach(targets, function(target) {
      target && forEach(events, function(events2) {
        events2.split(" ").forEach(function(eventNS) {
          var fragment = eventNS.split(".");
          iteratee(target, fragment[0], fragment[1]);
        });
      });
    });
  }
  function destroy() {
    listeners.forEach(function(data) {
      data[4]();
    });
    empty(listeners);
  }
  return {
    bind,
    unbind,
    dispatch,
    destroy
  };
}
var EVENT_MOUNTED = "mounted";
var EVENT_READY = "ready";
var EVENT_MOVE = "move";
var EVENT_MOVED = "moved";
var EVENT_CLICK = "click";
var EVENT_ACTIVE = "active";
var EVENT_INACTIVE = "inactive";
var EVENT_VISIBLE = "visible";
var EVENT_HIDDEN = "hidden";
var EVENT_REFRESH = "refresh";
var EVENT_UPDATED = "updated";
var EVENT_RESIZE = "resize";
var EVENT_RESIZED = "resized";
var EVENT_DRAG = "drag";
var EVENT_DRAGGING = "dragging";
var EVENT_DRAGGED = "dragged";
var EVENT_SCROLL = "scroll";
var EVENT_SCROLLED = "scrolled";
var EVENT_OVERFLOW = "overflow";
var EVENT_DESTROY = "destroy";
var EVENT_ARROWS_MOUNTED = "arrows:mounted";
var EVENT_ARROWS_UPDATED = "arrows:updated";
var EVENT_PAGINATION_MOUNTED = "pagination:mounted";
var EVENT_PAGINATION_UPDATED = "pagination:updated";
var EVENT_NAVIGATION_MOUNTED = "navigation:mounted";
var EVENT_AUTOPLAY_PLAY = "autoplay:play";
var EVENT_AUTOPLAY_PLAYING = "autoplay:playing";
var EVENT_AUTOPLAY_PAUSE = "autoplay:pause";
var EVENT_LAZYLOAD_LOADED = "lazyload:loaded";
var EVENT_SLIDE_KEYDOWN = "sk";
var EVENT_SHIFTED = "sh";
var EVENT_END_INDEX_CHANGED = "ei";
function EventInterface(Splide22) {
  var bus = Splide22 ? Splide22.event.bus : document.createDocumentFragment();
  var binder = EventBinder();
  function on(events, callback) {
    binder.bind(bus, toArray(events).join(" "), function(e) {
      callback.apply(callback, isArray(e.detail) ? e.detail : []);
    });
  }
  function emit(event) {
    binder.dispatch(bus, event, slice(arguments, 1));
  }
  if (Splide22) {
    Splide22.event.on(EVENT_DESTROY, binder.destroy);
  }
  return assign(binder, {
    bus,
    on,
    off: apply(binder.unbind, bus),
    emit
  });
}
function RequestInterval(interval, onInterval, onUpdate, limit) {
  var now = Date.now;
  var startTime;
  var rate = 0;
  var id;
  var paused = true;
  var count = 0;
  function update() {
    if (!paused) {
      rate = interval ? min((now() - startTime) / interval, 1) : 1;
      onUpdate && onUpdate(rate);
      if (rate >= 1) {
        onInterval();
        startTime = now();
        if (limit && ++count >= limit) {
          return pause();
        }
      }
      id = raf(update);
    }
  }
  function start(resume) {
    resume || cancel();
    startTime = now() - (resume ? rate * interval : 0);
    paused = false;
    id = raf(update);
  }
  function pause() {
    paused = true;
  }
  function rewind() {
    startTime = now();
    rate = 0;
    if (onUpdate) {
      onUpdate(rate);
    }
  }
  function cancel() {
    id && cancelAnimationFrame(id);
    rate = 0;
    id = 0;
    paused = true;
  }
  function set(time) {
    interval = time;
  }
  function isPaused() {
    return paused;
  }
  return {
    start,
    rewind,
    pause,
    cancel,
    set,
    isPaused
  };
}
function State(initialState) {
  var state = initialState;
  function set(value) {
    state = value;
  }
  function is(states) {
    return includes(toArray(states), state);
  }
  return {
    set,
    is
  };
}
function Throttle(func, duration) {
  var interval = RequestInterval(duration || 0, func, null, 1);
  return function() {
    interval.isPaused() && interval.start();
  };
}
function Media(Splide22, Components2, options) {
  var state = Splide22.state;
  var breakpoints = options.breakpoints || {};
  var reducedMotion = options.reducedMotion || {};
  var binder = EventBinder();
  var queries = [];
  function setup() {
    var isMin = options.mediaQuery === "min";
    ownKeys(breakpoints).sort(function(n, m) {
      return isMin ? +n - +m : +m - +n;
    }).forEach(function(key) {
      register(breakpoints[key], "(" + (isMin ? "min" : "max") + "-width:" + key + "px)");
    });
    register(reducedMotion, MEDIA_PREFERS_REDUCED_MOTION);
    update();
  }
  function destroy(completely) {
    if (completely) {
      binder.destroy();
    }
  }
  function register(options2, query2) {
    var queryList = matchMedia(query2);
    binder.bind(queryList, "change", update);
    queries.push([options2, queryList]);
  }
  function update() {
    var destroyed = state.is(DESTROYED);
    var direction = options.direction;
    var merged = queries.reduce(function(merged2, entry) {
      return merge(merged2, entry[1].matches ? entry[0] : {});
    }, {});
    omit(options);
    set(merged);
    if (options.destroy) {
      Splide22.destroy(options.destroy === "completely");
    } else if (destroyed) {
      destroy(true);
      Splide22.mount();
    } else {
      direction !== options.direction && Splide22.refresh();
    }
  }
  function reduce(enable) {
    if (matchMedia(MEDIA_PREFERS_REDUCED_MOTION).matches) {
      enable ? merge(options, reducedMotion) : omit(options, ownKeys(reducedMotion));
    }
  }
  function set(opts, base, notify) {
    merge(options, opts);
    base && merge(Object.getPrototypeOf(options), opts);
    if (notify || !state.is(CREATED)) {
      Splide22.emit(EVENT_UPDATED, options);
    }
  }
  return {
    setup,
    destroy,
    reduce,
    set
  };
}
var ARROW = "Arrow";
var ARROW_LEFT = ARROW + "Left";
var ARROW_RIGHT = ARROW + "Right";
var ARROW_UP = ARROW + "Up";
var ARROW_DOWN = ARROW + "Down";
var RTL = "rtl";
var TTB = "ttb";
var ORIENTATION_MAP = {
  width: ["height"],
  left: ["top", "right"],
  right: ["bottom", "left"],
  x: ["y"],
  X: ["Y"],
  Y: ["X"],
  ArrowLeft: [ARROW_UP, ARROW_RIGHT],
  ArrowRight: [ARROW_DOWN, ARROW_LEFT]
};
function Direction(Splide22, Components2, options) {
  function resolve(prop, axisOnly, direction) {
    direction = direction || options.direction;
    var index = direction === RTL && !axisOnly ? 1 : direction === TTB ? 0 : -1;
    return ORIENTATION_MAP[prop] && ORIENTATION_MAP[prop][index] || prop.replace(/width|left|right/i, function(match, offset) {
      var replacement = ORIENTATION_MAP[match.toLowerCase()][index] || match;
      return offset > 0 ? replacement.charAt(0).toUpperCase() + replacement.slice(1) : replacement;
    });
  }
  function orient(value) {
    return value * (options.direction === RTL ? 1 : -1);
  }
  return {
    resolve,
    orient
  };
}
var ROLE = "role";
var TAB_INDEX = "tabindex";
var DISABLED = "disabled";
var ARIA_PREFIX = "aria-";
var ARIA_CONTROLS = ARIA_PREFIX + "controls";
var ARIA_CURRENT = ARIA_PREFIX + "current";
var ARIA_SELECTED = ARIA_PREFIX + "selected";
var ARIA_LABEL = ARIA_PREFIX + "label";
var ARIA_LABELLEDBY = ARIA_PREFIX + "labelledby";
var ARIA_HIDDEN = ARIA_PREFIX + "hidden";
var ARIA_ORIENTATION = ARIA_PREFIX + "orientation";
var ARIA_ROLEDESCRIPTION = ARIA_PREFIX + "roledescription";
var ARIA_LIVE = ARIA_PREFIX + "live";
var ARIA_BUSY = ARIA_PREFIX + "busy";
var ARIA_ATOMIC = ARIA_PREFIX + "atomic";
var ALL_ATTRIBUTES = [ROLE, TAB_INDEX, DISABLED, ARIA_CONTROLS, ARIA_CURRENT, ARIA_LABEL, ARIA_LABELLEDBY, ARIA_HIDDEN, ARIA_ORIENTATION, ARIA_ROLEDESCRIPTION];
var CLASS_PREFIX = PROJECT_CODE + "__";
var STATUS_CLASS_PREFIX = "is-";
var CLASS_ROOT = PROJECT_CODE;
var CLASS_TRACK = CLASS_PREFIX + "track";
var CLASS_LIST = CLASS_PREFIX + "list";
var CLASS_SLIDE = CLASS_PREFIX + "slide";
var CLASS_CLONE = CLASS_SLIDE + "--clone";
var CLASS_CONTAINER = CLASS_SLIDE + "__container";
var CLASS_ARROWS = CLASS_PREFIX + "arrows";
var CLASS_ARROW = CLASS_PREFIX + "arrow";
var CLASS_ARROW_PREV = CLASS_ARROW + "--prev";
var CLASS_ARROW_NEXT = CLASS_ARROW + "--next";
var CLASS_PAGINATION = CLASS_PREFIX + "pagination";
var CLASS_PAGINATION_PAGE = CLASS_PAGINATION + "__page";
var CLASS_PROGRESS = CLASS_PREFIX + "progress";
var CLASS_PROGRESS_BAR = CLASS_PROGRESS + "__bar";
var CLASS_TOGGLE = CLASS_PREFIX + "toggle";
var CLASS_TOGGLE_PLAY = CLASS_TOGGLE + "__play";
var CLASS_TOGGLE_PAUSE = CLASS_TOGGLE + "__pause";
var CLASS_SPINNER = CLASS_PREFIX + "spinner";
var CLASS_SR = CLASS_PREFIX + "sr";
var CLASS_INITIALIZED = STATUS_CLASS_PREFIX + "initialized";
var CLASS_ACTIVE = STATUS_CLASS_PREFIX + "active";
var CLASS_PREV = STATUS_CLASS_PREFIX + "prev";
var CLASS_NEXT = STATUS_CLASS_PREFIX + "next";
var CLASS_VISIBLE = STATUS_CLASS_PREFIX + "visible";
var CLASS_LOADING = STATUS_CLASS_PREFIX + "loading";
var CLASS_FOCUS_IN = STATUS_CLASS_PREFIX + "focus-in";
var CLASS_OVERFLOW = STATUS_CLASS_PREFIX + "overflow";
var STATUS_CLASSES = [CLASS_ACTIVE, CLASS_VISIBLE, CLASS_PREV, CLASS_NEXT, CLASS_LOADING, CLASS_FOCUS_IN, CLASS_OVERFLOW];
var CLASSES = {
  slide: CLASS_SLIDE,
  clone: CLASS_CLONE,
  arrows: CLASS_ARROWS,
  arrow: CLASS_ARROW,
  prev: CLASS_ARROW_PREV,
  next: CLASS_ARROW_NEXT,
  pagination: CLASS_PAGINATION,
  page: CLASS_PAGINATION_PAGE,
  spinner: CLASS_SPINNER
};
function closest(from, selector) {
  if (isFunction(from.closest)) {
    return from.closest(selector);
  }
  var elm = from;
  while (elm && elm.nodeType === 1) {
    if (matches(elm, selector)) {
      break;
    }
    elm = elm.parentElement;
  }
  return elm;
}
var FRICTION = 5;
var LOG_INTERVAL = 200;
var POINTER_DOWN_EVENTS = "touchstart mousedown";
var POINTER_MOVE_EVENTS = "touchmove mousemove";
var POINTER_UP_EVENTS = "touchend touchcancel mouseup click";
function Elements(Splide22, Components2, options) {
  var _EventInterface = EventInterface(Splide22), on = _EventInterface.on, bind = _EventInterface.bind;
  var root = Splide22.root;
  var i18n = options.i18n;
  var elements = {};
  var slides = [];
  var rootClasses = [];
  var trackClasses = [];
  var track;
  var list;
  var isUsingKey;
  function setup() {
    collect();
    init();
    update();
  }
  function mount() {
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, setup);
    on(EVENT_UPDATED, update);
    bind(document, POINTER_DOWN_EVENTS + " keydown", function(e) {
      isUsingKey = e.type === "keydown";
    }, {
      capture: true
    });
    bind(root, "focusin", function() {
      toggleClass(root, CLASS_FOCUS_IN, !!isUsingKey);
    });
  }
  function destroy(completely) {
    var attrs = ALL_ATTRIBUTES.concat("style");
    empty(slides);
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    removeAttribute([track, list], attrs);
    removeAttribute(root, completely ? attrs : ["style", ARIA_ROLEDESCRIPTION]);
  }
  function update() {
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    rootClasses = getClasses(CLASS_ROOT);
    trackClasses = getClasses(CLASS_TRACK);
    addClass(root, rootClasses);
    addClass(track, trackClasses);
    setAttribute(root, ARIA_LABEL, options.label);
    setAttribute(root, ARIA_LABELLEDBY, options.labelledby);
  }
  function collect() {
    track = find("." + CLASS_TRACK);
    list = child(track, "." + CLASS_LIST);
    assert(track && list, "A track/list element is missing.");
    push(slides, children(list, "." + CLASS_SLIDE + ":not(." + CLASS_CLONE + ")"));
    forOwn({
      arrows: CLASS_ARROWS,
      pagination: CLASS_PAGINATION,
      prev: CLASS_ARROW_PREV,
      next: CLASS_ARROW_NEXT,
      bar: CLASS_PROGRESS_BAR,
      toggle: CLASS_TOGGLE
    }, function(className, key) {
      elements[key] = find("." + className);
    });
    assign(elements, {
      root,
      track,
      list,
      slides
    });
  }
  function init() {
    var id = root.id || uniqueId(PROJECT_CODE);
    var role = options.role;
    root.id = id;
    track.id = track.id || id + "-track";
    list.id = list.id || id + "-list";
    if (!getAttribute(root, ROLE) && root.tagName !== "SECTION" && role) {
      setAttribute(root, ROLE, role);
    }
    setAttribute(root, ARIA_ROLEDESCRIPTION, i18n.carousel);
    setAttribute(list, ROLE, "presentation");
  }
  function find(selector) {
    var elm = query(root, selector);
    return elm && closest(elm, "." + CLASS_ROOT) === root ? elm : void 0;
  }
  function getClasses(base) {
    return [base + "--" + options.type, base + "--" + options.direction, options.drag && base + "--draggable", options.isNavigation && base + "--nav", base === CLASS_ROOT && CLASS_ACTIVE];
  }
  return assign(elements, {
    setup,
    mount,
    destroy
  });
}
var SLIDE = "slide";
var LOOP = "loop";
var FADE = "fade";
function Slide$1(Splide22, index, slideIndex, slide) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Components = Splide22.Components, root = Splide22.root, options = Splide22.options;
  var isNavigation = options.isNavigation, updateOnMove = options.updateOnMove, i18n = options.i18n, pagination = options.pagination, slideFocus = options.slideFocus;
  var resolve = Components.Direction.resolve;
  var styles = getAttribute(slide, "style");
  var label = getAttribute(slide, ARIA_LABEL);
  var isClone = slideIndex > -1;
  var container = child(slide, "." + CLASS_CONTAINER);
  var destroyed;
  function mount() {
    if (!isClone) {
      slide.id = root.id + "-slide" + pad(index + 1);
      setAttribute(slide, ROLE, pagination ? "tabpanel" : "group");
      setAttribute(slide, ARIA_ROLEDESCRIPTION, i18n.slide);
      setAttribute(slide, ARIA_LABEL, label || format(i18n.slideLabel, [index + 1, Splide22.length]));
    }
    listen();
  }
  function listen() {
    bind(slide, "click", apply(emit, EVENT_CLICK, self));
    bind(slide, "keydown", apply(emit, EVENT_SLIDE_KEYDOWN, self));
    on([EVENT_MOVED, EVENT_SHIFTED, EVENT_SCROLLED], update);
    on(EVENT_NAVIGATION_MOUNTED, initNavigation);
    if (updateOnMove) {
      on(EVENT_MOVE, onMove);
    }
  }
  function destroy() {
    destroyed = true;
    event.destroy();
    removeClass(slide, STATUS_CLASSES);
    removeAttribute(slide, ALL_ATTRIBUTES);
    setAttribute(slide, "style", styles);
    setAttribute(slide, ARIA_LABEL, label || "");
  }
  function initNavigation() {
    var controls = Splide22.splides.map(function(target) {
      var Slide2 = target.splide.Components.Slides.getAt(index);
      return Slide2 ? Slide2.slide.id : "";
    }).join(" ");
    setAttribute(slide, ARIA_LABEL, format(i18n.slideX, (isClone ? slideIndex : index) + 1));
    setAttribute(slide, ARIA_CONTROLS, controls);
    setAttribute(slide, ROLE, slideFocus ? "button" : "");
    slideFocus && removeAttribute(slide, ARIA_ROLEDESCRIPTION);
  }
  function onMove() {
    if (!destroyed) {
      update();
    }
  }
  function update() {
    if (!destroyed) {
      var curr = Splide22.index;
      updateActivity();
      updateVisibility();
      toggleClass(slide, CLASS_PREV, index === curr - 1);
      toggleClass(slide, CLASS_NEXT, index === curr + 1);
    }
  }
  function updateActivity() {
    var active = isActive();
    if (active !== hasClass(slide, CLASS_ACTIVE)) {
      toggleClass(slide, CLASS_ACTIVE, active);
      setAttribute(slide, ARIA_CURRENT, isNavigation && active || "");
      emit(active ? EVENT_ACTIVE : EVENT_INACTIVE, self);
    }
  }
  function updateVisibility() {
    var visible = isVisible();
    var hidden = !visible && (!isActive() || isClone);
    if (!Splide22.state.is([MOVING, SCROLLING])) {
      setAttribute(slide, ARIA_HIDDEN, hidden || "");
    }
    setAttribute(queryAll(slide, options.focusableNodes || ""), TAB_INDEX, hidden ? -1 : "");
    if (slideFocus) {
      setAttribute(slide, TAB_INDEX, hidden ? -1 : 0);
    }
    if (visible !== hasClass(slide, CLASS_VISIBLE)) {
      toggleClass(slide, CLASS_VISIBLE, visible);
      emit(visible ? EVENT_VISIBLE : EVENT_HIDDEN, self);
    }
    if (!visible && document.activeElement === slide) {
      var Slide2 = Components.Slides.getAt(Splide22.index);
      Slide2 && focus(Slide2.slide);
    }
  }
  function style$1(prop, value, useContainer) {
    style(useContainer && container || slide, prop, value);
  }
  function isActive() {
    var curr = Splide22.index;
    return curr === index || options.cloneStatus && curr === slideIndex;
  }
  function isVisible() {
    if (Splide22.is(FADE)) {
      return isActive();
    }
    var trackRect = rect(Components.Elements.track);
    var slideRect = rect(slide);
    var left = resolve("left", true);
    var right = resolve("right", true);
    return floor(trackRect[left]) <= ceil(slideRect[left]) && floor(slideRect[right]) <= ceil(trackRect[right]);
  }
  function isWithin(from, distance) {
    var diff = abs(from - index);
    if (!isClone && (options.rewind || Splide22.is(LOOP))) {
      diff = min(diff, Splide22.length - diff);
    }
    return diff <= distance;
  }
  var self = {
    index,
    slideIndex,
    slide,
    container,
    isClone,
    mount,
    destroy,
    update,
    style: style$1,
    isWithin
  };
  return self;
}
function Slides(Splide22, Components2, options) {
  var _EventInterface2 = EventInterface(Splide22), on = _EventInterface2.on, emit = _EventInterface2.emit, bind = _EventInterface2.bind;
  var _Components2$Elements = Components2.Elements, slides = _Components2$Elements.slides, list = _Components2$Elements.list;
  var Slides2 = [];
  function mount() {
    init();
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, init);
  }
  function init() {
    slides.forEach(function(slide, index) {
      register(slide, index, -1);
    });
  }
  function destroy() {
    forEach$1(function(Slide2) {
      Slide2.destroy();
    });
    empty(Slides2);
  }
  function update() {
    forEach$1(function(Slide2) {
      Slide2.update();
    });
  }
  function register(slide, index, slideIndex) {
    var object = Slide$1(Splide22, index, slideIndex, slide);
    object.mount();
    Slides2.push(object);
    Slides2.sort(function(Slide1, Slide2) {
      return Slide1.index - Slide2.index;
    });
  }
  function get(excludeClones) {
    return excludeClones ? filter(function(Slide2) {
      return !Slide2.isClone;
    }) : Slides2;
  }
  function getIn(page) {
    var Controller2 = Components2.Controller;
    var index = Controller2.toIndex(page);
    var max2 = Controller2.hasFocus() ? 1 : options.perPage;
    return filter(function(Slide2) {
      return between(Slide2.index, index, index + max2 - 1);
    });
  }
  function getAt(index) {
    return filter(index)[0];
  }
  function add(items, index) {
    forEach(items, function(slide) {
      if (isString(slide)) {
        slide = parseHtml(slide);
      }
      if (isHTMLElement(slide)) {
        var ref = slides[index];
        ref ? before(slide, ref) : append(list, slide);
        addClass(slide, options.classes.slide);
        observeImages(slide, apply(emit, EVENT_RESIZE));
      }
    });
    emit(EVENT_REFRESH);
  }
  function remove$1(matcher) {
    remove(filter(matcher).map(function(Slide2) {
      return Slide2.slide;
    }));
    emit(EVENT_REFRESH);
  }
  function forEach$1(iteratee, excludeClones) {
    get(excludeClones).forEach(iteratee);
  }
  function filter(matcher) {
    return Slides2.filter(isFunction(matcher) ? matcher : function(Slide2) {
      return isString(matcher) ? matches(Slide2.slide, matcher) : includes(toArray(matcher), Slide2.index);
    });
  }
  function style2(prop, value, useContainer) {
    forEach$1(function(Slide2) {
      Slide2.style(prop, value, useContainer);
    });
  }
  function observeImages(elm, callback) {
    var images = queryAll(elm, "img");
    var length = images.length;
    if (length) {
      images.forEach(function(img) {
        bind(img, "load error", function() {
          if (!--length) {
            callback();
          }
        });
      });
    } else {
      callback();
    }
  }
  function getLength(excludeClones) {
    return excludeClones ? slides.length : Slides2.length;
  }
  function isEnough() {
    return Slides2.length > options.perPage;
  }
  return {
    mount,
    destroy,
    update,
    register,
    get,
    getIn,
    getAt,
    add,
    remove: remove$1,
    forEach: forEach$1,
    filter,
    style: style2,
    getLength,
    isEnough
  };
}
function Layout(Splide22, Components2, options) {
  var _EventInterface3 = EventInterface(Splide22), on = _EventInterface3.on, bind = _EventInterface3.bind, emit = _EventInterface3.emit;
  var Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var _Components2$Elements2 = Components2.Elements, root = _Components2$Elements2.root, track = _Components2$Elements2.track, list = _Components2$Elements2.list;
  var getAt = Slides2.getAt, styleSlides = Slides2.style;
  var vertical;
  var rootRect;
  var overflow;
  function mount() {
    init();
    bind(window, "resize load", Throttle(apply(emit, EVENT_RESIZE)));
    on([EVENT_UPDATED, EVENT_REFRESH], init);
    on(EVENT_RESIZE, resize);
  }
  function init() {
    vertical = options.direction === TTB;
    style(root, "maxWidth", unit(options.width));
    style(track, resolve("paddingLeft"), cssPadding(false));
    style(track, resolve("paddingRight"), cssPadding(true));
    resize(true);
  }
  function resize(force) {
    var newRect = rect(root);
    if (force || rootRect.width !== newRect.width || rootRect.height !== newRect.height) {
      style(track, "height", cssTrackHeight());
      styleSlides(resolve("marginRight"), unit(options.gap));
      styleSlides("width", cssSlideWidth());
      styleSlides("height", cssSlideHeight(), true);
      rootRect = newRect;
      emit(EVENT_RESIZED);
      if (overflow !== (overflow = isOverflow())) {
        toggleClass(root, CLASS_OVERFLOW, overflow);
        emit(EVENT_OVERFLOW, overflow);
      }
    }
  }
  function cssPadding(right) {
    var padding = options.padding;
    var prop = resolve(right ? "right" : "left");
    return padding && unit(padding[prop] || (isObject(padding) ? 0 : padding)) || "0px";
  }
  function cssTrackHeight() {
    var height = "";
    if (vertical) {
      height = cssHeight();
      assert(height, "height or heightRatio is missing.");
      height = "calc(" + height + " - " + cssPadding(false) + " - " + cssPadding(true) + ")";
    }
    return height;
  }
  function cssHeight() {
    return unit(options.height || rect(list).width * options.heightRatio);
  }
  function cssSlideWidth() {
    return options.autoWidth ? null : unit(options.fixedWidth) || (vertical ? "" : cssSlideSize());
  }
  function cssSlideHeight() {
    return unit(options.fixedHeight) || (vertical ? options.autoHeight ? null : cssSlideSize() : cssHeight());
  }
  function cssSlideSize() {
    var gap = unit(options.gap);
    return "calc((100%" + (gap && " + " + gap) + ")/" + (options.perPage || 1) + (gap && " - " + gap) + ")";
  }
  function listSize() {
    return rect(list)[resolve("width")];
  }
  function slideSize(index, withoutGap) {
    var Slide2 = getAt(index || 0);
    return Slide2 ? rect(Slide2.slide)[resolve("width")] + (withoutGap ? 0 : getGap()) : 0;
  }
  function totalSize(index, withoutGap) {
    var Slide2 = getAt(index);
    if (Slide2) {
      var right = rect(Slide2.slide)[resolve("right")];
      var left = rect(list)[resolve("left")];
      return abs(right - left) + (withoutGap ? 0 : getGap());
    }
    return 0;
  }
  function sliderSize(withoutGap) {
    return totalSize(Splide22.length - 1) - totalSize(0) + slideSize(0, withoutGap);
  }
  function getGap() {
    var Slide2 = getAt(0);
    return Slide2 && parseFloat(style(Slide2.slide, resolve("marginRight"))) || 0;
  }
  function getPadding(right) {
    return parseFloat(style(track, resolve("padding" + (right ? "Right" : "Left")))) || 0;
  }
  function isOverflow() {
    return Splide22.is(FADE) || sliderSize(true) > listSize();
  }
  return {
    mount,
    resize,
    listSize,
    slideSize,
    sliderSize,
    totalSize,
    getPadding,
    isOverflow
  };
}
var MULTIPLIER = 2;
function Clones(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on;
  var Elements2 = Components2.Elements, Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var clones = [];
  var cloneCount;
  function mount() {
    on(EVENT_REFRESH, remount);
    on([EVENT_UPDATED, EVENT_RESIZE], observe);
    if (cloneCount = computeCloneCount()) {
      generate(cloneCount);
      Components2.Layout.resize(true);
    }
  }
  function remount() {
    destroy();
    mount();
  }
  function destroy() {
    remove(clones);
    empty(clones);
    event.destroy();
  }
  function observe() {
    var count = computeCloneCount();
    if (cloneCount !== count) {
      if (cloneCount < count || !count) {
        event.emit(EVENT_REFRESH);
      }
    }
  }
  function generate(count) {
    var slides = Slides2.get().slice();
    var length = slides.length;
    if (length) {
      while (slides.length < count) {
        push(slides, slides);
      }
      push(slides.slice(-count), slides.slice(0, count)).forEach(function(Slide2, index) {
        var isHead = index < count;
        var clone = cloneDeep(Slide2.slide, index);
        isHead ? before(clone, slides[0].slide) : append(Elements2.list, clone);
        push(clones, clone);
        Slides2.register(clone, index - count + (isHead ? 0 : length), Slide2.index);
      });
    }
  }
  function cloneDeep(elm, index) {
    var clone = elm.cloneNode(true);
    addClass(clone, options.classes.clone);
    clone.id = Splide22.root.id + "-clone" + pad(index + 1);
    return clone;
  }
  function computeCloneCount() {
    var clones2 = options.clones;
    if (!Splide22.is(LOOP)) {
      clones2 = 0;
    } else if (isUndefined(clones2)) {
      var fixedSize = options[resolve("fixedWidth")] && Components2.Layout.slideSize(0);
      var fixedCount = fixedSize && ceil(rect(Elements2.track)[resolve("width")] / fixedSize);
      clones2 = fixedCount || options[resolve("autoWidth")] && Splide22.length || options.perPage * MULTIPLIER;
    }
    return clones2;
  }
  return {
    mount,
    destroy
  };
}
function Move(Splide22, Components2, options) {
  var _EventInterface4 = EventInterface(Splide22), on = _EventInterface4.on, emit = _EventInterface4.emit;
  var set = Splide22.state.set;
  var _Components2$Layout = Components2.Layout, slideSize = _Components2$Layout.slideSize, getPadding = _Components2$Layout.getPadding, totalSize = _Components2$Layout.totalSize, listSize = _Components2$Layout.listSize, sliderSize = _Components2$Layout.sliderSize;
  var _Components2$Directio = Components2.Direction, resolve = _Components2$Directio.resolve, orient = _Components2$Directio.orient;
  var _Components2$Elements3 = Components2.Elements, list = _Components2$Elements3.list, track = _Components2$Elements3.track;
  var Transition;
  function mount() {
    Transition = Components2.Transition;
    on([EVENT_MOUNTED, EVENT_RESIZED, EVENT_UPDATED, EVENT_REFRESH], reposition);
  }
  function reposition() {
    if (!Components2.Controller.isBusy()) {
      Components2.Scroll.cancel();
      jump(Splide22.index);
      Components2.Slides.update();
    }
  }
  function move(dest, index, prev, callback) {
    if (dest !== index && canShift(dest > prev)) {
      cancel();
      translate(shift(getPosition(), dest > prev), true);
    }
    set(MOVING);
    emit(EVENT_MOVE, index, prev, dest);
    Transition.start(index, function() {
      set(IDLE);
      emit(EVENT_MOVED, index, prev, dest);
      callback && callback();
    });
  }
  function jump(index) {
    translate(toPosition(index, true));
  }
  function translate(position, preventLoop) {
    if (!Splide22.is(FADE)) {
      var destination = preventLoop ? position : loop(position);
      style(list, "transform", "translate" + resolve("X") + "(" + destination + "px)");
      position !== destination && emit(EVENT_SHIFTED);
    }
  }
  function loop(position) {
    if (Splide22.is(LOOP)) {
      var index = toIndex(position);
      var exceededMax = index > Components2.Controller.getEnd();
      var exceededMin = index < 0;
      if (exceededMin || exceededMax) {
        position = shift(position, exceededMax);
      }
    }
    return position;
  }
  function shift(position, backwards) {
    var excess = position - getLimit(backwards);
    var size = sliderSize();
    position -= orient(size * (ceil(abs(excess) / size) || 1)) * (backwards ? 1 : -1);
    return position;
  }
  function cancel() {
    translate(getPosition(), true);
    Transition.cancel();
  }
  function toIndex(position) {
    var Slides2 = Components2.Slides.get();
    var index = 0;
    var minDistance = Infinity;
    for (var i = 0; i < Slides2.length; i++) {
      var slideIndex = Slides2[i].index;
      var distance = abs(toPosition(slideIndex, true) - position);
      if (distance <= minDistance) {
        minDistance = distance;
        index = slideIndex;
      } else {
        break;
      }
    }
    return index;
  }
  function toPosition(index, trimming) {
    var position = orient(totalSize(index - 1) - offset(index));
    return trimming ? trim(position) : position;
  }
  function getPosition() {
    var left = resolve("left");
    return rect(list)[left] - rect(track)[left] + orient(getPadding(false));
  }
  function trim(position) {
    if (options.trimSpace && Splide22.is(SLIDE)) {
      position = clamp(position, 0, orient(sliderSize(true) - listSize()));
    }
    return position;
  }
  function offset(index) {
    var focus2 = options.focus;
    return focus2 === "center" ? (listSize() - slideSize(index, true)) / 2 : +focus2 * slideSize(index) || 0;
  }
  function getLimit(max2) {
    return toPosition(max2 ? Components2.Controller.getEnd() : 0, !!options.trimSpace);
  }
  function canShift(backwards) {
    var shifted = orient(shift(getPosition(), backwards));
    return backwards ? shifted >= 0 : shifted <= list[resolve("scrollWidth")] - rect(track)[resolve("width")];
  }
  function exceededLimit(max2, position) {
    position = isUndefined(position) ? getPosition() : position;
    var exceededMin = max2 !== true && orient(position) < orient(getLimit(false));
    var exceededMax = max2 !== false && orient(position) > orient(getLimit(true));
    return exceededMin || exceededMax;
  }
  return {
    mount,
    move,
    jump,
    translate,
    shift,
    cancel,
    toIndex,
    toPosition,
    getPosition,
    getLimit,
    exceededLimit,
    reposition
  };
}
function Controller(Splide22, Components2, options) {
  var _EventInterface5 = EventInterface(Splide22), on = _EventInterface5.on, emit = _EventInterface5.emit;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, toPosition = Move2.toPosition;
  var _Components2$Slides = Components2.Slides, isEnough = _Components2$Slides.isEnough, getLength = _Components2$Slides.getLength;
  var omitEnd = options.omitEnd;
  var isLoop = Splide22.is(LOOP);
  var isSlide = Splide22.is(SLIDE);
  var getNext = apply(getAdjacent, false);
  var getPrev = apply(getAdjacent, true);
  var currIndex = options.start || 0;
  var endIndex;
  var prevIndex = currIndex;
  var slideCount;
  var perMove;
  var perPage;
  function mount() {
    init();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], init);
    on(EVENT_RESIZED, onResized);
  }
  function init() {
    slideCount = getLength(true);
    perMove = options.perMove;
    perPage = options.perPage;
    endIndex = getEnd();
    var index = clamp(currIndex, 0, omitEnd ? endIndex : slideCount - 1);
    if (index !== currIndex) {
      currIndex = index;
      Move2.reposition();
    }
  }
  function onResized() {
    if (endIndex !== getEnd()) {
      emit(EVENT_END_INDEX_CHANGED);
    }
  }
  function go(control, allowSameIndex, callback) {
    if (!isBusy()) {
      var dest = parse(control);
      var index = loop(dest);
      if (index > -1 && (allowSameIndex || index !== currIndex)) {
        setIndex(index);
        Move2.move(dest, index, prevIndex, callback);
      }
    }
  }
  function scroll(destination, duration, snap, callback) {
    Components2.Scroll.scroll(destination, duration, snap, function() {
      var index = loop(Move2.toIndex(getPosition()));
      setIndex(omitEnd ? min(index, endIndex) : index);
      callback && callback();
    });
  }
  function parse(control) {
    var index = currIndex;
    if (isString(control)) {
      var _ref = control.match(/([+\-<>])(\d+)?/) || [], indicator = _ref[1], number = _ref[2];
      if (indicator === "+" || indicator === "-") {
        index = computeDestIndex(currIndex + +("" + indicator + (+number || 1)), currIndex);
      } else if (indicator === ">") {
        index = number ? toIndex(+number) : getNext(true);
      } else if (indicator === "<") {
        index = getPrev(true);
      }
    } else {
      index = isLoop ? control : clamp(control, 0, endIndex);
    }
    return index;
  }
  function getAdjacent(prev, destination) {
    var number = perMove || (hasFocus() ? 1 : perPage);
    var dest = computeDestIndex(currIndex + number * (prev ? -1 : 1), currIndex, !(perMove || hasFocus()));
    if (dest === -1 && isSlide) {
      if (!approximatelyEqual(getPosition(), getLimit(!prev), 1)) {
        return prev ? 0 : endIndex;
      }
    }
    return destination ? dest : loop(dest);
  }
  function computeDestIndex(dest, from, snapPage) {
    if (isEnough() || hasFocus()) {
      var index = computeMovableDestIndex(dest);
      if (index !== dest) {
        from = dest;
        dest = index;
        snapPage = false;
      }
      if (dest < 0 || dest > endIndex) {
        if (!perMove && (between(0, dest, from, true) || between(endIndex, from, dest, true))) {
          dest = toIndex(toPage(dest));
        } else {
          if (isLoop) {
            dest = snapPage ? dest < 0 ? -(slideCount % perPage || perPage) : slideCount : dest;
          } else if (options.rewind) {
            dest = dest < 0 ? endIndex : 0;
          } else {
            dest = -1;
          }
        }
      } else {
        if (snapPage && dest !== from) {
          dest = toIndex(toPage(from) + (dest < from ? -1 : 1));
        }
      }
    } else {
      dest = -1;
    }
    return dest;
  }
  function computeMovableDestIndex(dest) {
    if (isSlide && options.trimSpace === "move" && dest !== currIndex) {
      var position = getPosition();
      while (position === toPosition(dest, true) && between(dest, 0, Splide22.length - 1, !options.rewind)) {
        dest < currIndex ? --dest : ++dest;
      }
    }
    return dest;
  }
  function loop(index) {
    return isLoop ? (index + slideCount) % slideCount || 0 : index;
  }
  function getEnd() {
    var end = slideCount - (hasFocus() || isLoop && perMove ? 1 : perPage);
    while (omitEnd && end-- > 0) {
      if (toPosition(slideCount - 1, true) !== toPosition(end, true)) {
        end++;
        break;
      }
    }
    return clamp(end, 0, slideCount - 1);
  }
  function toIndex(page) {
    return clamp(hasFocus() ? page : perPage * page, 0, endIndex);
  }
  function toPage(index) {
    return hasFocus() ? min(index, endIndex) : floor((index >= endIndex ? slideCount - 1 : index) / perPage);
  }
  function toDest(destination) {
    var closest2 = Move2.toIndex(destination);
    return isSlide ? clamp(closest2, 0, endIndex) : closest2;
  }
  function setIndex(index) {
    if (index !== currIndex) {
      prevIndex = currIndex;
      currIndex = index;
    }
  }
  function getIndex(prev) {
    return prev ? prevIndex : currIndex;
  }
  function hasFocus() {
    return !isUndefined(options.focus) || options.isNavigation;
  }
  function isBusy() {
    return Splide22.state.is([MOVING, SCROLLING]) && !!options.waitForTransition;
  }
  return {
    mount,
    go,
    scroll,
    getNext,
    getPrev,
    getAdjacent,
    getEnd,
    setIndex,
    getIndex,
    toIndex,
    toPage,
    toDest,
    hasFocus,
    isBusy
  };
}
var XML_NAME_SPACE = "http://www.w3.org/2000/svg";
var PATH = "m15.5 0.932-4.3 4.38 14.5 14.6-14.5 14.5 4.3 4.4 14.6-14.6 4.4-4.3-4.4-4.4-14.6-14.6z";
var SIZE = 40;
function Arrows(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, bind = event.bind, emit = event.emit;
  var classes = options.classes, i18n = options.i18n;
  var Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var placeholder = Elements2.arrows, track = Elements2.track;
  var wrapper = placeholder;
  var prev = Elements2.prev;
  var next = Elements2.next;
  var created;
  var wrapperClasses;
  var arrows = {};
  function mount() {
    init();
    on(EVENT_UPDATED, remount);
  }
  function remount() {
    destroy();
    mount();
  }
  function init() {
    var enabled = options.arrows;
    if (enabled && !(prev && next)) {
      createArrows();
    }
    if (prev && next) {
      assign(arrows, {
        prev,
        next
      });
      display(wrapper, enabled ? "" : "none");
      addClass(wrapper, wrapperClasses = CLASS_ARROWS + "--" + options.direction);
      if (enabled) {
        listen();
        update();
        setAttribute([prev, next], ARIA_CONTROLS, track.id);
        emit(EVENT_ARROWS_MOUNTED, prev, next);
      }
    }
  }
  function destroy() {
    event.destroy();
    removeClass(wrapper, wrapperClasses);
    if (created) {
      remove(placeholder ? [prev, next] : wrapper);
      prev = next = null;
    } else {
      removeAttribute([prev, next], ALL_ATTRIBUTES);
    }
  }
  function listen() {
    on([EVENT_MOUNTED, EVENT_MOVED, EVENT_REFRESH, EVENT_SCROLLED, EVENT_END_INDEX_CHANGED], update);
    bind(next, "click", apply(go, ">"));
    bind(prev, "click", apply(go, "<"));
  }
  function go(control) {
    Controller2.go(control, true);
  }
  function createArrows() {
    wrapper = placeholder || create("div", classes.arrows);
    prev = createArrow(true);
    next = createArrow(false);
    created = true;
    append(wrapper, [prev, next]);
    !placeholder && before(wrapper, track);
  }
  function createArrow(prev2) {
    var arrow = '<button class="' + classes.arrow + " " + (prev2 ? classes.prev : classes.next) + '" type="button"><svg xmlns="' + XML_NAME_SPACE + '" viewBox="0 0 ' + SIZE + " " + SIZE + '" width="' + SIZE + '" height="' + SIZE + '" focusable="false"><path d="' + (options.arrowPath || PATH) + '" />';
    return parseHtml(arrow);
  }
  function update() {
    if (prev && next) {
      var index = Splide22.index;
      var prevIndex = Controller2.getPrev();
      var nextIndex = Controller2.getNext();
      var prevLabel = prevIndex > -1 && index < prevIndex ? i18n.last : i18n.prev;
      var nextLabel = nextIndex > -1 && index > nextIndex ? i18n.first : i18n.next;
      prev.disabled = prevIndex < 0;
      next.disabled = nextIndex < 0;
      setAttribute(prev, ARIA_LABEL, prevLabel);
      setAttribute(next, ARIA_LABEL, nextLabel);
      emit(EVENT_ARROWS_UPDATED, prev, next, prevIndex, nextIndex);
    }
  }
  return {
    arrows,
    mount,
    destroy,
    update
  };
}
var INTERVAL_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-interval";
function Autoplay(Splide22, Components2, options) {
  var _EventInterface6 = EventInterface(Splide22), on = _EventInterface6.on, bind = _EventInterface6.bind, emit = _EventInterface6.emit;
  var interval = RequestInterval(options.interval, Splide22.go.bind(Splide22, ">"), onAnimationFrame);
  var isPaused = interval.isPaused;
  var Elements2 = Components2.Elements, _Components2$Elements4 = Components2.Elements, root = _Components2$Elements4.root, toggle = _Components2$Elements4.toggle;
  var autoplay = options.autoplay;
  var hovered;
  var focused;
  var stopped = autoplay === "pause";
  function mount() {
    if (autoplay) {
      listen();
      toggle && setAttribute(toggle, ARIA_CONTROLS, Elements2.track.id);
      stopped || play();
      update();
    }
  }
  function listen() {
    if (options.pauseOnHover) {
      bind(root, "mouseenter mouseleave", function(e) {
        hovered = e.type === "mouseenter";
        autoToggle();
      });
    }
    if (options.pauseOnFocus) {
      bind(root, "focusin focusout", function(e) {
        focused = e.type === "focusin";
        autoToggle();
      });
    }
    if (toggle) {
      bind(toggle, "click", function() {
        stopped ? play() : pause(true);
      });
    }
    on([EVENT_MOVE, EVENT_SCROLL, EVENT_REFRESH], interval.rewind);
    on(EVENT_MOVE, onMove);
  }
  function play() {
    if (isPaused() && Components2.Slides.isEnough()) {
      interval.start(!options.resetProgress);
      focused = hovered = stopped = false;
      update();
      emit(EVENT_AUTOPLAY_PLAY);
    }
  }
  function pause(stop) {
    if (stop === void 0) {
      stop = true;
    }
    stopped = !!stop;
    update();
    if (!isPaused()) {
      interval.pause();
      emit(EVENT_AUTOPLAY_PAUSE);
    }
  }
  function autoToggle() {
    if (!stopped) {
      hovered || focused ? pause(false) : play();
    }
  }
  function update() {
    if (toggle) {
      toggleClass(toggle, CLASS_ACTIVE, !stopped);
      setAttribute(toggle, ARIA_LABEL, options.i18n[stopped ? "play" : "pause"]);
    }
  }
  function onAnimationFrame(rate) {
    var bar = Elements2.bar;
    bar && style(bar, "width", rate * 100 + "%");
    emit(EVENT_AUTOPLAY_PLAYING, rate);
  }
  function onMove(index) {
    var Slide2 = Components2.Slides.getAt(index);
    interval.set(Slide2 && +getAttribute(Slide2.slide, INTERVAL_DATA_ATTRIBUTE) || options.interval);
  }
  return {
    mount,
    destroy: interval.cancel,
    play,
    pause,
    isPaused
  };
}
function Cover(Splide22, Components2, options) {
  var _EventInterface7 = EventInterface(Splide22), on = _EventInterface7.on;
  function mount() {
    if (options.cover) {
      on(EVENT_LAZYLOAD_LOADED, apply(toggle, true));
      on([EVENT_MOUNTED, EVENT_UPDATED, EVENT_REFRESH], apply(cover, true));
    }
  }
  function cover(cover2) {
    Components2.Slides.forEach(function(Slide2) {
      var img = child(Slide2.container || Slide2.slide, "img");
      if (img && img.src) {
        toggle(cover2, img, Slide2);
      }
    });
  }
  function toggle(cover2, img, Slide2) {
    Slide2.style("background", cover2 ? 'center/cover no-repeat url("' + img.src + '")' : "", true);
    display(img, cover2 ? "none" : "");
  }
  return {
    mount,
    destroy: apply(cover, false)
  };
}
var BOUNCE_DIFF_THRESHOLD = 10;
var BOUNCE_DURATION = 600;
var FRICTION_FACTOR = 0.6;
var BASE_VELOCITY = 1.5;
var MIN_DURATION = 800;
function Scroll(Splide22, Components2, options) {
  var _EventInterface8 = EventInterface(Splide22), on = _EventInterface8.on, emit = _EventInterface8.emit;
  var set = Splide22.state.set;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, exceededLimit = Move2.exceededLimit, translate = Move2.translate;
  var isSlide = Splide22.is(SLIDE);
  var interval;
  var callback;
  var friction = 1;
  function mount() {
    on(EVENT_MOVE, clear);
    on([EVENT_UPDATED, EVENT_REFRESH], cancel);
  }
  function scroll(destination, duration, snap, onScrolled, noConstrain) {
    var from = getPosition();
    clear();
    if (snap && (!isSlide || !exceededLimit())) {
      var size = Components2.Layout.sliderSize();
      var offset = sign(destination) * size * floor(abs(destination) / size) || 0;
      destination = Move2.toPosition(Components2.Controller.toDest(destination % size)) + offset;
    }
    var noDistance = approximatelyEqual(from, destination, 1);
    friction = 1;
    duration = noDistance ? 0 : duration || max(abs(destination - from) / BASE_VELOCITY, MIN_DURATION);
    callback = onScrolled;
    interval = RequestInterval(duration, onEnd, apply(update, from, destination, noConstrain), 1);
    set(SCROLLING);
    emit(EVENT_SCROLL);
    interval.start();
  }
  function onEnd() {
    set(IDLE);
    callback && callback();
    emit(EVENT_SCROLLED);
  }
  function update(from, to, noConstrain, rate) {
    var position = getPosition();
    var target = from + (to - from) * easing(rate);
    var diff = (target - position) * friction;
    translate(position + diff);
    if (isSlide && !noConstrain && exceededLimit()) {
      friction *= FRICTION_FACTOR;
      if (abs(diff) < BOUNCE_DIFF_THRESHOLD) {
        scroll(getLimit(exceededLimit(true)), BOUNCE_DURATION, false, callback, true);
      }
    }
  }
  function clear() {
    if (interval) {
      interval.cancel();
    }
  }
  function cancel() {
    if (interval && !interval.isPaused()) {
      clear();
      onEnd();
    }
  }
  function easing(t) {
    var easingFunc = options.easingFunc;
    return easingFunc ? easingFunc(t) : 1 - Math.pow(1 - t, 4);
  }
  return {
    mount,
    destroy: clear,
    scroll,
    cancel
  };
}
var SCROLL_LISTENER_OPTIONS = {
  passive: false,
  capture: true
};
function Drag(Splide22, Components2, options) {
  var _EventInterface9 = EventInterface(Splide22), on = _EventInterface9.on, emit = _EventInterface9.emit, bind = _EventInterface9.bind, unbind = _EventInterface9.unbind;
  var state = Splide22.state;
  var Move2 = Components2.Move, Scroll2 = Components2.Scroll, Controller2 = Components2.Controller, track = Components2.Elements.track, reduce = Components2.Media.reduce;
  var _Components2$Directio2 = Components2.Direction, resolve = _Components2$Directio2.resolve, orient = _Components2$Directio2.orient;
  var getPosition = Move2.getPosition, exceededLimit = Move2.exceededLimit;
  var basePosition;
  var baseEvent;
  var prevBaseEvent;
  var isFree;
  var dragging;
  var exceeded = false;
  var clickPrevented;
  var disabled;
  var target;
  function mount() {
    bind(track, POINTER_MOVE_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_UP_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_DOWN_EVENTS, onPointerDown, SCROLL_LISTENER_OPTIONS);
    bind(track, "click", onClick, {
      capture: true
    });
    bind(track, "dragstart", prevent);
    on([EVENT_MOUNTED, EVENT_UPDATED], init);
  }
  function init() {
    var drag = options.drag;
    disable(!drag);
    isFree = drag === "free";
  }
  function onPointerDown(e) {
    clickPrevented = false;
    if (!disabled) {
      var isTouch = isTouchEvent(e);
      if (isDraggable(e.target) && (isTouch || !e.button)) {
        if (!Controller2.isBusy()) {
          target = isTouch ? track : window;
          dragging = state.is([MOVING, SCROLLING]);
          prevBaseEvent = null;
          bind(target, POINTER_MOVE_EVENTS, onPointerMove, SCROLL_LISTENER_OPTIONS);
          bind(target, POINTER_UP_EVENTS, onPointerUp, SCROLL_LISTENER_OPTIONS);
          Move2.cancel();
          Scroll2.cancel();
          save(e);
        } else {
          prevent(e, true);
        }
      }
    }
  }
  function onPointerMove(e) {
    if (!state.is(DRAGGING)) {
      state.set(DRAGGING);
      emit(EVENT_DRAG);
    }
    if (e.cancelable) {
      if (dragging) {
        Move2.translate(basePosition + constrain(diffCoord(e)));
        var expired = diffTime(e) > LOG_INTERVAL;
        var hasExceeded = exceeded !== (exceeded = exceededLimit());
        if (expired || hasExceeded) {
          save(e);
        }
        clickPrevented = true;
        emit(EVENT_DRAGGING);
        prevent(e);
      } else if (isSliderDirection(e)) {
        dragging = shouldStart(e);
        prevent(e);
      }
    }
  }
  function onPointerUp(e) {
    if (state.is(DRAGGING)) {
      state.set(IDLE);
      emit(EVENT_DRAGGED);
    }
    if (dragging) {
      move(e);
      prevent(e);
    }
    unbind(target, POINTER_MOVE_EVENTS, onPointerMove);
    unbind(target, POINTER_UP_EVENTS, onPointerUp);
    dragging = false;
  }
  function onClick(e) {
    if (!disabled && clickPrevented) {
      prevent(e, true);
    }
  }
  function save(e) {
    prevBaseEvent = baseEvent;
    baseEvent = e;
    basePosition = getPosition();
  }
  function move(e) {
    var velocity = computeVelocity(e);
    var destination = computeDestination(velocity);
    var rewind = options.rewind && options.rewindByDrag;
    reduce(false);
    if (isFree) {
      Controller2.scroll(destination, 0, options.snap);
    } else if (Splide22.is(FADE)) {
      Controller2.go(orient(sign(velocity)) < 0 ? rewind ? "<" : "-" : rewind ? ">" : "+");
    } else if (Splide22.is(SLIDE) && exceeded && rewind) {
      Controller2.go(exceededLimit(true) ? ">" : "<");
    } else {
      Controller2.go(Controller2.toDest(destination), true);
    }
    reduce(true);
  }
  function shouldStart(e) {
    var thresholds = options.dragMinThreshold;
    var isObj = isObject(thresholds);
    var mouse = isObj && thresholds.mouse || 0;
    var touch = (isObj ? thresholds.touch : +thresholds) || 10;
    return abs(diffCoord(e)) > (isTouchEvent(e) ? touch : mouse);
  }
  function isSliderDirection(e) {
    return abs(diffCoord(e)) > abs(diffCoord(e, true));
  }
  function computeVelocity(e) {
    if (Splide22.is(LOOP) || !exceeded) {
      var time = diffTime(e);
      if (time && time < LOG_INTERVAL) {
        return diffCoord(e) / time;
      }
    }
    return 0;
  }
  function computeDestination(velocity) {
    return getPosition() + sign(velocity) * min(abs(velocity) * (options.flickPower || 600), isFree ? Infinity : Components2.Layout.listSize() * (options.flickMaxPages || 1));
  }
  function diffCoord(e, orthogonal) {
    return coordOf(e, orthogonal) - coordOf(getBaseEvent(e), orthogonal);
  }
  function diffTime(e) {
    return timeOf(e) - timeOf(getBaseEvent(e));
  }
  function getBaseEvent(e) {
    return baseEvent === e && prevBaseEvent || baseEvent;
  }
  function coordOf(e, orthogonal) {
    return (isTouchEvent(e) ? e.changedTouches[0] : e)["page" + resolve(orthogonal ? "Y" : "X")];
  }
  function constrain(diff) {
    return diff / (exceeded && Splide22.is(SLIDE) ? FRICTION : 1);
  }
  function isDraggable(target2) {
    var noDrag = options.noDrag;
    return !matches(target2, "." + CLASS_PAGINATION_PAGE + ", ." + CLASS_ARROW) && (!noDrag || !matches(target2, noDrag));
  }
  function isTouchEvent(e) {
    return typeof TouchEvent !== "undefined" && e instanceof TouchEvent;
  }
  function isDragging() {
    return dragging;
  }
  function disable(value) {
    disabled = value;
  }
  return {
    mount,
    disable,
    isDragging
  };
}
var NORMALIZATION_MAP = {
  Spacebar: " ",
  Right: ARROW_RIGHT,
  Left: ARROW_LEFT,
  Up: ARROW_UP,
  Down: ARROW_DOWN
};
function normalizeKey(key) {
  key = isString(key) ? key : key.key;
  return NORMALIZATION_MAP[key] || key;
}
var KEYBOARD_EVENT = "keydown";
function Keyboard(Splide22, Components2, options) {
  var _EventInterface10 = EventInterface(Splide22), on = _EventInterface10.on, bind = _EventInterface10.bind, unbind = _EventInterface10.unbind;
  var root = Splide22.root;
  var resolve = Components2.Direction.resolve;
  var target;
  var disabled;
  function mount() {
    init();
    on(EVENT_UPDATED, destroy);
    on(EVENT_UPDATED, init);
    on(EVENT_MOVE, onMove);
  }
  function init() {
    var keyboard = options.keyboard;
    if (keyboard) {
      target = keyboard === "global" ? window : root;
      bind(target, KEYBOARD_EVENT, onKeydown);
    }
  }
  function destroy() {
    unbind(target, KEYBOARD_EVENT);
  }
  function disable(value) {
    disabled = value;
  }
  function onMove() {
    var _disabled = disabled;
    disabled = true;
    nextTick(function() {
      disabled = _disabled;
    });
  }
  function onKeydown(e) {
    if (!disabled) {
      var key = normalizeKey(e);
      if (key === resolve(ARROW_LEFT)) {
        Splide22.go("<");
      } else if (key === resolve(ARROW_RIGHT)) {
        Splide22.go(">");
      }
    }
  }
  return {
    mount,
    destroy,
    disable
  };
}
var SRC_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-lazy";
var SRCSET_DATA_ATTRIBUTE = SRC_DATA_ATTRIBUTE + "-srcset";
var IMAGE_SELECTOR = "[" + SRC_DATA_ATTRIBUTE + "], [" + SRCSET_DATA_ATTRIBUTE + "]";
function LazyLoad(Splide22, Components2, options) {
  var _EventInterface11 = EventInterface(Splide22), on = _EventInterface11.on, off = _EventInterface11.off, bind = _EventInterface11.bind, emit = _EventInterface11.emit;
  var isSequential = options.lazyLoad === "sequential";
  var events = [EVENT_MOVED, EVENT_SCROLLED];
  var entries = [];
  function mount() {
    if (options.lazyLoad) {
      init();
      on(EVENT_REFRESH, init);
    }
  }
  function init() {
    empty(entries);
    register();
    if (isSequential) {
      loadNext();
    } else {
      off(events);
      on(events, check);
      check();
    }
  }
  function register() {
    Components2.Slides.forEach(function(Slide2) {
      queryAll(Slide2.slide, IMAGE_SELECTOR).forEach(function(img) {
        var src = getAttribute(img, SRC_DATA_ATTRIBUTE);
        var srcset = getAttribute(img, SRCSET_DATA_ATTRIBUTE);
        if (src !== img.src || srcset !== img.srcset) {
          var className = options.classes.spinner;
          var parent = img.parentElement;
          var spinner = child(parent, "." + className) || create("span", className, parent);
          entries.push([img, Slide2, spinner]);
          img.src || display(img, "none");
        }
      });
    });
  }
  function check() {
    entries = entries.filter(function(data) {
      var distance = options.perPage * ((options.preloadPages || 1) + 1) - 1;
      return data[1].isWithin(Splide22.index, distance) ? load(data) : true;
    });
    entries.length || off(events);
  }
  function load(data) {
    var img = data[0];
    addClass(data[1].slide, CLASS_LOADING);
    bind(img, "load error", apply(onLoad, data));
    setAttribute(img, "src", getAttribute(img, SRC_DATA_ATTRIBUTE));
    setAttribute(img, "srcset", getAttribute(img, SRCSET_DATA_ATTRIBUTE));
    removeAttribute(img, SRC_DATA_ATTRIBUTE);
    removeAttribute(img, SRCSET_DATA_ATTRIBUTE);
  }
  function onLoad(data, e) {
    var img = data[0], Slide2 = data[1];
    removeClass(Slide2.slide, CLASS_LOADING);
    if (e.type !== "error") {
      remove(data[2]);
      display(img, "");
      emit(EVENT_LAZYLOAD_LOADED, img, Slide2);
      emit(EVENT_RESIZE);
    }
    isSequential && loadNext();
  }
  function loadNext() {
    entries.length && load(entries.shift());
  }
  return {
    mount,
    destroy: apply(empty, entries),
    check
  };
}
function Pagination(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Slides2 = Components2.Slides, Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var hasFocus = Controller2.hasFocus, getIndex = Controller2.getIndex, go = Controller2.go;
  var resolve = Components2.Direction.resolve;
  var placeholder = Elements2.pagination;
  var items = [];
  var list;
  var paginationClasses;
  function mount() {
    destroy();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], mount);
    var enabled = options.pagination;
    placeholder && display(placeholder, enabled ? "" : "none");
    if (enabled) {
      on([EVENT_MOVE, EVENT_SCROLL, EVENT_SCROLLED], update);
      createPagination();
      update();
      emit(EVENT_PAGINATION_MOUNTED, {
        list,
        items
      }, getAt(Splide22.index));
    }
  }
  function destroy() {
    if (list) {
      remove(placeholder ? slice(list.children) : list);
      removeClass(list, paginationClasses);
      empty(items);
      list = null;
    }
    event.destroy();
  }
  function createPagination() {
    var length = Splide22.length;
    var classes = options.classes, i18n = options.i18n, perPage = options.perPage;
    var max2 = hasFocus() ? Controller2.getEnd() + 1 : ceil(length / perPage);
    list = placeholder || create("ul", classes.pagination, Elements2.track.parentElement);
    addClass(list, paginationClasses = CLASS_PAGINATION + "--" + getDirection());
    setAttribute(list, ROLE, "tablist");
    setAttribute(list, ARIA_LABEL, i18n.select);
    setAttribute(list, ARIA_ORIENTATION, getDirection() === TTB ? "vertical" : "");
    for (var i = 0; i < max2; i++) {
      var li = create("li", null, list);
      var button = create("button", {
        class: classes.page,
        type: "button"
      }, li);
      var controls = Slides2.getIn(i).map(function(Slide2) {
        return Slide2.slide.id;
      });
      var text = !hasFocus() && perPage > 1 ? i18n.pageX : i18n.slideX;
      bind(button, "click", apply(onClick, i));
      if (options.paginationKeyboard) {
        bind(button, "keydown", apply(onKeydown, i));
      }
      setAttribute(li, ROLE, "presentation");
      setAttribute(button, ROLE, "tab");
      setAttribute(button, ARIA_CONTROLS, controls.join(" "));
      setAttribute(button, ARIA_LABEL, format(text, i + 1));
      setAttribute(button, TAB_INDEX, -1);
      items.push({
        li,
        button,
        page: i
      });
    }
  }
  function onClick(page) {
    go(">" + page, true);
  }
  function onKeydown(page, e) {
    var length = items.length;
    var key = normalizeKey(e);
    var dir = getDirection();
    var nextPage = -1;
    if (key === resolve(ARROW_RIGHT, false, dir)) {
      nextPage = ++page % length;
    } else if (key === resolve(ARROW_LEFT, false, dir)) {
      nextPage = (--page + length) % length;
    } else if (key === "Home") {
      nextPage = 0;
    } else if (key === "End") {
      nextPage = length - 1;
    }
    var item = items[nextPage];
    if (item) {
      focus(item.button);
      go(">" + nextPage);
      prevent(e, true);
    }
  }
  function getDirection() {
    return options.paginationDirection || options.direction;
  }
  function getAt(index) {
    return items[Controller2.toPage(index)];
  }
  function update() {
    var prev = getAt(getIndex(true));
    var curr = getAt(getIndex());
    if (prev) {
      var button = prev.button;
      removeClass(button, CLASS_ACTIVE);
      removeAttribute(button, ARIA_SELECTED);
      setAttribute(button, TAB_INDEX, -1);
    }
    if (curr) {
      var _button = curr.button;
      addClass(_button, CLASS_ACTIVE);
      setAttribute(_button, ARIA_SELECTED, true);
      setAttribute(_button, TAB_INDEX, "");
    }
    emit(EVENT_PAGINATION_UPDATED, {
      list,
      items
    }, prev, curr);
  }
  return {
    items,
    mount,
    destroy,
    getAt,
    update
  };
}
var TRIGGER_KEYS = [" ", "Enter"];
function Sync(Splide22, Components2, options) {
  var isNavigation = options.isNavigation, slideFocus = options.slideFocus;
  var events = [];
  function mount() {
    Splide22.splides.forEach(function(target) {
      if (!target.isParent) {
        sync(Splide22, target.splide);
        sync(target.splide, Splide22);
      }
    });
    if (isNavigation) {
      navigate();
    }
  }
  function destroy() {
    events.forEach(function(event) {
      event.destroy();
    });
    empty(events);
  }
  function remount() {
    destroy();
    mount();
  }
  function sync(splide, target) {
    var event = EventInterface(splide);
    event.on(EVENT_MOVE, function(index, prev, dest) {
      target.go(target.is(LOOP) ? dest : index);
    });
    events.push(event);
  }
  function navigate() {
    var event = EventInterface(Splide22);
    var on = event.on;
    on(EVENT_CLICK, onClick);
    on(EVENT_SLIDE_KEYDOWN, onKeydown);
    on([EVENT_MOUNTED, EVENT_UPDATED], update);
    events.push(event);
    event.emit(EVENT_NAVIGATION_MOUNTED, Splide22.splides);
  }
  function update() {
    setAttribute(Components2.Elements.list, ARIA_ORIENTATION, options.direction === TTB ? "vertical" : "");
  }
  function onClick(Slide2) {
    Splide22.go(Slide2.index);
  }
  function onKeydown(Slide2, e) {
    if (includes(TRIGGER_KEYS, normalizeKey(e))) {
      onClick(Slide2);
      prevent(e);
    }
  }
  return {
    setup: apply(Components2.Media.set, {
      slideFocus: isUndefined(slideFocus) ? isNavigation : slideFocus
    }, true),
    mount,
    destroy,
    remount
  };
}
function Wheel(Splide22, Components2, options) {
  var _EventInterface12 = EventInterface(Splide22), bind = _EventInterface12.bind;
  var lastTime = 0;
  function mount() {
    if (options.wheel) {
      bind(Components2.Elements.track, "wheel", onWheel, SCROLL_LISTENER_OPTIONS);
    }
  }
  function onWheel(e) {
    if (e.cancelable) {
      var deltaY = e.deltaY;
      var backwards = deltaY < 0;
      var timeStamp = timeOf(e);
      var _min = options.wheelMinThreshold || 0;
      var sleep = options.wheelSleep || 0;
      if (abs(deltaY) > _min && timeStamp - lastTime > sleep) {
        Splide22.go(backwards ? "<" : ">");
        lastTime = timeStamp;
      }
      shouldPrevent(backwards) && prevent(e);
    }
  }
  function shouldPrevent(backwards) {
    return !options.releaseWheel || Splide22.state.is(MOVING) || Components2.Controller.getAdjacent(backwards) !== -1;
  }
  return {
    mount
  };
}
var SR_REMOVAL_DELAY = 90;
function Live(Splide22, Components2, options) {
  var _EventInterface13 = EventInterface(Splide22), on = _EventInterface13.on;
  var track = Components2.Elements.track;
  var enabled = options.live && !options.isNavigation;
  var sr = create("span", CLASS_SR);
  var interval = RequestInterval(SR_REMOVAL_DELAY, apply(toggle, false));
  function mount() {
    if (enabled) {
      disable(!Components2.Autoplay.isPaused());
      setAttribute(track, ARIA_ATOMIC, true);
      sr.textContent = "\u2026";
      on(EVENT_AUTOPLAY_PLAY, apply(disable, true));
      on(EVENT_AUTOPLAY_PAUSE, apply(disable, false));
      on([EVENT_MOVED, EVENT_SCROLLED], apply(toggle, true));
    }
  }
  function toggle(active) {
    setAttribute(track, ARIA_BUSY, active);
    if (active) {
      append(track, sr);
      interval.start();
    } else {
      remove(sr);
      interval.cancel();
    }
  }
  function destroy() {
    removeAttribute(track, [ARIA_LIVE, ARIA_ATOMIC, ARIA_BUSY]);
    remove(sr);
  }
  function disable(disabled) {
    if (enabled) {
      setAttribute(track, ARIA_LIVE, disabled ? "off" : "polite");
    }
  }
  return {
    mount,
    disable,
    destroy
  };
}
var ComponentConstructors = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  Media,
  Direction,
  Elements,
  Slides,
  Layout,
  Clones,
  Move,
  Controller,
  Arrows,
  Autoplay,
  Cover,
  Scroll,
  Drag,
  Keyboard,
  LazyLoad,
  Pagination,
  Sync,
  Wheel,
  Live
});
var I18N = {
  prev: "Previous slide",
  next: "Next slide",
  first: "Go to first slide",
  last: "Go to last slide",
  slideX: "Go to slide %s",
  pageX: "Go to page %s",
  play: "Start autoplay",
  pause: "Pause autoplay",
  carousel: "carousel",
  slide: "slide",
  select: "Select a slide to show",
  slideLabel: "%s of %s"
};
var DEFAULTS = {
  type: "slide",
  role: "region",
  speed: 400,
  perPage: 1,
  cloneStatus: true,
  arrows: true,
  pagination: true,
  paginationKeyboard: true,
  interval: 5e3,
  pauseOnHover: true,
  pauseOnFocus: true,
  resetProgress: true,
  easing: "cubic-bezier(0.25, 1, 0.5, 1)",
  drag: true,
  direction: "ltr",
  trimSpace: true,
  focusableNodes: "a, button, textarea, input, select, iframe",
  live: true,
  classes: CLASSES,
  i18n: I18N,
  reducedMotion: {
    speed: 0,
    rewindSpeed: 0,
    autoplay: "pause"
  }
};
function Fade(Splide22, Components2, options) {
  var Slides2 = Components2.Slides;
  function mount() {
    EventInterface(Splide22).on([EVENT_MOUNTED, EVENT_REFRESH], init);
  }
  function init() {
    Slides2.forEach(function(Slide2) {
      Slide2.style("transform", "translateX(-" + 100 * Slide2.index + "%)");
    });
  }
  function start(index, done) {
    Slides2.style("transition", "opacity " + options.speed + "ms " + options.easing);
    nextTick(done);
  }
  return {
    mount,
    start,
    cancel: noop
  };
}
function Slide(Splide22, Components2, options) {
  var Move2 = Components2.Move, Controller2 = Components2.Controller, Scroll2 = Components2.Scroll;
  var list = Components2.Elements.list;
  var transition = apply(style, list, "transition");
  var endCallback;
  function mount() {
    EventInterface(Splide22).bind(list, "transitionend", function(e) {
      if (e.target === list && endCallback) {
        cancel();
        endCallback();
      }
    });
  }
  function start(index, done) {
    var destination = Move2.toPosition(index, true);
    var position = Move2.getPosition();
    var speed = getSpeed(index);
    if (abs(destination - position) >= 1 && speed >= 1) {
      if (options.useScroll) {
        Scroll2.scroll(destination, speed, false, done);
      } else {
        transition("transform " + speed + "ms " + options.easing);
        Move2.translate(destination, true);
        endCallback = done;
      }
    } else {
      Move2.jump(index);
      done();
    }
  }
  function cancel() {
    transition("");
    Scroll2.cancel();
  }
  function getSpeed(index) {
    var rewindSpeed = options.rewindSpeed;
    if (Splide22.is(SLIDE) && rewindSpeed) {
      var prev = Controller2.getIndex(true);
      var end = Controller2.getEnd();
      if (prev === 0 && index >= end || prev >= end && index === 0) {
        return rewindSpeed;
      }
    }
    return options.speed;
  }
  return {
    mount,
    start,
    cancel
  };
}
var _Splide = /* @__PURE__ */ function() {
  function _Splide2(target, options) {
    this.event = EventInterface();
    this.Components = {};
    this.state = State(CREATED);
    this.splides = [];
    this._o = {};
    this._E = {};
    var root = isString(target) ? query(document, target) : target;
    assert(root, root + " is invalid.");
    this.root = root;
    options = merge({
      label: getAttribute(root, ARIA_LABEL) || "",
      labelledby: getAttribute(root, ARIA_LABELLEDBY) || ""
    }, DEFAULTS, _Splide2.defaults, options || {});
    try {
      merge(options, JSON.parse(getAttribute(root, DATA_ATTRIBUTE)));
    } catch (e) {
      assert(false, "Invalid JSON");
    }
    this._o = Object.create(merge({}, options));
  }
  var _proto = _Splide2.prototype;
  _proto.mount = function mount(Extensions, Transition) {
    var _this = this;
    var state = this.state, Components2 = this.Components;
    assert(state.is([CREATED, DESTROYED]), "Already mounted!");
    state.set(CREATED);
    this._C = Components2;
    this._T = Transition || this._T || (this.is(FADE) ? Fade : Slide);
    this._E = Extensions || this._E;
    var Constructors = assign({}, ComponentConstructors, this._E, {
      Transition: this._T
    });
    forOwn(Constructors, function(Component, key) {
      var component = Component(_this, Components2, _this._o);
      Components2[key] = component;
      component.setup && component.setup();
    });
    forOwn(Components2, function(component) {
      component.mount && component.mount();
    });
    this.emit(EVENT_MOUNTED);
    addClass(this.root, CLASS_INITIALIZED);
    state.set(IDLE);
    this.emit(EVENT_READY);
    return this;
  };
  _proto.sync = function sync(splide) {
    this.splides.push({
      splide
    });
    splide.splides.push({
      splide: this,
      isParent: true
    });
    if (this.state.is(IDLE)) {
      this._C.Sync.remount();
      splide.Components.Sync.remount();
    }
    return this;
  };
  _proto.go = function go(control) {
    this._C.Controller.go(control);
    return this;
  };
  _proto.on = function on(events, callback) {
    this.event.on(events, callback);
    return this;
  };
  _proto.off = function off(events) {
    this.event.off(events);
    return this;
  };
  _proto.emit = function emit(event) {
    var _this$event;
    (_this$event = this.event).emit.apply(_this$event, [event].concat(slice(arguments, 1)));
    return this;
  };
  _proto.add = function add(slides, index) {
    this._C.Slides.add(slides, index);
    return this;
  };
  _proto.remove = function remove2(matcher) {
    this._C.Slides.remove(matcher);
    return this;
  };
  _proto.is = function is(type) {
    return this._o.type === type;
  };
  _proto.refresh = function refresh() {
    this.emit(EVENT_REFRESH);
    return this;
  };
  _proto.destroy = function destroy(completely) {
    if (completely === void 0) {
      completely = true;
    }
    var event = this.event, state = this.state;
    if (state.is(CREATED)) {
      EventInterface(this).on(EVENT_READY, this.destroy.bind(this, completely));
    } else {
      forOwn(this._C, function(component) {
        component.destroy && component.destroy(completely);
      }, true);
      event.emit(EVENT_DESTROY);
      event.destroy();
      completely && empty(this.splides);
      state.set(DESTROYED);
    }
    return this;
  };
  _createClass(_Splide2, [{
    key: "options",
    get: function get() {
      return this._o;
    },
    set: function set(options) {
      this._C.Media.set(options, true, true);
    }
  }, {
    key: "length",
    get: function get() {
      return this._C.Slides.getLength(true);
    }
  }, {
    key: "index",
    get: function get() {
      return this._C.Controller.getIndex();
    }
  }]);
  return _Splide2;
}();
var Splide = _Splide;
Splide.defaults = {};
Splide.STATES = STATES;

// src/js/components/Splide/Splide.tsx


// src/js/constants/events.ts
var EVENTS = [
  [EVENT_MOUNTED, "onMounted"],
  [EVENT_READY, "onReady"],
  [EVENT_MOVE, "onMove"],
  [EVENT_MOVED, "onMoved"],
  [EVENT_CLICK, "onClick"],
  [EVENT_ACTIVE, "onActive"],
  [EVENT_INACTIVE, "onInactive"],
  [EVENT_VISIBLE, "onVisible"],
  [EVENT_HIDDEN, "onHidden"],
  [EVENT_REFRESH, "onRefresh"],
  [EVENT_UPDATED, "onUpdated"],
  [EVENT_RESIZE, "onResize"],
  [EVENT_RESIZED, "onResized"],
  [EVENT_DRAG, "onDrag"],
  [EVENT_DRAGGING, "onDragging"],
  [EVENT_DRAGGED, "onDragged"],
  [EVENT_SCROLL, "onScroll"],
  [EVENT_SCROLLED, "onScrolled"],
  [EVENT_DESTROY, "onDestroy"],
  [EVENT_ARROWS_MOUNTED, "onArrowsMounted"],
  [EVENT_ARROWS_UPDATED, "onArrowsUpdated"],
  [EVENT_PAGINATION_MOUNTED, "onPaginationMounted"],
  [EVENT_PAGINATION_UPDATED, "onPaginationUpdated"],
  [EVENT_NAVIGATION_MOUNTED, "onNavigationMounted"],
  [EVENT_AUTOPLAY_PLAY, "onAutoplayPlay"],
  [EVENT_AUTOPLAY_PLAYING, "onAutoplayPlaying"],
  [EVENT_AUTOPLAY_PAUSE, "onAutoplayPause"],
  [EVENT_LAZYLOAD_LOADED, "onLazyLoadLoaded"]
];

// src/js/utils/classNames/classNames.ts
function classNames(...classes) {
  return classes.filter(Boolean).join(" ");
}

// src/js/utils/isObject/isObject.ts
function isObject2(subject) {
  return subject !== null && typeof subject === "object";
}

// src/js/utils/isEqualDeep/isEqualDeep.ts
function isEqualDeep(subject1, subject2) {
  if (Array.isArray(subject1) && Array.isArray(subject2)) {
    return subject1.length === subject2.length && !subject1.some((elm, index) => !isEqualDeep(elm, subject2[index]));
  }
  if (isObject2(subject1) && isObject2(subject2)) {
    const keys1 = Object.keys(subject1);
    const keys2 = Object.keys(subject2);
    return keys1.length === keys2.length && !keys1.some((key) => {
      return !Object.prototype.hasOwnProperty.call(subject2, key) || !isEqualDeep(subject1[key], subject2[key]);
    });
  }
  return subject1 === subject2;
}

// src/js/utils/isEqualShallow/isEqualShallow.ts
function isEqualShallow(array1, array2) {
  return array1.length === array2.length && !array1.some((elm, index) => elm !== array2[index]);
}

// src/js/utils/forOwn/forOwn.ts
function forOwn2(object, iteratee) {
  if (object) {
    const keys = Object.keys(object);
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }
  return object;
}

// src/js/utils/merge/merge.ts
function merge2(object, source) {
  const merged = object;
  forOwn2(source, (value, key) => {
    if (Array.isArray(value)) {
      merged[key] = value.slice();
    } else if (isObject2(value)) {
      merged[key] = merge2(isObject2(merged[key]) ? merged[key] : {}, value);
    } else {
      merged[key] = value;
    }
  });
  return merged;
}

// src/js/components/SplideTrack/SplideTrack.tsx

var SplideTrack = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classNames("splide__track", className),
    ...props
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "splide__list"
  }, children2));
};

// src/js/components/Splide/Splide.tsx
var Splide2 = class extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
  constructor() {
    super(...arguments);
    this.splideRef = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
    this.slides = [];
  }
  componentDidMount() {
    const { options, extensions, transition } = this.props;
    const { current } = this.splideRef;
    if (current) {
      this.splide = new Splide(current, options);
      this.bind(this.splide);
      this.splide.mount(extensions, transition);
      this.options = merge2({}, options || {});
      this.slides = this.getSlides();
    }
  }
  componentWillUnmount() {
    if (this.splide) {
      this.splide.destroy();
      this.splide = void 0;
    }
    this.options = void 0;
    this.slides.length = 0;
  }
  componentDidUpdate() {
    if (!this.splide) {
      return;
    }
    const { options } = this.props;
    if (options && !isEqualDeep(this.options, options)) {
      this.splide.options = options;
      this.options = merge2({}, options);
    }
    const newSlides = this.getSlides();
    if (!isEqualShallow(this.slides, newSlides)) {
      this.splide.refresh();
      this.slides = newSlides;
    }
  }
  sync(splide) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.sync(splide);
  }
  go(control) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.go(control);
  }
  getSlides() {
    var _a;
    if (this.splide) {
      const children2 = (_a = this.splide.Components.Elements) == null ? void 0 : _a.list.children;
      return children2 && Array.prototype.slice.call(children2) || [];
    }
    return [];
  }
  bind(splide) {
    EVENTS.forEach(([event, name]) => {
      const handler = this.props[name];
      if (typeof handler === "function") {
        splide.on(event, (...args) => {
          handler(splide, ...args);
        });
      }
    });
  }
  omit(props, keys) {
    keys.forEach((key) => {
      if (Object.prototype.hasOwnProperty.call(props, key)) {
        delete props[key];
      }
    });
    return props;
  }
  render() {
    const { className, tag: Root = "div", hasTrack = true, children: children2, ...props } = this.props;
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Root, {
      className: classNames("splide", className),
      ref: this.splideRef,
      ...this.omit(props, ["options", ...EVENTS.map((event) => event[1])])
    }, hasTrack ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SplideTrack, null, children2) : children2);
  }
};

// src/js/components/SplideSlide/SplideSlide.tsx

var SplideSlide = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: classNames("splide__slide", className),
    ...props
  }, children2);
};

/*!
 * Splide.js
 * Version  : 4.1.3
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */


/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps}                                 props icon is the SVG component to render
 *                                                          size is a number specifiying the icon size in pixels
 *                                                          Other props will be passed to wrapped SVG component
 * @param {import('react').ForwardedRef<HTMLElement>} ref   The forwarded ref to the SVG element.
 *
 * @return {JSX.Element}  Icon component
 */
function Icon({
  icon,
  size = 24,
  ...props
}, ref) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Icon));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/add-card.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/add-card.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const addCard = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18.5 5.5V8H20V5.5h2.5V4H20V1.5h-1.5V4H16v1.5h2.5zM12 4H6a2 2 0 00-2 2v12a2 2 0 002 2h12a2 2 0 002-2v-6h-1.5v6a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5h6V4z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (addCard);
//# sourceMappingURL=add-card.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/add-template.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/add-template.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const addTemplate = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M18.5 5.5V8H20V5.5H22.5V4H20V1.5H18.5V4H16V5.5H18.5ZM13.9624 4H6C4.89543 4 4 4.89543 4 6V18C4 19.1046 4.89543 20 6 20H18C19.1046 20 20 19.1046 20 18V10.0391H18.5V18C18.5 18.2761 18.2761 18.5 18 18.5H10L10 10.4917L16.4589 10.5139L16.4641 9.01389L5.5 8.97618V6C5.5 5.72386 5.72386 5.5 6 5.5H13.9624V4ZM5.5 10.4762V18C5.5 18.2761 5.72386 18.5 6 18.5H8.5L8.5 10.4865L5.5 10.4762Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (addTemplate);
//# sourceMappingURL=add-template.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/arrow-right.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const arrowRight = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrowRight);
//# sourceMappingURL=arrow-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/block-meta.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/block-meta.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const blockMeta = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M8.95 11.25H4v1.5h4.95v4.5H13V18c0 1.1.9 2 2 2h3c1.1 0 2-.9 2-2v-3c0-1.1-.9-2-2-2h-3c-1.1 0-2 .9-2 2v.75h-2.55v-7.5H13V9c0 1.1.9 2 2 2h3c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3c-1.1 0-2 .9-2 2v.75H8.95v4.5ZM14.5 15v3c0 .3.2.5.5.5h3c.3 0 .5-.2.5-.5v-3c0-.3-.2-.5-.5-.5h-3c-.3 0-.5.2-.5.5Zm0-6V6c0-.3.2-.5.5-.5h3c.3 0 .5.2.5.5v3c0 .3-.2.5-.5.5h-3c-.3 0-.5-.2-.5-.5Z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (blockMeta);
//# sourceMappingURL=block-meta.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/brush.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/brush.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const brush = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M4 20h8v-1.5H4V20zM18.9 3.5c-.6-.6-1.5-.6-2.1 0l-7.2 7.2c-.4-.1-.7 0-1.1.1-.5.2-1.5.7-1.9 2.2-.4 1.7-.8 2.2-1.1 2.7-.1.1-.2.3-.3.4l-.6 1.1H6c2 0 3.4-.4 4.7-1.4.8-.6 1.2-1.4 1.3-2.3 0-.3 0-.5-.1-.7L19 5.7c.5-.6.5-1.6-.1-2.2zM9.7 14.7c-.7.5-1.5.8-2.4 1 .2-.5.5-1.2.8-2.3.2-.6.4-1 .8-1.1.5-.1 1 .1 1.3.3.2.2.3.5.2.8 0 .3-.1.9-.7 1.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (brush);
//# sourceMappingURL=brush.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/check.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/check.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const check = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (check);
//# sourceMappingURL=check.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-down.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const chevronDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronDown);
//# sourceMappingURL=chevron-down.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-up.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const chevronUp = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronUp);
//# sourceMappingURL=chevron-up.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const close = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (close);
//# sourceMappingURL=close.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/cloud.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/cloud.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const cloud = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.3 10.1c0-2.5-2.1-4.4-4.8-4.4-2.2 0-4.1 1.4-4.6 3.3h-.2C5.7 9 4 10.7 4 12.8c0 2.1 1.7 3.8 3.7 3.8h9c1.8 0 3.2-1.5 3.2-3.3.1-1.6-1.1-2.9-2.6-3.2zm-.5 5.1h-9c-1.2 0-2.2-1.1-2.2-2.3s1-2.4 2.2-2.4h1.3l.3-1.1c.4-1.3 1.7-2.2 3.2-2.2 1.8 0 3.3 1.3 3.3 2.9v1.3l1.3.2c.8.1 1.4.9 1.4 1.8-.1 1-.9 1.8-1.8 1.8z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cloud);
//# sourceMappingURL=cloud.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/color.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/color.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const color = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.2 10.9c-.5-1-1.2-2.1-2.1-3.2-.6-.9-1.3-1.7-2.1-2.6L12 4l-1 1.1c-.6.9-1.3 1.7-2 2.6-.8 1.2-1.5 2.3-2 3.2-.6 1.2-1 2.2-1 3 0 3.4 2.7 6.1 6.1 6.1s6.1-2.7 6.1-6.1c0-.8-.3-1.8-1-3zm-5.1 7.6c-2.5 0-4.6-2.1-4.6-4.6 0-.3.1-1 .8-2.3.5-.9 1.1-1.9 2-3.1.7-.9 1.3-1.7 1.8-2.3.7.8 1.3 1.6 1.8 2.3.8 1.1 1.5 2.2 2 3.1.7 1.3.8 2 .8 2.3 0 2.5-2.1 4.6-4.6 4.6z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (color);
//# sourceMappingURL=color.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/copy.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/copy.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const copy = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M20.2 8v11c0 .7-.6 1.2-1.2 1.2H6v1.5h13c1.5 0 2.7-1.2 2.7-2.8V8zM18 16.4V4.6c0-.9-.7-1.6-1.6-1.6H4.6C3.7 3 3 3.7 3 4.6v11.8c0 .9.7 1.6 1.6 1.6h11.8c.9 0 1.6-.7 1.6-1.6zm-13.5 0V4.6c0-.1.1-.1.1-.1h11.8c.1 0 .1.1.1.1v11.8c0 .1-.1.1-.1.1H4.6l-.1-.1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (copy);
//# sourceMappingURL=copy.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/download.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/download.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const download = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18 11.3l-1-1.1-4 4V3h-1.5v11.3L7 10.2l-1 1.1 6.2 5.8 5.8-5.8zm.5 3.7v3.5h-13V15H4v5h16v-5h-1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (download);
//# sourceMappingURL=download.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/edit.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/edit.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _pencil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pencil */ "./node_modules/@wordpress/icons/build-module/library/pencil.js");
/**
 * Internal dependencies
 */


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_pencil__WEBPACK_IMPORTED_MODULE_0__["default"]);
//# sourceMappingURL=edit.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/info.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/info.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const info = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM11 17h2v-6h-2v6zm0-8h2V7h-2v2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (info);
//# sourceMappingURL=info.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/key.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/key.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const key = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M9 13.5a1.5 1.5 0 100-3 1.5 1.5 0 000 3zM9 16a4.002 4.002 0 003.8-2.75H15V16h2.5v-2.75H19v-2.5h-6.2A4.002 4.002 0 005 12a4 4 0 004 4z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (key);
//# sourceMappingURL=key.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link-off.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link-off.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const linkOff = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.031 4.703 15.576 4l-1.56 3H14v.03l-2.324 4.47H9.5V13h1.396l-1.502 2.889h-.95a3.694 3.694 0 0 1 0-7.389H10V7H8.444a5.194 5.194 0 1 0 0 10.389h.17L7.5 19.53l1.416.719L15.049 8.5h.507a3.694 3.694 0 0 1 0 7.39H14v1.5h1.556a5.194 5.194 0 0 0 .273-10.383l1.202-2.304Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (linkOff);
//# sourceMappingURL=link-off.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const link = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M10 17.389H8.444A5.194 5.194 0 1 1 8.444 7H10v1.5H8.444a3.694 3.694 0 0 0 0 7.389H10v1.5ZM14 7h1.556a5.194 5.194 0 0 1 0 10.39H14v-1.5h1.556a3.694 3.694 0 0 0 0-7.39H14V7Zm-4.5 6h5v-1.5h-5V13Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (link);
//# sourceMappingURL=link.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/list.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/list.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const list = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M4 4v1.5h16V4H4zm8 8.5h8V11h-8v1.5zM4 20h16v-1.5H4V20zm4-8c0-1.1-.9-2-2-2s-2 .9-2 2 .9 2 2 2 2-.9 2-2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (list);
//# sourceMappingURL=list.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/lock-small.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/lock-small.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const lockSmall = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M15 11h-.2V9c0-1.5-1.2-2.8-2.8-2.8S9.2 7.5 9.2 9v2H9c-.6 0-1 .4-1 1v4c0 .6.4 1 1 1h6c.6 0 1-.4 1-1v-4c0-.6-.4-1-1-1zm-1.8 0h-2.5V9c0-.7.6-1.2 1.2-1.2s1.2.6 1.2 1.2v2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (lockSmall);
//# sourceMappingURL=lock-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/media-and-text.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const mediaAndText = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M3 6v11.5h8V6H3Zm11 3h7V7.5h-7V9Zm7 3.5h-7V11h7v1.5ZM14 16h7v-1.5h-7V16Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mediaAndText);
//# sourceMappingURL=media-and-text.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/menu.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/menu.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const menu = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M5 5v1.5h14V5H5zm0 7.8h14v-1.5H5v1.5zM5 19h14v-1.5H5V19z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (menu);
//# sourceMappingURL=menu.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pages.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pages.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const pages = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M7 13.8h6v-1.5H7v1.5zM18 16V4c0-1.1-.9-2-2-2H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2zM5.5 16V4c0-.3.2-.5.5-.5h10c.3 0 .5.2.5.5v12c0 .3-.2.5-.5.5H6c-.3 0-.5-.2-.5-.5zM7 10.5h8V9H7v1.5zm0-3.3h8V5.8H7v1.4zM20.2 6v13c0 .7-.6 1.2-1.2 1.2H8v1.5h11c1.5 0 2.7-1.2 2.7-2.8V6h-1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pages);
//# sourceMappingURL=pages.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pencil.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pencil.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const pencil = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pencil);
//# sourceMappingURL=pencil.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/percent.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/percent.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const percent = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M6.5 8a1.5 1.5 0 103 0 1.5 1.5 0 00-3 0zM8 5a3 3 0 100 6 3 3 0 000-6zm6.5 11a1.5 1.5 0 103 0 1.5 1.5 0 00-3 0zm1.5-3a3 3 0 100 6 3 3 0 000-6zM5.47 17.41a.75.75 0 001.06 1.06L18.47 6.53a.75.75 0 10-1.06-1.06L5.47 17.41z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (percent);
//# sourceMappingURL=percent.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus-circle.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus-circle.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const plusCircle = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "-2 -2 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm0 16c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zm1-11H9v3H6v2h3v3h2v-3h3V9h-3V6zM10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm0 16c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zm1-11H9v3H6v2h3v3h2v-3h3V9h-3V6z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plusCircle);
//# sourceMappingURL=plus-circle.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const plus = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plus);
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/replace.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/replace.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const replace = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16 10h4c.6 0 1-.4 1-1V5c0-.6-.4-1-1-1h-4c-.6 0-1 .4-1 1v4c0 .6.4 1 1 1zm-8 4H4c-.6 0-1 .4-1 1v4c0 .6.4 1 1 1h4c.6 0 1-.4 1-1v-4c0-.6-.4-1-1-1zm10-2.6L14.5 15l1.1 1.1 1.7-1.7c-.1 1.1-.3 2.3-.9 2.9-.3.3-.7.5-1.3.5h-4.5v1.5H15c.9 0 1.7-.3 2.3-.9 1-1 1.3-2.7 1.4-4l1.8 1.8 1.1-1.1-3.6-3.7zM6.8 9.7c.1-1.1.3-2.3.9-2.9.4-.4.8-.6 1.3-.6h4.5V4.8H9c-.9 0-1.7.3-2.3.9-1 1-1.3 2.7-1.4 4L3.5 8l-1 1L6 12.6 9.5 9l-1-1-1.7 1.7z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replace);
//# sourceMappingURL=replace.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/rotate-left.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/rotate-left.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const rotateLeft = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4V2.2L9 4.8l3 2.5V5.5c3.6 0 6.5 2.9 6.5 6.5 0 2.9-1.9 5.3-4.5 6.2v.2l-.1-.2c-.4.1-.7.2-1.1.2l.2 1.5c.3 0 .6-.1 1-.2 3.5-.9 6-4 6-7.7 0-4.4-3.6-8-8-8zm-7.9 7l1.5.2c.1-1.2.5-2.3 1.2-3.2l-1.1-.9C4.8 8.2 4.3 9.6 4.1 11zm1.5 1.8l-1.5.2c.1.7.3 1.4.5 2 .3.7.6 1.3 1 1.8l1.2-.8c-.3-.5-.6-1-.8-1.5s-.4-1.1-.4-1.7zm1.5 5.5c1.1.9 2.4 1.4 3.8 1.6l.2-1.5c-1.1-.1-2.2-.5-3.1-1.2l-.9 1.1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (rotateLeft);
//# sourceMappingURL=rotate-left.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/seen.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/seen.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const seen = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M3.99961 13C4.67043 13.3354 4.6703 13.3357 4.67017 13.3359L4.67298 13.3305C4.67621 13.3242 4.68184 13.3135 4.68988 13.2985C4.70595 13.2686 4.7316 13.2218 4.76695 13.1608C4.8377 13.0385 4.94692 12.8592 5.09541 12.6419C5.39312 12.2062 5.84436 11.624 6.45435 11.0431C7.67308 9.88241 9.49719 8.75 11.9996 8.75C14.502 8.75 16.3261 9.88241 17.5449 11.0431C18.1549 11.624 18.6061 12.2062 18.9038 12.6419C19.0523 12.8592 19.1615 13.0385 19.2323 13.1608C19.2676 13.2218 19.2933 13.2686 19.3093 13.2985C19.3174 13.3135 19.323 13.3242 19.3262 13.3305L19.3291 13.3359C19.3289 13.3357 19.3288 13.3354 19.9996 13C20.6704 12.6646 20.6703 12.6643 20.6701 12.664L20.6697 12.6632L20.6688 12.6614L20.6662 12.6563L20.6583 12.6408C20.6517 12.6282 20.6427 12.6108 20.631 12.5892C20.6078 12.5459 20.5744 12.4852 20.5306 12.4096C20.4432 12.2584 20.3141 12.0471 20.1423 11.7956C19.7994 11.2938 19.2819 10.626 18.5794 9.9569C17.1731 8.61759 14.9972 7.25 11.9996 7.25C9.00203 7.25 6.82614 8.61759 5.41987 9.9569C4.71736 10.626 4.19984 11.2938 3.85694 11.7956C3.68511 12.0471 3.55605 12.2584 3.4686 12.4096C3.42484 12.4852 3.39142 12.5459 3.36818 12.5892C3.35656 12.6108 3.34748 12.6282 3.34092 12.6408L3.33297 12.6563L3.33041 12.6614L3.32948 12.6632L3.32911 12.664C3.32894 12.6643 3.32879 12.6646 3.99961 13ZM11.9996 16C13.9326 16 15.4996 14.433 15.4996 12.5C15.4996 10.567 13.9326 9 11.9996 9C10.0666 9 8.49961 10.567 8.49961 12.5C8.49961 14.433 10.0666 16 11.9996 16Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (seen);
//# sourceMappingURL=seen.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/settings.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/settings.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const settings = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 7.5h-7.628c-.3089-.87389-1.1423-1.5-2.122-1.5-.97966 0-1.81309.62611-2.12197 1.5h-2.12803v1.5h2.12803c.30888.87389 1.14231 1.5 2.12197 1.5.9797 0 1.8131-.62611 2.122-1.5h7.628z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 15h-2.128c-.3089-.8739-1.1423-1.5-2.122-1.5s-1.8131.6261-2.122 1.5h-7.628v1.5h7.628c.3089.8739 1.1423 1.5 2.122 1.5s1.8131-.6261 2.122-1.5h2.128z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (settings);
//# sourceMappingURL=settings.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/shortcode.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/shortcode.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const shortcode = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16 4.2v1.5h2.5v12.5H16v1.5h4V4.2h-4zM4.2 19.8h4v-1.5H5.8V5.8h2.5V4.2h-4l-.1 15.6zm5.1-3.1l1.4.6 4-10-1.4-.6-4 10z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (shortcode);
//# sourceMappingURL=shortcode.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   styles: () => (/* binding */ styles)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const styles = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (styles);
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/superscript.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/superscript.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const superscript = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16.9 10.3l.8-1.3c.4-.6.7-1.2.9-1.6.2-.4.3-.8.3-1.2 0-.3-.1-.7-.2-1-.2-.2-.4-.4-.7-.6-.3-.2-.6-.3-1-.3s-.8.1-1.1.2c-.3.1-.7.3-1 .6l.1 1.3c.3-.3.5-.5.8-.6s.6-.2.9-.2c.3 0 .5.1.7.2.2.2.2.4.2.7 0 .3-.1.5-.2.8-.1.3-.4.7-.8 1.3l-1.8 2.8h4.3v-1.2h-2.2zm-2.8-3.1h-2L9.5 11 6.9 7.2h-2l3.6 5.3L4.7 18h2l2.7-4 2.7 4h2l-3.8-5.5 3.8-5.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (superscript);
//# sourceMappingURL=superscript.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/typography.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/typography.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const typography = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.9 7L3 17.8h1.7l1-2.8h4.1l1 2.8h1.7L8.6 7H6.9zm-.7 6.6l1.5-4.3 1.5 4.3h-3zM21.6 17c-.1.1-.2.2-.3.2-.1.1-.2.1-.4.1s-.3-.1-.4-.2c-.1-.1-.1-.3-.1-.6V12c0-.5 0-1-.1-1.4-.1-.4-.3-.7-.5-1-.2-.2-.5-.4-.9-.5-.4 0-.8-.1-1.3-.1s-1 .1-1.4.2c-.4.1-.7.3-1 .4-.2.2-.4.3-.6.5-.1.2-.2.4-.2.7 0 .3.1.5.2.8.2.2.4.3.8.3.3 0 .6-.1.8-.3.2-.2.3-.4.3-.7 0-.3-.1-.5-.2-.7-.2-.2-.4-.3-.6-.4.2-.2.4-.3.7-.4.3-.1.6-.1.8-.1.3 0 .6 0 .8.1.2.1.4.3.5.5.1.2.2.5.2.9v1.1c0 .3-.1.5-.3.6-.2.2-.5.3-.9.4-.3.1-.7.3-1.1.4-.4.1-.8.3-1.1.5-.3.2-.6.4-.8.7-.2.3-.3.7-.3 1.2 0 .6.2 1.1.5 1.4.3.4.9.5 1.6.5.5 0 1-.1 1.4-.3.4-.2.8-.6 1.1-1.1 0 .4.1.7.3 1 .2.3.6.4 1.2.4.4 0 .7-.1.9-.2.2-.1.5-.3.7-.4h-.3zm-3-.9c-.2.4-.5.7-.8.8-.3.2-.6.2-.8.2-.4 0-.6-.1-.9-.3-.2-.2-.3-.6-.3-1.1 0-.5.1-.9.3-1.2s.5-.5.8-.7c.3-.2.7-.3 1-.5.3-.1.6-.3.7-.6v3.4z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (typography);
//# sourceMappingURL=typography.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/upload.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/upload.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const upload = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18.5 15v3.5H13V6.7l4.5 4.1 1-1.1-6.2-5.8-5.8 5.8 1 1.1 4-4v11.7h-6V15H4v5h16v-5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (upload);
//# sourceMappingURL=upload.js.map

/***/ }),

/***/ "./src/blocks/accordion-nested-item/index.js":
/*!***************************************************!*\
  !*** ./src/blocks/accordion-nested-item/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./block.json */ "./src/blocks/accordion-nested-item/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");











// import { select } from "@wordpress/data";

const {
  RawHTML
} = wp.element;













var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_18__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "162",
      height: "160",
      viewBox: "0 0 162 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M161 27H1V45.8H161V27Z",
      fill: "url(#paint0_linear_61_765)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M18.6226 38.8999C18.4235 38.8999 18.3238 38.7998 18.2242 38.6998L14.9385 34.8999C14.7394 34.6999 14.7395 34.2998 15.0382 34.0998C15.2373 33.8998 15.6356 33.8998 15.8348 34.1998L18.722 37.5998L21.6095 34.1998C21.8087 33.9998 22.1072 33.8998 22.4059 34.0998C22.605 34.2998 22.7047 34.5999 22.5055 34.8999L19.2199 38.6998C18.9212 38.7998 18.8217 38.8999 18.6226 38.8999Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M105.443 33.8999H27.9819V38.7999H105.443V33.8999Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M161 71.3999H1V110.1H161V71.3999Z",
      fill: "#C15940",
      stroke: "#8E240B",
      strokeWidth: "2",
      strokeDasharray: "6 6"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M161 49.2002H1V68.0002H161V49.2002Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M18.623 56.2002C18.8221 56.2002 18.9216 56.3003 19.0211 56.4003L22.3068 60.2002C22.5059 60.4002 22.5058 60.8002 22.2071 61.0002C22.008 61.2002 21.6097 61.2003 21.4106 60.9003L18.5233 57.5002L15.636 60.9003C15.4369 61.1003 15.1382 61.2002 14.8395 61.0002C14.5408 60.8002 14.5407 60.5002 14.7398 60.2002L18.0255 56.4003C18.3242 56.2003 18.4238 56.2002 18.623 56.2002Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M105.443 56.2002H27.9819V61.1002H105.443V56.2002Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M161 113.5H1V132.3H161V113.5Z",
      fill: "url(#paint1_linear_61_765)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M18.6226 125.4C18.4235 125.4 18.3238 125.3 18.2242 125.2L14.9385 121.4C14.7394 121.2 14.7395 120.8 15.0382 120.6C15.2373 120.4 15.6356 120.4 15.8348 120.7L18.722 124.1L21.6095 120.7C21.8087 120.5 22.1072 120.4 22.4059 120.6C22.605 120.8 22.7047 121.1 22.5055 121.4L19.2199 125.2C18.9212 125.3 18.8217 125.4 18.6226 125.4Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M105.443 120.4H27.9819V125.3H105.443V120.4Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_765",
      x1: "1",
      y1: "36.4",
      x2: "161",
      y2: "36.4",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_765",
      x1: "1",
      y1: "122.9",
      x2: "161",
      y2: "122.9",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var parentIcon = context["post-grid/accordionNestedIcon"] == undefined ? null : context["post-grid/accordionNestedIcon"];
    var parentIconToggle = context["post-grid/accordionNestedIconToggle"] == undefined ? null : context["post-grid/accordionNestedIconToggle"];
    var parentLabelIcon = context["post-grid/accordionNestedLabelIcon"] == undefined ? null : context["post-grid/accordionNestedLabelIcon"];
    var parentLabelCounter = context["post-grid/accordionNestedLabelCounter"] == undefined ? null : context["post-grid/accordionNestedLabelCounter"];
    var parentContentWrapper = context["post-grid/accordionNestedContent"] == undefined ? null : context["post-grid/accordionNestedContent"];
    var parentHeader = context["post-grid/accordionNestedHeader"] == undefined ? null : context["post-grid/accordionNestedHeader"];
    var parentHeaderLabel = context["post-grid/accordionNestedHeaderLabel"] == undefined ? null : context["post-grid/accordionNestedHeaderLabel"];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var header = attributes.header;
    var headerLabel = attributes.headerLabel;
    var labelCounter = attributes.labelCounter;
    var labelIcon = attributes.labelIcon;
    var count = attributes.count;
    var content = attributes.content;
    var icon = attributes.icon;
    var iconToggle = attributes.iconToggle;
    var blockCssY = attributes.blockCssY;
    var breakPointX = myStore.getBreakPoint();
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [toggled, setToggled] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const contentSelector = blockClass + "-accordion-content";
    const headerSelector = blockClass + "-accordion-header ";
    const headerLabelSelector = blockClass + " > .accordion-header-label";
    const labelIconSelector = blockClass + " .accordion-label-icon";
    const labelCounterSelector = blockClass + " > .accordion-label-counter";
    const iconSelector = blockClass + " > .accordion-icon";
    const iconToggleSelector = blockClass + " > .accordion-icon-toggle";
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("isProFeature", true);
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    const [iconToggleHtml, seticonToggleHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    const [labelIconHtml, setlabelIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    function headerLabelText() {}
    //Icon update from nested item
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="accordion-icon ${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon, icon.options.iconSrc]);
    // Icon update from parent
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (parentIcon.options.overrideChild == true) {
        var options = {
          ...parentIcon.options
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    }, [parentIcon]);
    //iconToggle update from nested item
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var iconSrc = iconToggle.options.iconSrc;
      var iconHtml = `<span class=" ${iconSrc}"></span>`;
      seticonToggleHtml(iconHtml);
    }, [iconToggle, iconToggle.options.iconSrc, parentIcon]);
    // *iconToggle update from parent
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (parentIcon.options.overrideChild == true) {
        var iconSrc = parentIconToggle.options.iconSrc;
        setAttributes({
          iconToggle: parentIconToggle
        });
        var iconHtml = `<span class="${iconSrc}"></span>`;
        seticonToggleHtml(iconHtml);
      }
    }, [parentIconToggle]);
    //labelIcon update from nested item
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var iconSrc = labelIcon.options.iconSrc;
      var iconHtml = `<span class=" ${iconSrc}"></span>`;
      setlabelIconHtml(iconHtml);
    }, [labelIcon, labelIcon.options.iconSrc]);
    //labelIcon update from parent
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (parentLabelIcon.options.overrideChild == true) {
        setAttributes({
          labelIcon: parentLabelIcon
        });
        var iconSrc = parentLabelIcon.options.iconSrc;
        var iconHtml = `<span class=" ${iconSrc}"></span>`;
        setlabelIconHtml(iconHtml);
      }
    }, [parentLabelIcon]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      // if (parentLabelCounter.options.overrideChild == true) {
      if (parentLabelCounter.options.overrideChild == true) {
        setAttributes({
          labelCounter: parentLabelCounter
        });
      }
    }, [parentLabelCounter]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (parentContentWrapper.options?.overrideChild == true) {
        setAttributes({
          content: parentContentWrapper
        });
      }
    }, [parentContentWrapper]);
    const CustomContentWrapper = content.options.tag.length != 0 ? `${content.options.tag}` : "div";
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      // if (
      // 	parentHeader !== null &&
      // 	parentHeader.options?.overrideChild == true
      // ) {
      setAttributes({
        header: parentHeader
      });
      // }
    }, [parentHeader]);
    const CustomHeaderTag = header.options.tag.length != 0 ? `${header.options.tag}` : "div";
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (parentHeaderLabel !== null && parentHeaderLabel.options?.overrideChild == true) {
        parentHeaderLabel.options.text = headerLabel.options.text;
        //var parenLabel = { ...parentHeaderLabel, text: headerLabel.options.text };
        setAttributes({
          headerLabel: parentHeaderLabel
        });
      }
    }, [parentHeaderLabel]);
    const CustomHeaderLabelTag = headerLabel.options.tag.length != 0 ? `${headerLabel.options.tag}` : "div";
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[contentSelector] = content;
      blockCssObj[headerSelector] = header;
      blockCssObj[headerLabelSelector] = headerLabel;
      blockCssObj[labelCounterSelector] = labelCounter;
      blockCssObj[labelIconSelector] = labelIcon;
      blockCssObj[iconSelector] = icon;
      blockCssObj[iconToggleSelector] = iconToggle;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    function onChangeStyleHeader(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleHeader(sudoScource, key) {
      let obj = {
        ...header
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        header: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleHeaderLabel(sudoScource, key) {
      let obj = {
        ...headerLabel
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        headerLabel: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleLabelCounter(sudoScource, key) {
      let obj = {
        ...labelCounter
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        labelCounter: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleLabelIcon(sudoScource, key) {
      let obj = {
        ...labelIcon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        labelIcon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelIconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleContent(sudoScource, key) {
      let obj = {
        ...content
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        content: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIcon(sudoScource, key) {
      let obj = {
        ...icon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        icon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIconToggle(sudoScource, key) {
      let obj = {
        ...iconToggle
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        iconToggle: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onAddStyleHeader(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        header: object
      });
    }
    function onChangeStyleHeaderLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerLabel: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleHeaderLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        headerLabel: object
      });
    }
    function onPickCssLibraryHeaderLabel(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        headerLabel[sudoScource] = sudoScourceArgs;
      });
      var headerLabelX = Object.assign({}, headerLabel);
      setAttributes({
        headerLabel: headerLabelX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleLabelCounter(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelCounter: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleLabelCounter(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        labelCounter: object
      });
    }
    function onPickCssLibraryLabelCounter(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        labelCounter[sudoScource] = sudoScourceArgs;
      });
      var labelCounterX = Object.assign({}, labelCounter);
      setAttributes({
        labelCounter: labelCounterX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleContent(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleLabelIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelIcon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelIcon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelIconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleLabelIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelIcon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        labelIcon: object
      });
    }
    function onAddStyleContent(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        content: object
      });
    }
    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        icon: object
      });
    }
    function onChangeStyleIconToggle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        iconToggle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIconToggle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        iconToggle: object
      });
    }
    function onPickCssLibraryIconToggle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        iconToggle[sudoScource] = sudoScourceArgs;
      });
      var iconToggleX = Object.assign({}, iconToggle);
      setAttributes({
        iconToggle: iconToggleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryHeader(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        header[sudoScource] = sudoScourceArgs;
      });
      var headerX = Object.assign({}, header);
      setAttributes({
        header: headerX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryContent(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        content[sudoScource] = sudoScourceArgs;
      });
      var contentX = Object.assign({}, content);
      setAttributes({
        content: contentX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onBulkAddHeader(sudoScource, cssObj) {
      let obj = Object.assign({}, header);
      obj[sudoScource] = cssObj;
      setAttributes({
        header: obj
      });
      var selector = myStore.getElementSelector(sudoScource, headerSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddHeaderLabel(sudoScource, cssObj) {
      let obj = Object.assign({}, headerLabel);
      obj[sudoScource] = cssObj;
      setAttributes({
        headerLabel: obj
      });
      var selector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddLabelIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, labelIcon);
      obj[sudoScource] = cssObj;
      setAttributes({
        labelIcon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelIconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddLabelCounter(sudoScource, cssObj) {
      let obj = Object.assign({}, labelCounter);
      obj[sudoScource] = cssObj;
      setAttributes({
        labelCounter: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddContent(sudoScource, cssObj) {
      let obj = Object.assign({}, content);
      obj[sudoScource] = cssObj;
      setAttributes({
        content: obj
      });
      var selector = myStore.getElementSelector(sudoScource, contentSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onResetHeader(sudoScources) {
      let obj = Object.assign({}, header);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        header: obj
      });
    }
    function onResetHeaderLabel(sudoScources) {
      let obj = Object.assign({}, headerLabel);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        headerLabel: obj
      });
    }
    function onResetLabelIcon(sudoScources) {
      let obj = Object.assign({}, labelIcon);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, labelIconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        labelIcon: obj
      });
    }
    function onResetLabelCounter(sudoScources) {
      let obj = Object.assign({}, labelCounter);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        labelCounter: obj
      });
    }
    function onResetContent(sudoScources) {
      let obj = Object.assign({}, content);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        content: obj
      });
    }
    function onResetIcon(sudoScources) {
      let obj = Object.assign({}, icon);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        icon: obj
      });
    }
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)();
    var allowedExtraBlocks = [];
    wp.blocks.getBlockTypes().forEach(function (blockType) {
      if (blockType.name.startsWith("post-grid/accordion-nested")) {
        if (!isProFeature) {
          allowedExtraBlocks.push(blockType.name);
        }
      } else {
        allowedExtraBlocks.push(blockType.name);
      }
    });
    const removeChild = () => {
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.dispatch)("core/block-editor").removeBlock(clientId);
    };
    const selectedBlock = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select("core/block-editor").getSelectedBlock());
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    const duplicateChild = () => {
      var childBlocks = wp.data.select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.store).getBlocks(parentClientId);
      // const slide = createBlock("post-grid/accordion-nested-item");
      const position = childBlocks.length;
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.dispatch)("core/block-editor").insertBlock(selectedBlock, position, parentClientId);
      wp.data.dispatch("core/block-editor").selectBlock(parentClientId);
    };
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex  items-center justify-center mx-3 my-2 px-3"
      // className="text-center"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-red-500 w-full cursor-pointer hover:text-white font-bold text-[16px] px-3 py-2 text-center text-white rounded flex justify-between items-center gap-2",
      onClick: ev => {
        removeChild();
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Remove", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"], {
      fill: "white",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
      height: 20,
      width: 20
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Header"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: header.options.class,
      onChange: newVal => {
        var options = {
          ...header.options,
          class: newVal
        };
        setAttributes({
          header: {
            styles: header.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: header.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...header.options,
          tag: newVal
        };
        setAttributes({
          header: {
            ...header,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: header,
      onChange: onChangeStyleHeader,
      onAdd: onAddStyleHeader,
      onRemove: onRemoveStyleHeader,
      onBulkAdd: onBulkAddHeader,
      onReset: onResetHeader
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: header,
      onChange: onPickCssLibraryHeader
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Header Label"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Header Label"), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Source", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: headerLabel.options.textSrc,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Post title", "post-grid"),
        value: "post_title"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Term title", "post-grid"),
        value: "term_title"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Post meta", "post-grid"),
        value: "post_meta"
      }
      // { label: "Term meta", value: "term_meta" },
      // { label: "User meta", value: "user_meta" },
      ],
      onChange: newVal => {
        var options = {
          ...headerLabel.options,
          textSrc: newVal
        };
        setAttributes({
          headerLabel: {
            ...headerLabel,
            options: options
          }
        });
      }
    })), (headerLabel.options.textSrc == null || headerLabel.options.textSrc.length == 0) && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header Label Text", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "border border-gray-600 border-solid p-2 min-h-[75px] resize-y rounded-[6px]  "
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.RichText, {
      tagName: "span",
      value: headerLabel.options.text,
      allowedFormats: ["core/bold", "core/italic", "core/link"],
      onChange: newVal => {
        var options = {
          ...headerLabel.options,
          text: newVal
        };
        setAttributes({
          headerLabel: {
            ...headerLabel,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Writing...")
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: headerLabel.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }, {
        label: "a",
        value: "a"
      }],
      onChange: newVal => {
        var options = {
          ...headerLabel.options,
          tag: newVal
        };
        setAttributes({
          headerLabel: {
            ...headerLabel,
            options: options
          }
        });
      }
    })), headerLabel.options.tag == "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Slug", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: headerLabel.options.slug == undefined ? "" : headerLabel.options.slug,
      onChange: newVal => {
        var options = {
          ...headerLabel.options,
          slug: newVal
        };
        setAttributes({
          headerLabel: {
            ...headerLabel,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Label Icon?", "post-grid"),
      help: labelIcon.options.enable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Icon Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Icon Disabled.", "post-grid"),
      checked: labelIcon.options.enable ? true : false,
      onChange: e => {
        var options = {
          ...labelIcon.options,
          enable: labelIcon.options.enable ? false : true
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    }), labelIcon.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_14__["default"], {
      library: labelIcon.options.library,
      srcType: labelIcon.options.srcType,
      iconSrc: labelIcon.options.iconSrc,
      onChange: arg => {
        var options = {
          ...labelIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: headerLabel,
      onChange: onChangeStyleHeaderLabel,
      onAdd: onAddStyleHeaderLabel,
      onRemove: onRemoveStyleHeaderLabel,
      onBulkAdd: onBulkAddHeaderLabel,
      onReset: onResetHeaderLabel
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: headerLabel,
      onChange: onPickCssLibraryHeaderLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Label Icon"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Icon", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: labelIcon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Label", "post-grid"),
        value: "beforeLabel"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Label", "post-grid"),
        value: "afterLabel"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Label Text", "post-grid"),
        value: "beforeLabelText"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Label Text", "post-grid"),
        value: "afterLabelText"
      }],
      onChange: newVal => {
        var options = {
          ...labelIcon.options,
          position: newVal
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    })), labelIcon.options.position.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_14__["default"], {
      library: labelIcon.options.library,
      srcType: labelIcon.options.srcType,
      iconSrc: labelIcon.options.iconSrc,
      onChange: arg => {
        var options = {
          ...labelIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: labelIcon,
      onChange: onChangeStyleLabelIcon,
      onAdd: onAddStyleLabelIcon,
      onRemove: onRemoveStyleLabelIcon,
      onBulkAdd: onBulkAddLabelIcon,
      onReset: onResetLabelIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Label Counter"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Counter", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Header Counter?", "post-grid"),
      help: labelCounter.options?.enable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header Counter Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header Counter Disabled.", "post-grid"),
      checked: labelCounter.options.enable ? true : false,
      onChange: e => {
        var options = {
          ...labelCounter.options,
          enable: labelCounter.options.enable ? false : true
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Counter position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: labelCounter.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Left", "post-grid"),
        value: "left"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Right", "post-grid"),
        value: "right"
      }],
      onChange: newVal => {
        var options = {
          ...labelCounter.options,
          position: newVal
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: labelCounter.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...labelCounter.options,
          tag: newVal
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: labelCounter,
      onChange: onChangeStyleLabelCounter,
      onAdd: onAddStyleLabelCounter,
      onRemove: onRemoveStyleLabelCounter,
      onBulkAdd: onBulkAddLabelCounter,
      onReset: onResetLabelCounter
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: labelCounter,
      onChange: onPickCssLibraryLabelCounter
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Content"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Content", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: content.options.tag,
      options: [
      // { label: __("Choose","post-grid"), value: "" },
      {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...content.options,
          tag: newVal
        };
        setAttributes({
          content: {
            ...content,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: content,
      onChange: onChangeStyleContent,
      onAdd: onAddStyleContent,
      onRemove: onRemoveStyleContent,
      onBulkAdd: onBulkAddContent,
      onReset: onResetContent
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: content,
      onChange: onPickCssLibraryContent
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title= {__("Icon","post-grid")}
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_14__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: arg => {
        var options = {
          ...icon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Toggled Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_14__["default"], {
      library: iconToggle.options.library,
      srcType: iconToggle.options.srcType,
      iconSrc: iconToggle.options.iconSrc,
      onChange: arg => {
        var options = {
          ...iconToggle.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          iconToggle: {
            ...iconToggle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Left", "post-grid"),
        value: "left"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Right", "post-grid"),
        value: "right"
      }],
      onChange: newVal => {
        var options = {
          ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon,
      onReset: onResetIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomHeaderTag, {
      className: `${blockId}-accordion-header ${blockIdX}  ${header.options.class} ${toggled ? "accordion-header-active" : ""}`,
      onClick: ev => {
        setToggled(!toggled);
      }
    }, labelCounter.options.position == "left" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-counter accordion-label-counter`
    }, count), icon.options.position == "left" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-icon accordion-icon`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-icon-toggle accordion-icon accordion-icon-toggle}`,
      dangerouslySetInnerHTML: {
        __html: iconToggleHtml
      }
    })), labelIcon.options.position == "beforeLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-icon accordion-label-icon`,
      dangerouslySetInnerHTML: {
        __html: labelIconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomHeaderLabelTag, {
      className: `${blockId}-accordion-header-label accordion-header-label`,
      onClick: e => {
        return;
      }
    }, labelCounter.options.position == "beforeLabelText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-counter accordion-label-counter`
    }, count), labelIcon.options.position == "beforeLabelText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-icon accordion-label-icon`,
      dangerouslySetInnerHTML: {
        __html: labelIconHtml
      }
    }), headerLabel.options.text.length > 0 ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      "data-pgtooltip": "Navigate to the Item Header Label to edit the Label"
      // data-pgtooltip-location="right"
      ,
      onClick: ev => {
        wp.data.dispatch("core/block-editor").selectBlock(clientId);
      },
      dangerouslySetInnerHTML: {
        __html: headerLabel.options.text
      }
    }) : "Start Writing...", labelIcon.options.position == "afterLabelText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-icon accordion-label-icon`,
      dangerouslySetInnerHTML: {
        __html: labelIconHtml
      }
    }), labelCounter.options.position == "afterLabelText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-counter accordion-label-counter`
    }, count)), labelIcon.options.position == "afterLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-icon accordion-label-icon`,
      dangerouslySetInnerHTML: {
        __html: labelIconHtml
      }
    }), labelCounter.options.position == "right" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-label-counter accordion-label-counter`
    }, count), icon.options.position == "right" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-icon accordion-icon`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: `${blockId}-accordion-icon-toggle accordion-icon-toggle`,
      dangerouslySetInnerHTML: {
        __html: iconToggleHtml
      }
    }))), toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomContentWrapper, {
      className: `${blockId}-accordion-content accordion-content`
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks, {
      allowedBlocks: allowedExtraBlocks,
      renderAppender: () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.ButtonBlockAppender, null)
    }))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps.save({});
    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children);
  }
});

/***/ }),

/***/ "./src/blocks/accordion-nested/index.js":
/*!**********************************************!*\
  !*** ./src/blocks/accordion-nested/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./block.json */ "./src/blocks/accordion-nested/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_block_variations_picker__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/block-variations-picker */ "./src/components/block-variations-picker/index.js");















const {
  RawHTML
} = wp.element;














var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_19__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M160 27H0V45.8H160V27Z",
      fill: "url(#paint0_linear_61_752)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M17.6226 38.8999C17.4235 38.8999 17.3238 38.7998 17.2242 38.6998L13.9385 34.8999C13.7394 34.6999 13.7395 34.2998 14.0382 34.0998C14.2373 33.8998 14.6356 33.8998 14.8348 34.1998L17.722 37.5998L20.6095 34.1998C20.8087 33.9998 21.1072 33.8998 21.4059 34.0998C21.605 34.2998 21.7047 34.5999 21.5055 34.8999L18.2199 38.6998C17.9212 38.7998 17.8217 38.8999 17.6226 38.8999Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M104.443 33.8999H26.9819V38.7999H104.443V33.8999Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M160 71.3999H0V110.1H160V71.3999Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M160 49.2002H0V68.0002H160V49.2002Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M17.623 56.2002C17.8221 56.2002 17.9216 56.3003 18.0211 56.4003L21.3068 60.2002C21.5059 60.4002 21.5058 60.8002 21.2071 61.0002C21.008 61.2002 20.6097 61.2003 20.4106 60.9003L17.5233 57.5002L14.636 60.9003C14.4369 61.1003 14.1382 61.2002 13.8395 61.0002C13.5408 60.8002 13.5407 60.5002 13.7398 60.2002L17.0255 56.4003C17.3242 56.2003 17.4238 56.2002 17.623 56.2002Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M104.443 56.2002H26.9819V61.1002H104.443V56.2002Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M160 113.5H0V132.3H160V113.5Z",
      fill: "url(#paint1_linear_61_752)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M17.6226 125.4C17.4235 125.4 17.3238 125.3 17.2242 125.2L13.9385 121.4C13.7394 121.2 13.7395 120.8 14.0382 120.6C14.2373 120.4 14.6356 120.4 14.8348 120.7L17.722 124.1L20.6095 120.7C20.8087 120.5 21.1072 120.4 21.4059 120.6C21.605 120.8 21.7047 121.1 21.5055 121.4L18.2199 125.2C17.9212 125.3 17.8217 125.4 17.6226 125.4Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M104.443 120.4H26.9819V125.3H104.443V120.4Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_752",
      x1: "0",
      y1: "36.4",
      x2: "160",
      y2: "36.4",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_752",
      x1: "0",
      y1: "122.9",
      x2: "160",
      y2: "122.9",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var header = attributes.header;
    var headerActive = attributes.headerActive;
    var headerLabel = attributes.headerLabel;
    var labelIcon = attributes.labelIcon;
    var labelCounter = attributes.labelCounter;
    var searchWrap = attributes.searchWrap;
    var searchInput = attributes.searchInput;
    var schema = attributes.schema;
    var content = attributes.content;
    var icon = attributes.icon;
    var iconToggle = attributes.iconToggle;
    var accOptions = attributes.accOptions;
    var blockCssY = attributes.blockCssY;
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("isProFeature", true);
    var breakPointX = myStore.getBreakPoint();
    // Wrapper CSS Class Selectors
    var wrapperSelector = blockClass;
    const contentSelector = blockClass + " > .accordion-content";
    const headerSelector = blockClass + " > .accordion-header";
    const headerActiveSelector = blockClass + " > .accordion-header-active";
    const headerLabelSelector = blockClass + " > .accordion-header > .accordion-header-label";
    const labelIconSelector = blockClass + " > .accordion-header .accordion-label-icon";
    const labelCounterSelector = blockClass + " > .accordion-header .accordion-label-counter";
    const searchWrapSelector = blockClass + "-accordion-search-wrap";
    const searchInputSelector = blockClass + "-accordion-search-input";
    const iconSelector = blockClass + " > .accordion-header >  .accordion-icon";
    const iconToggleSelector = blockClass + " > .accordion-header >  .accordion-icon-toggle";
    const {
      replaceInnerBlocks
    } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.store);
    const hasInnerBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.store).getBlocks(clientId).length > 0, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlocksByClientId(clientId)[0].innerBlocks;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var count = 0;
      childBlocks.forEach(function (childBlock) {
        count++;
        var childClientId = childBlock.clientId;
        var childAttributes = {
          ...childBlock.attributes
        };
        childAttributes.count = count;
        (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.dispatch)("core/block-editor").updateBlockAttributes(childClientId, childAttributes);
      });
    }, [childBlocks]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[contentSelector] = content;
      blockCssObj[headerActiveSelector] = headerActive;
      blockCssObj[headerSelector] = header;
      blockCssObj[headerLabelSelector] = headerLabel;
      blockCssObj[labelCounterSelector] = labelCounter;
      blockCssObj[labelIconSelector] = labelIcon;
      blockCssObj[searchWrapSelector] = searchWrap;
      blockCssObj[searchInputSelector] = searchInput;
      blockCssObj[iconSelector] = icon;
      blockCssObj[iconToggleSelector] = iconToggle;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    function onPickBlockVariation(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
    }
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        // var blockId = attributes.blockId
        var wrapperX = attributes.wrapper;
        var headerX = attributes.header;
        var headerActiveX = attributes.headerActive;
        var headerLabelX = attributes.headerLabel;
        var labelIconX = attributes.labelIcon;
        var labelCounterX = attributes.labelCounter;
        var schemaX = attributes.schema;
        var contentX = attributes.content;
        var iconX = attributes.icon;
        var iconToggleX = attributes.iconToggle;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          //var wrapperY = { ...wrapperX, options: wrapper.options }
          setAttributes({
            wrapper: wrapperX
          });
          blockCssObj[wrapperSelector] = wrapperX;
        }
        if (headerX != undefined) {
          //var headerY = { ...headerX, options: header.options }
          setAttributes({
            header: headerX
          });
          blockCssObj[headerSelector] = headerX;
        }
        if (headerActiveX != undefined) {
          //var headerActiveY = { ...headerActiveX, options: headerActive.options }
          setAttributes({
            headerActive: headerActiveX
          });
          blockCssObj[headerActiveSelector] = headerActiveX;
        }
        if (headerLabelX != undefined) {
          //var headerLabelY = { ...headerLabelX, options: headerLabel.options }
          setAttributes({
            headerLabel: headerLabelX
          });
          blockCssObj[headerLabelSelector] = headerLabelX;
        }
        if (labelIconX != undefined) {
          //var labelIconY = { ...labelIconX, options: labelIcon.options }
          setAttributes({
            labelIcon: labelIconX
          });
          blockCssObj[labelIconSelector] = labelIconX;
        }
        if (labelCounterX != undefined) {
          //var labelCounterY = { ...labelCounterX, options: labelCounter.options }
          setAttributes({
            labelCounter: labelCounterX
          });
          blockCssObj[labelCounterSelector] = labelCounterX;
        }
        if (schemaX != undefined) {
          var schemaY = {
            ...schemaX,
            options: schema.options
          };
          setAttributes({
            schema: schemaY
          });
          //blockCssObj[schemaSelector] = schemaY;
        }
        if (contentX != undefined) {
          //var contentY = { ...contentX, options: content.options }
          setAttributes({
            content: contentX
          });
          blockCssObj[contentSelector] = contentX;
        }
        if (iconX != undefined) {
          //var iconY = { ...iconX, options: icon.options }
          setAttributes({
            icon: iconX
          });
          blockCssObj[iconSelector] = iconX;
        }
        if (iconToggleX != undefined) {
          //var iconToggleY = { ...iconToggleX, options: iconToggle.options }
          setAttributes({
            iconToggle: iconToggleX
          });
          blockCssObj[iconToggleSelector] = iconToggleX;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleHeader(sudoScource, key) {
      let obj = {
        ...header
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        header: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleHeaderActive(sudoScource, key) {
      let obj = {
        ...headerActive
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        headerActive: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleHeaderLabel(sudoScource, key) {
      let obj = {
        ...headerLabel
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        headerLabel: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleLabelCounter(sudoScource, key) {
      let obj = {
        ...labelCounter
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        labelCounter: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleLabelIcon(sudoScource, key) {
      let obj = {
        ...labelIcon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        labelIcon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelIconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleContent(sudoScource, key) {
      let obj = {
        ...content
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        content: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIcon(sudoScource, key) {
      let obj = {
        ...icon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        icon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIconToggle(sudoScource, key) {
      let obj = {
        ...iconToggle
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        iconToggle: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleSearchWrap(sudoScource, key) {
      let obj = {
        ...searchWrap
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        searchWrap: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleSearchInput(sudoScource, key) {
      let obj = {
        ...searchInput
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        searchInput: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchInputSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onChangeStyleHeader(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleHeader(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        header: object
      });
    }
    function onPickCssLibraryHeader(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        header[sudoScource] = sudoScourceArgs;
      });
      var headerX = Object.assign({}, header);
      setAttributes({
        header: headerX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    // #########
    function onChangeStyleHeaderActive(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleHeaderActive(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        headerActive: object
      });
    }
    function onPickCssLibraryHeaderActive(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        headerActive[sudoScource] = sudoScourceArgs;
      });
      var headerActiveX = Object.assign({}, headerActive);
      setAttributes({
        headerActive: headerActiveX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    //########
    function onChangeStyleHeaderLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerLabel: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleHeaderLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        headerLabel: object
      });
    }
    function onPickCssLibraryHeaderLabel(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        headerLabel[sudoScource] = sudoScourceArgs;
      });
      var headerLabelX = Object.assign({}, headerLabel);
      setAttributes({
        headerLabel: headerLabelX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleLabelCounter(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelCounter: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleLabelCounter(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        labelCounter: object
      });
    }
    function onPickCssLibraryLabelCounter(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        labelCounter[sudoScource] = sudoScourceArgs;
      });
      var labelCounterX = Object.assign({}, labelCounter);
      setAttributes({
        labelCounter: labelCounterX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleLabelIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelIcon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelIcon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelIconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleLabelIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelIcon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        labelIcon: object
      });
    }
    function onChangeStyleContent(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleContent(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        content: object
      });
    }
    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        icon: object
      });
    }
    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleIconToggle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        iconToggle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIconToggle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        iconToggle: object
      });
    }
    function onPickCssLibraryIconToggle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        iconToggle[sudoScource] = sudoScourceArgs;
      });
      var iconToggleX = Object.assign({}, iconToggle);
      setAttributes({
        iconToggle: iconToggleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryContent(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        content[sudoScource] = sudoScourceArgs;
      });
      var contentX = Object.assign({}, content);
      setAttributes({
        content: contentX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleSearchWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, searchWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        searchWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleSearchWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, searchWrap);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        searchWrap: object
      });
    }
    function onChangeStyleSearchInput(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, searchInput);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        searchInput: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchInputSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleSearchInput(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, searchInput);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        searchInput: object
      });
    }
    // add bulk style start
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddHeader(sudoScource, cssObj) {
      let obj = Object.assign({}, header);
      obj[sudoScource] = cssObj;
      setAttributes({
        header: obj
      });
      var selector = myStore.getElementSelector(sudoScource, headerSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddHeaderActive(sudoScource, cssObj) {
      let obj = Object.assign({}, headerActive);
      obj[sudoScource] = cssObj;
      setAttributes({
        headerActive: obj
      });
      var selector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddHeaderLabel(sudoScource, cssObj) {
      let obj = Object.assign({}, headerLabel);
      obj[sudoScource] = cssObj;
      setAttributes({
        headerLabel: obj
      });
      var selector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddLabelIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, labelIcon);
      obj[sudoScource] = cssObj;
      setAttributes({
        labelIcon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelIconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddLabelCounter(sudoScource, cssObj) {
      let obj = Object.assign({}, labelCounter);
      obj[sudoScource] = cssObj;
      setAttributes({
        labelCounter: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddContent(sudoScource, cssObj) {
      let obj = Object.assign({}, content);
      obj[sudoScource] = cssObj;
      setAttributes({
        content: obj
      });
      var selector = myStore.getElementSelector(sudoScource, contentSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIconToggle(sudoScource, cssObj) {
      let obj = Object.assign({}, iconToggle);
      obj[sudoScource] = cssObj;
      setAttributes({
        iconToggle: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    // add bulk style end
    // reset style start
    function onResetWrapper(sudoScources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onResetHeader(sudoScources) {
      let obj = Object.assign({}, header);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        header: obj
      });
    }
    function onResetHeaderActive(sudoScources) {
      let obj = Object.assign({}, headerActive);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        headerActive: obj
      });
    }
    function onResetHeaderLabel(sudoScources) {
      let obj = Object.assign({}, headerLabel);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        headerLabel: obj
      });
    }
    function onResetLabelIcon(sudoScources) {
      let obj = Object.assign({}, labelIcon);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, labelIconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        labelIcon: obj
      });
    }
    function onResetLabelCounter(sudoScources) {
      let obj = Object.assign({}, labelCounter);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        labelCounter: obj
      });
    }
    function onResetContent(sudoScources) {
      let obj = Object.assign({}, content);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        content: obj
      });
    }
    function onResetIcon(sudoScources) {
      let obj = Object.assign({}, icon);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        icon: obj
      });
    }
    function onResetIconToggle(sudoScources) {
      let obj = Object.assign({}, iconToggle);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        iconToggle: obj
      });
    }
    // reset style end
    const ALLOWED_BLOCKS = ["post-grid/accordion-nested-item", "post-grid/accordion"];
    const MY_TEMPLATE = [["post-grid/accordion-nested-item", {}], ["post-grid/accordion-nested-item", {}]];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options?.class} `
    });
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps)(blockProps, {
      allowedBlocks: ALLOWED_BLOCKS,
      // directInsert : true,
      template: MY_TEMPLATE
      //templateInsertUpdatesSelection: true,
    });
    const addChild = () => {
      var childBlocks = wp.data.select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.store).getBlocks(clientId);
      const slide = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)("post-grid/accordion-nested-item");
      const position = childBlocks.length;
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.dispatch)("core/block-editor").insertBlock(slide, position, clientId);
      wp.data.dispatch("core/block-editor").selectBlock(clientId);
      //setActiveTab(slide.clientId);
    };
    // const selectedBlock = useSelect((select) =>
    // 	select("core/block-editor").getSelectedBlock()
    // );
    // const dupChild = () => {
    // 	var serelized = wp.blocks.serialize(selectedBlock);
    // 	wp.data
    // 		.dispatch("core/block-editor")
    // 		.insertBlocks(wp.blocks.parse(serelized));
    // }
    var accOptionsArgs = {
      active: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Active", "post-grid"),
        value: "0"
      },
      animate: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Animate", "post-grid"),
        value: "500"
      },
      collapsible: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Collapsible", "post-grid"),
        value: false
      },
      disabled: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Disabled", "post-grid"),
        value: false
      },
      event: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Event", "post-grid"),
        value: "click"
      },
      // header: { label: "Header", value: "div" },
      heightStyle: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Height Style", "post-grid"),
        value: "auto"
      }
    };
    var RemoveAccArg = function ({
      index
    }) {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "cursor-pointer hover:bg-red-500 hover:text-white ",
        onClick: ev => {
          var accOptionsX = {
            ...accOptions
          };
          delete accOptionsX[index];
          setAttributes({
            accOptions: accOptionsX
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"]
      }));
    };
    // var RemoveAccArgRes = function ({ index }) {
    // 	return (
    // 		<span
    // 			className="cursor-pointer hover:bg-red-500 hover:text-white "
    // 			onClick={(ev) => {
    // 				var sliderOptionsResX = { ...sliderOptionsRes };
    // 				delete sliderOptionsResX[index];
    // 				setAttributes({ sliderOptionsRes: sliderOptionsResX });
    // 			}}>
    // 			<Icon icon={close} />
    // 		</span>
    // 	);
    // };
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-font flex gap-2 justify-center my-2 cursor-pointer py-2 px-4 capitalize tracking-wide bg-gray-700 text-white font-medium rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-700 mx-3"
      // className="bg-gray-700 hover:bg-gray-600 mx-3 my-2 cursor-pointer hover:text-white font-bold text-[16px] px-5 py-2 block text-center text-white rounded"
      ,
      onClick: ev => {
        addChild();
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Add Item", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_22__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options?.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "hidden"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", null, "Accordion Options"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: "Choose",
      options: accOptionsArgs,
      onChange: (option, index) => {
        var accOptionsX = {
          ...accOptions
        };
        accOptionsX[index] = option.value;
        setAttributes({
          accOptions: accOptionsX
        });
      },
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex flex-col gap-2 items-start"
    }, Object.entries(accOptions).map((item, index) => {
      var id = item[0];
      var value = item[1];
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        key: index
      }, id == "active" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Active?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = newVal;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })), id == "animate" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Animate?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = newVal;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })), id == "header" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Header?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        value: value,
        type: "text",
        onChange: newVal => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = newVal;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })), id == "event" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Event?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        value: value,
        type: "text",
        onChange: newVal => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = newVal;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })), id == "disabled" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Disabled?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
        help: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Disabled.", "post-grid"),
        checked: value ? true : false,
        onChange: e => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = value ? false : true;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })), id == "collapsible" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Collapsible?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
        help: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Disabled.", "post-grid"),
        checked: value ? true : false,
        onChange: e => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = value ? false : true;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })), id == "heightStyle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
        className: "gap-2 justify-between "
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveAccArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, "Height Style?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: "Auto",
          value: "auto"
        }, {
          label: "Fill",
          value: "fill"
        }, {
          label: "Content",
          value: "content"
        }],
        onChange: newVal => {
          var accOptionsX = {
            ...accOptions
          };
          accOptionsX[id] = newVal;
          setAttributes({
            accOptions: accOptionsX
          });
        }
      })));
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: "Header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: header.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...header.options,
          tag: newVal
        };
        setAttributes({
          header: {
            ...header,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Override Child?", "post-grid"),
      help: header.options.overrideChild ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Disabled.", "post-grid"),
      checked: header.options.overrideChild ? true : false,
      onChange: e => {
        var options = {
          ...header.options,
          overrideChild: header.options.overrideChild ? false : true
        };
        setAttributes({
          header: {
            ...header,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: header,
      onChange: onChangeStyleHeader,
      onAdd: onAddStyleHeader,
      onRemove: onRemoveStyleHeader,
      onBulkAdd: onBulkAddHeader,
      onReset: onResetHeader
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: header,
      onChange: onPickCssLibraryHeader
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: "Header Active",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: headerActive,
      onChange: onChangeStyleHeaderActive,
      onAdd: onAddStyleHeaderActive,
      onRemove: onRemoveStyleHeaderActive,
      onBulkAdd: onBulkAddHeaderActive,
      onReset: onResetHeaderActive
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: headerActive,
      onChange: onPickCssLibraryHeaderActive
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: "Header Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: headerLabel.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }, {
        label: "a",
        value: "a"
      }],
      onChange: newVal => {
        var options = {
          ...headerLabel.options,
          tag: newVal
        };
        setAttributes({
          headerLabel: {
            ...headerLabel,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Override Child?", "post-grid"),
      help: headerLabel.options.overrideChild ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Disabled.", "post-grid"),
      checked: headerLabel.options.overrideChild ? true : false,
      onChange: e => {
        var options = {
          ...headerLabel.options,
          overrideChild: headerLabel.options.overrideChild ? false : true
        };
        setAttributes({
          headerLabel: {
            ...headerLabel,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: headerLabel,
      onChange: onChangeStyleHeaderLabel,
      onAdd: onAddStyleHeaderLabel,
      onRemove: onRemoveStyleHeaderLabel,
      onBulkAdd: onBulkAddHeaderLabel,
      onReset: onResetHeaderLabel
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: headerLabel,
      onChange: onPickCssLibraryHeaderLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Label Counter"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Counter", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white ",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Header Counter?", "post-grid"),
      help: labelCounter.options?.enable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header Counter Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header Counter Disabled.", "post-grid"),
      checked: labelCounter.options.enable ? true : false,
      onChange: e => {
        var options = {
          ...labelCounter.options,
          enable: labelCounter.options.enable ? false : true
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Counter position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: labelCounter.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Left", "post-grid"),
        value: "left"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Right", "post-grid"),
        value: "right"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Label Text", "post-grid"),
        value: "beforeLabelText"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Label Text", "post-grid"),
        value: "afterLabelText"
      }],
      onChange: newVal => {
        var options = {
          ...labelCounter.options,
          position: newVal
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "pb-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: labelCounter.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...labelCounter.options,
          tag: newVal
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Override Child?", "post-grid"),
      help: labelCounter.options.overrideChild ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Disabled.", "post-grid"),
      checked: labelCounter.options.overrideChild ? true : false,
      onChange: e => {
        var options = {
          ...labelCounter.options,
          overrideChild: labelCounter.options.overrideChild ? false : true
        };
        setAttributes({
          labelCounter: {
            ...labelCounter,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: labelCounter,
      onChange: onChangeStyleLabelCounter,
      onAdd: onAddStyleLabelCounter,
      onRemove: onRemoveStyleLabelCounter,
      onBulkAdd: onBulkAddLabelCounter,
      onReset: onResetLabelCounter
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: labelCounter,
      onChange: onPickCssLibraryLabelCounter
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Label Icon"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Icon", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white ",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "pb-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: labelIcon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Label", "post-grid"),
        value: "beforeLabel"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Label", "post-grid"),
        value: "afterLabel"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Label Text", "post-grid"),
        value: "beforeLabelText"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Label Text", "post-grid"),
        value: "afterLabelText"
      }],
      onChange: newVal => {
        var options = {
          ...labelIcon.options,
          position: newVal
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    })), labelIcon.options.position.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "pb-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: labelIcon.options.library,
      srcType: labelIcon.options.srcType,
      iconSrc: labelIcon.options.iconSrc,
      onChange: arg => {
        var options = {
          ...labelIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Override Child?", "post-grid"),
      help: labelIcon.options.overrideChild ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Enabled", "post-grid")) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Disabled.", "post-grid")),
      checked: labelIcon.options.overrideChild ? true : false,
      onChange: e => {
        var options = {
          ...labelIcon.options,
          overrideChild: labelIcon.options.overrideChild ? false : true
        };
        setAttributes({
          labelIcon: {
            ...labelIcon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: labelIcon,
      onChange: onChangeStyleLabelIcon,
      onAdd: onAddStyleLabelIcon,
      onRemove: onRemoveStyleLabelIcon,
      onBulkAdd: onBulkAddLabelIcon,
      onReset: onResetLabelIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: "Content",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: content.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...content.options,
          tag: newVal
        };
        setAttributes({
          content: {
            ...content,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "mt-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Override Child?", "post-grid"),
      help: content.options.overrideChild ? "Override Child Enabled" : "Override Child Disabled.",
      checked: content.options.overrideChild ? true : false,
      onChange: e => {
        var options = {
          ...content.options,
          overrideChild: content.options.overrideChild ? false : true
        };
        setAttributes({
          content: {
            ...content,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: content,
      onChange: onChangeStyleContent,
      onAdd: onAddStyleContent,
      onRemove: onRemoveStyleContent,
      onBulkAdd: onBulkAddContent,
      onReset: onResetContent
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: content,
      onChange: onPickCssLibraryContent
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: arg => {
        var options = {
          ...icon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Toggled Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: iconToggle.options.library,
      srcType: iconToggle.options.srcType,
      iconSrc: iconToggle.options.iconSrc,
      onChange: arg => {
        var options = {
          ...iconToggle.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          iconToggle: {
            ...iconToggle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Left", "post-grid"),
        value: "left"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Right", "post-grid"),
        value: "right"
      }],
      onChange: newVal => {
        var options = {
          ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Override Child?", "post-grid"),
      help: icon.options.overrideChild ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Enabled", "post-grid")) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Override Child Disabled.", "post-grid")),
      checked: icon.options.overrideChild ? true : false,
      onChange: e => {
        var options = {
          ...icon.options,
          overrideChild: icon.options.overrideChild ? false : true
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon,
      onReset: onResetIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Schema", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Schema?", "post-grid"),
      help: schema.options.enable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Schema Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Schema Disabled.", "post-grid"),
      checked: schema.options.enable ? true : false,
      onChange: e => {
        var options = {
          ...schema.options,
          enable: schema.options.enable ? false : true
        };
        setAttributes({
          schema: {
            ...schema,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium hidden text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Search", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Search?", "post-grid"),
      help: searchWrap.options.enable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Search Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Search Disabled.", "post-grid"),
      disabled: isProFeature,
      checked: searchWrap.options.enable ? true : false,
      onChange: e => {
        var options = {
          ...searchWrap.options,
          enable: searchWrap.options.enable ? false : true
        };
        setAttributes({
          searchWrap: {
            ...searchWrap,
            options: options
          }
        });
      }
    }), isProFeature && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white "
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      target: "_blank",
      href: "https://comboblocks.com/pricing/?utm_source=search&utm_term=blockaccordion&utm_campaign=pluginPostGrid&utm_medium=search"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Search Wrap", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: searchWrap,
      onChange: onChangeStyleSearchWrap,
      onAdd: onAddStyleSearchWrap,
      onRemove: onRemoveStyleSearchWrap,
      onBulkAdd: onBulkAddIconToggle,
      onReset: onResetIconToggle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Search Input", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: searchInput,
      onChange: onChangeStyleSearchInput,
      onAdd: onAddStyleSearchInput,
      onRemove: onRemoveStyleSearchInput
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block Variations", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_library_block_variations__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockName: blockNameLast,
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockPatterns
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_17__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...innerBlocksProps,
      className: "flex justify-center my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "border border-solid border-gray-300 w-[95%] rounded-md p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Click to pick a variation", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-gray-700 rounded-sm px-4 py-1 font-semibold text-lg text-white cursor-pointer",
      onClick: ev => {
        replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)([["post-grid/accordion-nested-item", {
          blockId: "XYZ123"
        }]]), true);
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Skip", "post-grid"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...innerBlocksProps,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_block_variations_picker__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockName: "accordion-nested",
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockVariation
    })))), hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...innerBlocksProps
    }, searchWrap.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: `${blockId}-accordion-search-wrap`
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("input", {
      className: `${blockId}-accordion-search-input my-4`,
      type: searchInput.options.type,
      placeholder: searchInput.options.placeholder,
      value: searchInput.options.value
    })), innerBlocksProps.children)));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var blockId = attributes.blockId;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps.save({
      className: ` ${blockId} pg-accordion-nested`
    });
    //const innerBlocksProps = useInnerBlocksProps.save(blockProps);
    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children);
    //return null;
  }
});

/***/ }),

/***/ "./src/blocks/archive-description/index.js":
/*!*************************************************!*\
  !*** ./src/blocks/archive-description/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./block.json */ "./src/blocks/archive-description/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_block_variations_picker__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/block-variations-picker */ "./src/components/block-variations-picker/index.js");












const {
  RawHTML
} = wp.element;















var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_18__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M68.7776 49.5732H20.9824C19.9261 49.5732 18.913 49.9929 18.1661 50.7398C17.4191 51.4868 16.9995 52.4998 16.9995 53.5562V93.3855C16.9995 94.4418 17.4191 95.4549 18.1661 96.2018C18.913 96.9488 19.9261 97.3684 20.9824 97.3684H68.7776C69.8339 97.3684 70.847 96.9488 71.594 96.2018C72.3409 95.4549 72.7605 94.4418 72.7605 93.3855V53.5562C72.7605 52.4998 72.3409 51.4868 71.594 50.7398C70.847 49.9929 69.8339 49.5732 68.7776 49.5732ZM64.7947 89.4025H24.9654V57.5391H64.7947V89.4025Z",
      fill: "url(#paint0_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M152.42 61.5222H88.6929V69.4881H152.42V61.5222Z",
      fill: "url(#paint1_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M136.488 77.4539H88.6929V85.4197H136.488V77.4539Z",
      fill: "url(#paint2_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M68.7776 112.205H20.9824C19.9261 112.205 18.913 112.624 18.1661 113.371C17.4191 114.118 16.9995 115.131 16.9995 116.188V156.017C16.9995 157.073 17.4191 158.086 18.1661 158.833C18.913 159.58 19.9261 160 20.9824 160H68.7776C69.8339 160 70.847 159.58 71.594 158.833C72.3409 158.086 72.7605 157.073 72.7605 156.017V116.188C72.7605 115.131 72.3409 114.118 71.594 113.371C70.847 112.624 69.8339 112.205 68.7776 112.205ZM64.7947 152.034H24.9654V120.171H64.7947V152.034Z",
      fill: "url(#paint3_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M152.42 124.154H88.6929V132.12H152.42V124.154Z",
      fill: "url(#paint4_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M136.488 140.085H88.6929V148.051H136.488V140.085Z",
      fill: "url(#paint5_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M132 0H16.9995V11H132V0Z",
      fill: "url(#paint6_linear_61_482)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M82.9995 28H16.9995V33H82.9995V28Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M103 19H16.9995V24H103V19Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_482",
      x1: "16.9995",
      y1: "73.4708",
      x2: "72.7605",
      y2: "73.4708",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_482",
      x1: "88.6929",
      y1: "65.5051",
      x2: "152.42",
      y2: "65.5051",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint2_linear_61_482",
      x1: "88.6929",
      y1: "81.4368",
      x2: "136.488",
      y2: "81.4368",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint3_linear_61_482",
      x1: "16.9995",
      y1: "136.102",
      x2: "72.7605",
      y2: "136.102",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint4_linear_61_482",
      x1: "88.6929",
      y1: "128.137",
      x2: "152.42",
      y2: "128.137",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint5_linear_61_482",
      x1: "88.6929",
      y1: "144.068",
      x2: "136.488",
      y2: "144.068",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint6_linear_61_482",
      x1: "16.9995",
      y1: "5.5",
      x2: "132",
      y2: "5.5",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    let archiveTitle = attributes.archiveTitle;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    var breakPointX = myStore.getBreakPoint();
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("isProFeature", true);
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    var archiveLinkToArgsBasic = {
      none: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No Link", "post-grid"),
        value: ""
      },
      archiveUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Archive URL", "post-grid"),
        value: "archiveUrl"
      },
      homeUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Home URL", "post-grid"),
        value: "homeUrl"
      },
      customUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom", "post-grid"),
        value: "customUrl"
      }
    };
    let archiveLinkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("archiveLinkToArgs", archiveLinkToArgsBasic);
    var archiveTypes = {
      auto: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Auto Detect", "post-grid"),
        value: "auto"
      }
      // 'author': { label: 'Author', value: 'author' },
      // 'category': { label: 'Category', value: 'category' },
      // 'tag': { label: 'Tag', value: 'tag' },
      // 'taxonomy': { label: 'Taxonomy', value: 'taxonomy' },
      // 'search': { label: 'Search', value: 'search' },
      // 'index': { label: 'Index', value: 'index' },
      // 'year': { label: 'Year', value: 'year' },
      // 'month': { label: 'Month', value: 'month' },
      // 'date': { label: 'Date', value: 'date' },
      // 'wcCatalog': { label: 'WooCommerce Catalog', value: 'wcCatalog' },
      // 'wcSearch': { label: 'WooCommerce Search', value: 'wcSearch' },
    };
    var dateFormats = {
      "Y-M-d": {
        label: "2022-May-25",
        value: "Y-M-d"
      },
      "Y-m-d": {
        label: "2022-05-25",
        value: "Y-m-d"
      },
      "d-m-y": {
        label: "25-05-2022",
        value: "d-m-y"
      },
      "d/m/y": {
        label: "25/05/2022",
        value: "d/m/y"
      },
      "y-m-d": {
        label: "2022-05-25",
        value: "y-m-d"
      },
      "y/m/d": {
        label: "2022/05/25",
        value: "y/m/d"
      },
      "D M y": {
        label: "Sun May 2022",
        value: "D M y"
      },
      "D M d, y": {
        label: "Sun May 11, 2022",
        value: "D M d, y"
      },
      "M D d, y": {
        label: "May Sun 11, 2022",
        value: "M D d, y"
      },
      "M d, y": {
        label: "May 11, 2022",
        value: "M d, y"
      },
      "d M y": {
        label: "25 May 2022",
        value: "d M y"
      }
    };
    // Wrapper CSS Class Selectors
    const wrapperSelector = blockClass;
    var archiveTitleSelector = "";
    if (wrapper.options.tag.length != 0) {
      if (archiveTitle.options.linkTo.length > 0) {
        archiveTitleSelector = blockClass + " a";
      } else {
        // archiveTitleSelector = blockClass;
        archiveTitleSelector = blockClass + " .archiveTitle";
      }
    } else {
      archiveTitleSelector = blockClass;
    }
    const prefixSelector = blockClass + " .prefix";
    const postfixSelector = blockClass + " .postfix";
    const iconSelector = blockClass + " .postdate-icon";
    const [archiveTitleEdited, setarchiveTitleEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("Hello %s");
    const [prefixText, setprefixText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(myStore.parseCustomTags(prefix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"]));
    const [postfixText, setpostfixText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(myStore.parseCustomTags(postfix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"]));
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var text = myStore.parseCustomTags(prefix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"]);
      setprefixText(text);
    }, [prefix.options.text]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var text = myStore.parseCustomTags(postfix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"]);
      setpostfixText(text);
    }, [postfix.options.text]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[archiveTitleSelector] = archiveTitle;
      blockCssObj[iconSelector] = icon;
      blockCssObj[prefixSelector] = prefix;
      blockCssObj[postfixSelector] = postfix;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    function onChangeIcon(arg) {
      var options = {
        ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: {
          ...icon,
          options: options
        }
      });
    }
    function setFieldLinkTo(option, index) {
      var options = {
        ...archiveTitle.options,
        linkTo: option.value
      };
      setAttributes({
        archiveTitle: {
          ...archiveTitle,
          options: options
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var archiveType = archiveTitle.options.archiveType;
      if (archiveType == "auto") {
        //archiveTitleEdited = archiveTitle.options.customLabel;
        setarchiveTitleEdited(archiveTitle.options.customLabel);
      }
    }, [archiveTitle]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        // var blockId = attributes.blockId
        var wrapperX = attributes.wrapper;
        var archiveTitleX = attributes.archiveTitle;
        var iconX = attributes.icon;
        var prefixX = attributes.prefix;
        var postfixX = attributes.postfix;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        if (archiveTitleX != undefined) {
          var archiveTitleY = {
            ...archiveTitleX,
            options: archiveTitle.options
          };
          setAttributes({
            archiveTitle: archiveTitleY
          });
          blockCssObj[archiveTitleSelector] = archiveTitleY;
        }
        if (iconX != undefined) {
          var iconY = {
            ...iconX,
            options: icon.options
          };
          setAttributes({
            icon: iconY
          });
          blockCssObj[iconSelector] = iconY;
        }
        if (prefixX != undefined) {
          var prefixY = {
            ...prefixX,
            options: prefix.options
          };
          setAttributes({
            prefix: prefixY
          });
          blockCssObj[prefixSelector] = prefixY;
        }
        if (postfixX != undefined) {
          var postfixY = {
            ...postfixX,
            options: postfix.options
          };
          setAttributes({
            postfix: postfixY
          });
          blockCssObj[postfixSelector] = postfixY;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function onPickCssLibraryWrapper(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        wrapper[sudoScource] = sudoScourceArgs;
      });
      var wrapperX = Object.assign({}, wrapper);
      setAttributes({
        wrapper: wrapperX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryArchiveTitle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        archiveTitle[sudoScource] = sudoScourceArgs;
      });
      var archiveTitleX = Object.assign({}, archiveTitle);
      setAttributes({
        archiveTitle: archiveTitleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryPrefix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        prefix[sudoScource] = sudoScourceArgs;
      });
      var prefixX = Object.assign({}, prefix);
      setAttributes({
        prefix: prefixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryPostfix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        postfix[sudoScource] = sudoScourceArgs;
      });
      var postfixX = Object.assign({}, postfix);
      setAttributes({
        postfix: postfixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleArchiveTitle(sudoScource, key) {
      let obj = {
        ...archiveTitle
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        archiveTitle: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIcon(sudoScource, key) {
      let obj = {
        ...icon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        icon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStylePrefix(sudoScource, key) {
      let obj = {
        ...prefix
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        prefix: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStylePostfix(sudoScource, key) {
      let obj = {
        ...postfix
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        postfix: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onResetArchiveTitle(sudoSources) {
      let obj = Object.assign({}, archiveTitle);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        archiveTitle: obj
      });
    }
    function onResetIcon(sudoSources) {
      let obj = Object.assign({}, icon);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        icon: obj
      });
    }
    function onResetPrefix(sudoSources) {
      let obj = Object.assign({}, prefix);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        prefix: obj
      });
    }
    function onResetPostfix(sudoSources) {
      let obj = Object.assign({}, postfix);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        postfix: obj
      });
    }
    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        icon: object
      });
    }
    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStylePrefix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        prefix: object
      });
    }
    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        postfix: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddArchiveTitle(sudoScource, cssObj) {
      let obj = Object.assign({}, archiveTitle);
      obj[sudoScource] = cssObj;
      setAttributes({
        archiveTitle: obj
      });
      var selector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddPrefix(sudoScource, cssObj) {
      let obj = Object.assign({}, prefix);
      obj[sudoScource] = cssObj;
      setAttributes({
        prefix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, prefixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddPostfix(sudoScource, cssObj) {
      let obj = Object.assign({}, postfix);
      obj[sudoScource] = cssObj;
      setAttributes({
        postfix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, postfixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    String.prototype.strtr = function (dic) {
      const str = this.toString(),
        makeToken = inx => `{{###~${inx}~###}}`,
        tokens = Object.keys(dic).map((key, inx) => ({
          key,
          val: dic[key],
          token: makeToken(inx)
        })),
        tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);
      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "link", postId);
    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleArchiveTitle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleArchiveTitle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        archiveTitle: object
      });
    }
    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({}); // Using the hook.
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      linkAttrObj();
    }, [archiveTitle]);
    var linkAttrObj = () => {
      var sdsd = {};
      archiveTitle.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };
    var postUrl = archiveTitle.options.customUrl != undefined && archiveTitle.options.customUrl.length > 0 ? archiveTitle.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${archiveTitle.options.tag}`;
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class}`
    });
    function onPickBlockVariation(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
    }
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "span",
        value: "span"
      }, {
        label: "div",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Archive Description", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Archive Type", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveTypes
      // buttonTitle="Choose"
      ,
      buttonTitle: archiveTypes[archiveTitle.options.archiveType] != undefined ? archiveTypes[archiveTitle.options.archiveType].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
      onChange: (option, index) => {
        var options = {
          ...archiveTitle.options,
          archiveType: option.value
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      },
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Label", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.customLabel,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          customLabel: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), (archiveTitle.options.archiveType == "year" || archiveTitle.options.archiveType == "month" || archiveTitle.options.archiveType == "day") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Date Format", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: dateFormats,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = {
          ...archiveTitle.options,
          dateFormat: option.value
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      },
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Format", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.dateFormat,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          dateFormat: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), dateFormats[archiveTitle.options.dateFormat] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2 my-3 bg-gray-500 text-white"
    }, dateFormats[archiveTitle.options.dateFormat].label)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link To", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveLinkToArgs,
      buttonTitle: archiveTitle.options.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid") : archiveLinkToArgs[archiveTitle.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), archiveTitle.options.linkTo == "customField" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Field Key", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.linkToMetaKey,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          linkToMetaKey: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo == "customUrl" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom URL", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : "",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), archiveTitle.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = {
          ...archiveTitle.options,
          customUrl: ""
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: archiveTitle.options.customUrl,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          customUrl: newVal.url
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", archiveTitle.options.customUrl.length != 0 ? archiveTitle.options.customUrl : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No link", "post-grid"), " ")))), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          tag: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link Target", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.linkTarget,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose...", "post-grid"),
        value: ""
      }, {
        label: "_self",
        value: "_self"
      }, {
        label: "_blank",
        value: "_blank"
      }, {
        label: "_parent",
        value: "_parent"
      }, {
        label: "_top",
        value: "_top"
      }],
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          linkTarget: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Attributes", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      // className=" cursor-pointer px-3 text-white py-1 bg-gray-700 hover:bg-gray-600"
      className: "flex gap-2 justify-center my-2 cursor-pointer py-2 px-4 capitalize tracking-wide bg-gray-700 text-white font-medium rounded hover:!bg-gray-700 hover:text-white  focus:outline-none focus:bg-gray-700",
      onClick: ev => {
        var sdsd = archiveTitle.options.linkAttr.concat({
          id: "",
          val: ""
        });
        var options = {
          ...archiveTitle.options,
          linkAttr: sdsd
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), archiveTitle.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "my-2",
        key: i
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Name",
        value: archiveTitle.options.linkAttr[i].id,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].id = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = {
            ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: {
              ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].val = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = {
            ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: {
              ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        // className="text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close"
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          archiveTitle.options.linkAttr.splice(i, 1);
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = {
            ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: {
              ...archiveTitle,
              options: options
            }
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"]
      }))));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: archiveTitle.options.class,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          class: newVal
        };
        setAttributes({
          archiveTitle: {
            styles: archiveTitle.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: archiveTitle,
      onChange: onChangeStyleArchiveTitle,
      onAdd: onAddStyleArchiveTitle,
      onRemove: onRemoveStyleArchiveTitle,
      onBulkAdd: onBulkAddArchiveTitle,
      onReset: onResetArchiveTitle
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: archiveTitle,
      onChange: onPickCssLibraryArchiveTitle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title= {__("Icon","post-grid")}
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_11__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Archive Title", "post-grid"),
        value: "beforeArchiveTitle"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Archive Title", "post-grid"),
        value: "afterArchiveTitle"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Prefix", "post-grid"),
        value: "beforePrefix"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Prefix", "post-grid"),
        value: "afterPrefix"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Postfix", "post-grid"),
        value: "beforePostfix"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Postfix", "post-grid"),
        value: "afterPostfix"
      }],
      onChange: newVal => {
        var options = {
          ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon,
      onReset: onResetIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Postfix"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Prefix", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"],
      label: "Prefix",
      placeholder: "Add Prefix",
      value: prefix.options.text,
      onChange: newVal => {
        var options = {
          ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: prefix,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix,
      onBulkAdd: onBulkAddPrefix,
      onReset: onResetPrefix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: prefix,
      onChange: onPickCssLibraryPrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Postfix"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Postfix", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_12__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"],
      label: "Postfix",
      placeholder: "Add Postfix",
      value: postfix.options.text,
      onChange: newVal => {
        var options = {
          ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: {
            styles: postfix.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_14__["default"], {
      obj: postfix,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix,
      onBulkAdd: onBulkAddPostfix,
      onReset: onResetPostfix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_15__["default"], {
      blockId: blockId,
      obj: postfix,
      onChange: onPickCssLibraryPostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block Variations", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__["default"], {
      blockName: blockNameLast,
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockPatterns
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_17__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, archiveTitle.options.archiveType.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-center my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "border border-solid border-gray-300 w-[95%] rounded-md p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Click to pick a variation", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-gray-700 rounded-sm px-4 py-1 font-semibold text-lg text-white cursor-pointer",
      onClick: ev => {
        var content = '<!-- wp:post-grid/archive-description {"archiveTitle":{"options":{"tag":"div","archiveType":"auto","customLabel":"%s","dateFormat":"","linkTo":"","linkToUrl":"","linkToMetaKey":"","linkTarget":"_blank","linkAttr":[],"customUrl":"","class":"archiveTitle"},"styles":{"color":{"Desktop":"#000000 !important"},"fontSize":{"Desktop":"18px"},"fontFamily":{"Desktop":"Poppins"},"fontStyle":{"Desktop":"normal"},"fontWeight":{"Desktop":"400"},"position":{"Desktop":"relative"},"zIndex":{"Desktop":"9999"}},"after":{"position":{"Desktop":"absolute !important"},"content":{"Desktop":"u0022 u0022"},"height":{"Desktop":"3px"},"width":{"Desktop":"120px"},"left":{"Desktop":"0px"},"top":{"Desktop":"17px"},"backgroundColor":{"Desktop":"#05dbf2fa"},"zIndex":{"Desktop":"-1"}}},"icon":{"options":{"library":"fontAwesome","srcType":"class","iconSrc":"far fa-calendar-alt","position":"","class":"postdate-icon"},"styles":{"color":{"Desktop":"#000000 !important"},"fontSize":{"Desktop":"18px"},"margin":{"Desktop":"0px 10px 0px 0px"}}},"blockId":"pg1cb3af7b13e9","blockCssY":{"items":{".pg1cb3af7b13e9":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"400"},"position":{"Desktop":"relative"},"z-index":{"Desktop":"9999"}},".pg1cb3af7b13e9::after":{"position":{"Desktop":"absolute !important"},"content":{"Desktop":"u0022 u0022"},"height":{"Desktop":"3px"},"width":{"Desktop":"120px"},"left":{"Desktop":"0px"},"top":{"Desktop":"17px"},"background-color":{"Desktop":"#05dbf2fa"},"z-index":{"Desktop":"-1"}},".pg1cb3af7b13e9 .postdate-icon":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"margin":{"Desktop":"0px 10px 0px 0px"}},".pg1cb3af7b13e9 .prefix":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"400"},"margin":{"Desktop":"0px 10px 0px 0px"}},".pg1cb3af7b13e9 .postfix":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"400"},"margin":{"Desktop":"0px 0px 0px 10px"}}}}} /-->';
        wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Skip", "post-grid"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...blockProps,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_block_variations_picker__WEBPACK_IMPORTED_MODULE_22__["default"], {
      blockName: "archive-description",
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockVariation
    })))), archiveTitle.options.archiveType.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTag, {
      ...blockProps
    }, icon.options.position == "beforePrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: prefix.options.class
    }, prefixText), icon.options.position == "afterPrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      className: "archiveTitle",
      onClick: handleLinkClick,
      ...linkAttrItems,
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }, icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagPostTitle, {
      className: "archiveTitle"
    }, icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == "beforePostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: postfix.options.class
    }, postfixText), icon.options.position == "afterPostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      ...blockProps,
      onClick: handleLinkClick,
      ...linkAttrItems,
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }, icon.options.position == "beforePrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: prefix.options.class
    }, prefixText), icon.options.position == "afterPrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforePostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: postfix.options.class
    }, postfixText), icon.options.position == "afterPostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagPostTitle, {
      ...blockProps
    }, icon.options.position == "beforePrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: prefix.options.class
    }, prefixText), icon.options.position == "afterPrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforePostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: postfix.options.class
    }, postfixText), icon.options.position == "afterPostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }))))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/archive-title/index.js":
/*!*******************************************!*\
  !*** ./src/blocks/archive-title/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./block.json */ "./src/blocks/archive-title/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_block_variations_picker__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/block-variations-picker */ "./src/components/block-variations-picker/index.js");












const {
  RawHTML
} = wp.element;















var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_20__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M68.7781 49.5732H20.9829C19.9266 49.5732 18.9135 49.9929 18.1666 50.7398C17.4196 51.4868 17 52.4998 17 53.5562V93.3855C17 94.4418 17.4196 95.4549 18.1666 96.2018C18.9135 96.9488 19.9266 97.3684 20.9829 97.3684H68.7781C69.8344 97.3684 70.8475 96.9488 71.5945 96.2018C72.3414 95.4549 72.761 94.4418 72.761 93.3855V53.5562C72.761 52.4998 72.3414 51.4868 71.5945 50.7398C70.8475 49.9929 69.8344 49.5732 68.7781 49.5732ZM64.7952 89.4025H24.9659V57.5391H64.7952V89.4025Z",
      fill: "url(#paint0_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M152.42 61.5222H88.6934V69.4881H152.42V61.5222Z",
      fill: "url(#paint1_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M136.489 77.4539H88.6934V85.4197H136.489V77.4539Z",
      fill: "url(#paint2_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M68.7781 112.205H20.9829C19.9266 112.205 18.9135 112.624 18.1666 113.371C17.4196 114.118 17 115.131 17 116.188V156.017C17 157.073 17.4196 158.086 18.1666 158.833C18.9135 159.58 19.9266 160 20.9829 160H68.7781C69.8344 160 70.8475 159.58 71.5945 158.833C72.3414 158.086 72.761 157.073 72.761 156.017V116.188C72.761 115.131 72.3414 114.118 71.5945 113.371C70.8475 112.624 69.8344 112.205 68.7781 112.205ZM64.7952 152.034H24.9659V120.171H64.7952V152.034Z",
      fill: "url(#paint3_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M152.42 124.154H88.6934V132.12H152.42V124.154Z",
      fill: "url(#paint4_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M136.489 140.085H88.6934V148.051H136.489V140.085Z",
      fill: "url(#paint5_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M132 0H17V11H132V0Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M83 28H17V33H83V28Z",
      fill: "url(#paint6_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M103 19H17V24H103V19Z",
      fill: "url(#paint7_linear_61_454)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_454",
      x1: "17",
      y1: "73.4708",
      x2: "72.761",
      y2: "73.4708",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_454",
      x1: "88.6934",
      y1: "65.5051",
      x2: "152.42",
      y2: "65.5051",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint2_linear_61_454",
      x1: "88.6934",
      y1: "81.4368",
      x2: "136.489",
      y2: "81.4368",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint3_linear_61_454",
      x1: "17",
      y1: "136.102",
      x2: "72.761",
      y2: "136.102",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint4_linear_61_454",
      x1: "88.6934",
      y1: "128.137",
      x2: "152.42",
      y2: "128.137",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint5_linear_61_454",
      x1: "88.6934",
      y1: "144.068",
      x2: "136.489",
      y2: "144.068",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint6_linear_61_454",
      x1: "17",
      y1: "30.5",
      x2: "83",
      y2: "30.5",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint7_linear_61_454",
      x1: "17",
      y1: "21.5",
      x2: "103",
      y2: "21.5",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  transforms: {
    from: [{
      type: "block",
      blocks: ["core/search"],
      transform: attributes => {
        // var content = attributes.content;
        // var linkTarget = attributes.linkTarget;
        // 					{
        //     "label": "Search",
        //     "showLabel": true,
        //     "placeholder": "",
        //     "buttonText": "Search",
        //     "buttonPosition": "button-outside",
        //     "buttonUseIcon": false,
        //     "query": [],
        //     "buttonBehavior": "expand-searchfield",
        //     "isSearchFieldHidden": false
        // }
        // return createBlock("post-grid/read-more", {
        // 	readMore: {
        // 		options: {
        // 			text: content,
        // 			linkTarget: linkTarget,
        // 			linkTo: "postUrl",
        // 			linkAttr: [],
        // 		},
        // 	},
        // });
      }
    }],
    to: [{
      type: "block",
      blocks: ["core/read-more"],
      transform: attributes => {
        // var content = attributes.readMore;
        // return createBlock("core/read-more", {
        // 	content: content.options.text,
        // 	linkTarget: content.options.linkTarget,
        // });
      }
    }]
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    let archiveTitle = attributes.archiveTitle;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    const wrapperSelector = blockClass;
    var archiveTitleSelector = "archive";
    if (wrapper.options.tag.length != 0) {
      if (archiveTitle.options.linkTo.length > 0) {
        archiveTitleSelector = blockClass + " a";
      } else {
        // archiveTitleSelector = blockClass;
        archiveTitleSelector = blockClass + " .archiveTitle";
      }
    } else {
      archiveTitleSelector = blockClass;
    }
    const prefixSelector = blockClass + " .prefix";
    const postfixSelector = blockClass + " .postfix";
    const iconSelector = blockClass + " .icon";
    var breakPointX = myStore.getBreakPoint();
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("isProFeature", true);
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [prefixText, setprefixText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(myStore.parseCustomTags(prefix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"]));
    const [postfixText, setpostfixText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(myStore.parseCustomTags(postfix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"]));
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var text = myStore.parseCustomTags(prefix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"]);
      setprefixText(text);
    }, [prefix.options.text]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var text = myStore.parseCustomTags(postfix.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"]);
      setpostfixText(text);
    }, [postfix.options.text]);
    var archiveTypes = {
      auto: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Auto Detect", "post-grid"),
        value: "auto"
      }
      // 'author': { label: 'Author', value: 'author' },
      // 'category': { label: 'Category', value: 'category' },
      // 'tag': { label: 'Tag', value: 'tag' },
      // 'taxonomy': { label: 'Taxonomy', value: 'taxonomy' },
      // 'search': { label: 'Search', value: 'search' },
      // 'index': { label: 'Index', value: 'index' },
      // 'year': { label: 'Year', value: 'year' },
      // 'month': { label: 'Month', value: 'month' },
      // 'date': { label: 'Date', value: 'date' },
      // 'wcCatalog': { label: 'WooCommerce Catalog', value: 'wcCatalog' },
      // 'wcSearch': { label: 'WooCommerce Search', value: 'wcSearch' },
    };
    var archiveLinkToArgsBasic = {
      none: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No Link", "post-grid"),
        value: ""
      },
      archiveUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Archive URL", "post-grid"),
        value: "archiveUrl"
      },
      homeUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Home URL", "post-grid"),
        value: "homeUrl"
      },
      customUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom", "post-grid"),
        value: "customUrl"
      }
    };
    let archiveLinkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("archiveLinkToArgs", archiveLinkToArgsBasic);
    var dateFormats = {
      "Y-M-d": {
        label: "2022-May-25",
        value: "Y-M-d"
      },
      "Y-m-d": {
        label: "2022-05-25",
        value: "Y-m-d"
      },
      "d-m-y": {
        label: "25-05-2022",
        value: "d-m-y"
      },
      "d/m/y": {
        label: "25/05/2022",
        value: "d/m/y"
      },
      "y-m-d": {
        label: "2022-05-25",
        value: "y-m-d"
      },
      "y/m/d": {
        label: "2022/05/25",
        value: "y/m/d"
      },
      "D M y": {
        label: "Sun May 2022",
        value: "D M y"
      },
      "D M d, y": {
        label: "Sun May 11, 2022",
        value: "D M d, y"
      },
      "M D d, y": {
        label: "May Sun 11, 2022",
        value: "M D d, y"
      },
      "M d, y": {
        label: "May 11, 2022",
        value: "M d, y"
      },
      "d M y": {
        label: "25 May 2022",
        value: "d M y"
      }
    };
    const [archiveTitleEdited, setarchiveTitleEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("Hello %s");
    function onChangeIcon(arg) {
      var options = {
        ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: {
          ...icon,
          options: options
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[archiveTitleSelector] = archiveTitle;
      blockCssObj[iconSelector] = icon;
      blockCssObj[prefixSelector] = prefix;
      blockCssObj[postfixSelector] = postfix;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var archiveType = archiveTitle.options.archiveType;
      if (archiveType == "auto") {
        //archiveTitleEdited = archiveTitle.options.customLabel;
        setarchiveTitleEdited(archiveTitle.options.customLabel);
      }
    }, [archiveTitle]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        // var blockId = attributes.blockId
        var wrapperX = attributes.wrapper;
        var archiveTitleX = attributes.archiveTitle;
        var iconX = attributes.icon;
        var prefixX = attributes.prefix;
        var postfixX = attributes.postfix;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        if (archiveTitleX != undefined) {
          var archiveTitleY = {
            ...archiveTitleX,
            options: archiveTitle.options
          };
          setAttributes({
            archiveTitle: archiveTitleY
          });
          blockCssObj[archiveTitleSelector] = archiveTitleY;
        }
        if (iconX != undefined) {
          var iconY = {
            ...iconX,
            options: icon.options
          };
          setAttributes({
            icon: iconY
          });
          blockCssObj[iconSelector] = iconY;
        }
        if (prefixX != undefined) {
          var prefixY = {
            ...prefixX,
            options: prefix.options
          };
          setAttributes({
            prefix: prefixY
          });
          blockCssObj[prefixSelector] = prefixY;
        }
        if (postfixX != undefined) {
          var postfixY = {
            ...postfixX,
            options: postfix.options
          };
          setAttributes({
            postfix: postfixY
          });
          blockCssObj[postfixSelector] = postfixY;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function setFieldLinkTo(option, index) {
      var options = {
        ...archiveTitle.options,
        linkTo: option.value
      };
      setAttributes({
        archiveTitle: {
          ...archiveTitle,
          options: options
        }
      });
    }
    function onPickCssLibraryWrapper(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        wrapper[sudoScource] = sudoScourceArgs;
      });
      var wrapperX = Object.assign({}, wrapper);
      setAttributes({
        wrapper: wrapperX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryArchiveTitle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        archiveTitle[sudoScource] = sudoScourceArgs;
      });
      var archiveTitleX = Object.assign({}, archiveTitle);
      setAttributes({
        archiveTitle: archiveTitleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryPrefix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        prefix[sudoScource] = sudoScourceArgs;
      });
      var prefixX = Object.assign({}, prefix);
      setAttributes({
        prefix: prefixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryPostfix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        postfix[sudoScource] = sudoScourceArgs;
      });
      var postfixX = Object.assign({}, postfix);
      setAttributes({
        postfix: postfixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleArchiveTitle(sudoScource, key) {
      let obj = {
        ...archiveTitle
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        archiveTitle: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIcon(sudoScource, key) {
      let obj = {
        ...icon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        icon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStylePrefix(sudoScource, key) {
      let obj = {
        ...prefix
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        prefix: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStylePostfix(sudoScource, key) {
      let obj = {
        ...postfix
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        postfix: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onResetArchiveTitle(sudoSources) {
      let obj = Object.assign({}, archiveTitle);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        archiveTitle: obj
      });
    }
    function onResetIcon(sudoSources) {
      let obj = Object.assign({}, icon);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        icon: obj
      });
    }
    function onResetPrefix(sudoSources) {
      let obj = Object.assign({}, prefix);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        prefix: obj
      });
    }
    function onResetPostfix(sudoSources) {
      let obj = Object.assign({}, postfix);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        postfix: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onChangeStyleArchiveTitle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleArchiveTitle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        archiveTitle: object
      });
    }
    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        icon: object
      });
    }
    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStylePrefix(sudoScource, key) {
      var sudoScourceX = {
        ...prefix[sudoScource]
      };
      sudoScourceX[key] = {};
      prefix[sudoScource] = sudoScourceX;
      setAttributes({
        prefix: {
          ...prefix
        }
      });
    }
    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        postfix: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddArchiveTitle(sudoScource, cssObj) {
      let obj = Object.assign({}, archiveTitle);
      obj[sudoScource] = cssObj;
      setAttributes({
        archiveTitle: obj
      });
      var selector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddPrefix(sudoScource, cssObj) {
      let obj = Object.assign({}, prefix);
      obj[sudoScource] = cssObj;
      setAttributes({
        prefix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, prefixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddPostfix(sudoScource, cssObj) {
      let obj = Object.assign({}, postfix);
      obj[sudoScource] = cssObj;
      setAttributes({
        postfix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, postfixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    String.prototype.strtr = function (dic) {
      const str = this.toString(),
        makeToken = inx => `{{###~${inx}~###}}`,
        tokens = Object.keys(dic).map((key, inx) => ({
          key,
          val: dic[key],
          token: makeToken(inx)
        })),
        tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);
      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "link", postId);
    // Wrapper CSS Class Selectors
    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }
    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({}); // Using the hook.
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      linkAttrObj();
    }, [archiveTitle]);
    var linkAttrObj = () => {
      var sdsd = {};
      archiveTitle.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };
    var postUrl = archiveTitle.options.customUrl != undefined && archiveTitle.options.customUrl.length > 0 ? archiveTitle.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${archiveTitle.options.tag}`;
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class}`
    });
    function onPickBlockVariation(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
    }
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_14__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_12__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_17__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Archive Title", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_14__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Archive Type", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveTypes
      // buttonTitle="Choose"
      ,
      buttonTitle: archiveTypes[archiveTitle.options.archiveType] != undefined ? archiveTypes[archiveTitle.options.archiveType].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
      onChange: (option, index) => {
        var options = {
          ...archiveTitle.options,
          archiveType: option.value
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      },
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Label", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.customLabel,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          customLabel: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), (archiveTitle.options.archiveType == "year" || archiveTitle.options.archiveType == "month" || archiveTitle.options.archiveType == "day") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Date Format", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: dateFormats,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = {
          ...archiveTitle.options,
          dateFormat: option.value
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      },
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Format", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.dateFormat,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          dateFormat: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), dateFormats[archiveTitle.options.dateFormat] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2 my-3 bg-gray-500 text-white"
    }, dateFormats[archiveTitle.options.dateFormat].label)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link To", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveLinkToArgs,
      buttonTitle: archiveTitle.options.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid") : archiveLinkToArgs[archiveTitle.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), archiveTitle.options.linkTo == "customUrl" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom URL", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : "",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), archiveTitle.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = {
          ...archiveTitle.options,
          customUrl: ""
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.__experimentalLinkControl, {
      settings: [],
      value: archiveTitle.options.customUrl,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          customUrl: newVal.url
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", archiveTitle.options.customUrl.length != 0 ? archiveTitle.options.customUrl : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No link", "post-grid"), " ")))), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: archiveTitle.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          tag: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link Target", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: archiveTitle.options.linkTarget,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose...", "post-grid"),
        value: ""
      }, {
        label: "_self",
        value: "_self"
      }, {
        label: "_blank",
        value: "_blank"
      }, {
        label: "_parent",
        value: "_parent"
      }, {
        label: "_top",
        value: "_top"
      }],
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          linkTarget: newVal
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Attributes", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      // className=" cursor-pointer px-3 text-white py-1 bg-gray-700 hover:bg-gray-600"
      className: "flex gap-2 justify-center my-2 cursor-pointer py-2 px-4 capitalize tracking-wide bg-gray-700 text-white font-medium rounded hover:!bg-gray-700 hover:text-white  focus:outline-none focus:bg-gray-700",
      onClick: ev => {
        var sdsd = archiveTitle.options.linkAttr.concat({
          id: "",
          val: ""
        });
        var options = {
          ...archiveTitle.options,
          linkAttr: sdsd
        };
        setAttributes({
          archiveTitle: {
            ...archiveTitle,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), archiveTitle.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "my-2",
        key: i
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Name",
        value: archiveTitle.options.linkAttr[i].id,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].id = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = {
            ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: {
              ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].val = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = {
            ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: {
              ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        // className="text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close"
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          archiveTitle.options.linkAttr.splice(i, 1);
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = {
            ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: {
              ...archiveTitle,
              options: options
            }
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"]
      }))));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_12__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: archiveTitle.options.class,
      onChange: newVal => {
        var options = {
          ...archiveTitle.options,
          class: newVal
        };
        setAttributes({
          archiveTitle: {
            styles: archiveTitle.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
      obj: archiveTitle,
      onChange: onChangeStyleArchiveTitle,
      onAdd: onAddStyleArchiveTitle,
      onRemove: onRemoveStyleArchiveTitle,
      onBulkAdd: onBulkAddArchiveTitle,
      onReset: onResetArchiveTitle
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_17__["default"], {
      blockId: blockId,
      obj: archiveTitle,
      onChange: onPickCssLibraryArchiveTitle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 "
      // title= {__("Icon","post-grid")}
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_14__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_11__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Archive Title", "post-grid"),
        value: "beforeArchiveTitle"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Archive Title", "post-grid"),
        value: "afterArchiveTitle"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Prefix", "post-grid"),
        value: "beforePrefix"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Prefix", "post-grid"),
        value: "afterPrefix"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Postfix", "post-grid"),
        value: "beforePostfix"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Postfix", "post-grid"),
        value: "afterPostfix"
      }],
      onChange: newVal => {
        var options = {
          ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon,
      onReset: onResetIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_17__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 "
      // title="Prefix"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Prefix", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_14__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_12__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"],
      label: "Prefix",
      placeholder: "Add Prefix",
      value: prefix.options.text,
      onChange: newVal => {
        var options = {
          ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
      obj: prefix,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix,
      onBulkAdd: onBulkAddPrefix,
      onReset: onResetPrefix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_17__["default"], {
      blockId: blockId,
      obj: prefix,
      onChange: onPickCssLibraryPrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 "
      // title="Postfix"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Postfix", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_14__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_12__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_13__["default"],
      label: "Postfix",
      placeholder: "Add Postfix",
      value: postfix.options.text,
      onChange: newVal => {
        var options = {
          ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: {
            styles: postfix.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
      obj: postfix,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix,
      onBulkAdd: onBulkAddPostfix,
      onReset: onResetPostfix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_15__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_17__["default"], {
      blockId: blockId,
      obj: postfix,
      onChange: onPickCssLibraryPostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block Variations", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_library_block_variations__WEBPACK_IMPORTED_MODULE_21__["default"], {
      blockName: blockNameLast,
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockPatterns
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_18__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_19__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, archiveTitle.options.archiveType.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-center my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "border border-solid border-gray-300 w-[95%] rounded-md p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Click to pick a variation", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-gray-700 rounded-sm px-4 py-1 font-semibold text-lg text-white cursor-pointer",
      onClick: ev => {
        var content = '<!-- wp:post-grid/archive-title {"wrapper":{"options":{"tag":"div","class":"pg-archive-title"},"styles":{"display":{"Desktop":"block"},"padding":{"Desktop":"0px 0px 0px 110px"}}},"archiveTitle":{"options":{"tag":"div","archiveType":"auto","customLabel":"Archive: %s","dateFormat":"","linkTo":"","linkToUrl":"","linkToMetaKey":"","linkTarget":"_blank","linkAttr":[],"customUrl":"","class":"archiveTitle"},"styles":{"color":{"Desktop":"#000000 !important"},"fontSize":{"Desktop":"30px"},"fontFamily":{"Desktop":"Poppins"},"fontStyle":{"Desktop":"normal"},"fontWeight":{"Desktop":"700"},"lineHeight":{"Desktop":"155%"},"position":{"Desktop":"relative"}},"after":{"position":{"Desktop":"absolute !important"},"content":{"Desktop":"\u0022 \u0022"},"height":{"Desktop":"3px"},"width":{"Desktop":"100px"},"left":{"Desktop":"-110px"},"top":{"Desktop":"25px"},"backgroundColor":{"Desktop":"#000000"}}},"icon":{"options":{"library":"fontAwesome","srcType":"class","iconSrc":"far fa-calendar-alt","position":"","class":"postdate-icon"},"styles":{"color":{"Desktop":"#000000 !important"},"fontSize":{"Desktop":"18px"},"margin":{"Desktop":"0px 10px 0px 0px"}}},"blockId":"pg191eb4e9541e","blockCssY":{"items":{".pg191eb4e9541e":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"30px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"700"},"line-height":{"Desktop":"155%"},"position":{"Desktop":"relative"}},".pg191eb4e9541e::after":{"position":{"Desktop":"absolute !important"},"content":{"Desktop":"\u0022 \u0022"},"height":{"Desktop":"3px"},"width":{"Desktop":"100px"},"left":{"Desktop":"-110px"},"top":{"Desktop":"25px"},"background-color":{"Desktop":"#000000"}},".pg191eb4e9541e .icon":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"margin":{"Desktop":"0px 10px 0px 0px"}},".pg191eb4e9541e .prefix":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"400"},"margin":{"Desktop":"0px 10px 0px 0px"}},".pg191eb4e9541e .postfix":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"400"},"margin":{"Desktop":"0px 0px 0px 10px"}}}}} /-->';
        wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Skip", "post-grid"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...blockProps,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_block_variations_picker__WEBPACK_IMPORTED_MODULE_22__["default"], {
      blockName: "archive-title",
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockVariation
    }))))), archiveTitle.options.archiveType.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTag, {
      ...blockProps
    }, icon.options.position == "beforePrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: prefix.options.class
    }, prefixText), icon.options.position == "afterPrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      className: "archiveTitle",
      onClick: handleLinkClick,
      ...linkAttrItems,
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }, icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagPostTitle, {
      className: "archiveTitle"
    }, icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == "beforePostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: postfix.options.class
    }, postfixText), icon.options.position == "afterPostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      ...blockProps,
      onClick: handleLinkClick,
      ...linkAttrItems,
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }, icon.options.position == "beforePrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: prefix.options.class
    }, prefixText), icon.options.position == "afterPrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforePostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: postfix.options.class
    }, postfixText), icon.options.position == "afterPostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagPostTitle, {
      ...blockProps
    }, icon.options.position == "beforePrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: prefix.options.class
    }, prefixText), icon.options.position == "afterPrefix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforeArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == "afterArchiveTitle" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == "beforePostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: postfix.options.class
    }, postfixText), icon.options.position == "afterPostfix" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }))))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/audio-player/index.js":
/*!******************************************!*\
  !*** ./src/blocks/audio-player/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./block.json */ "./src/blocks/audio-player/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_form_field_conditions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/form-field-conditions */ "./src/components/form-field-conditions/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_typing_text__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/typing-text */ "./src/components/typing-text/index.js");














const {
  RawHTML
} = wp.element;














var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_18__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M157.275 48.4749L82.63 5.675C81.0376 4.775 78.9477 4.775 77.3552 5.675L2.70979 48.4749C0.122083 49.9749 -0.773663 53.175 0.719246 55.775C1.21688 56.675 1.91343 57.375 2.80917 57.875L77.4546 98.075C79.0471 98.875 80.9382 98.875 82.5306 98.075L157.176 57.875C159.764 56.475 160.759 53.275 159.366 50.675C158.868 49.775 158.072 48.9749 157.275 48.4749ZM79.9428 87.275L16.345 53.075L79.9428 16.575L143.541 53.075L79.9428 87.275Z",
      fill: "url(#paint0_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M82.5306 126.175L154.588 86.3748V74.1748L79.9428 115.375L5.29736 74.1748V86.3748L77.3553 126.175C79.0472 127.075 80.9382 127.075 82.5306 126.175Z",
      fill: "url(#paint1_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M5.29736 115.675L77.4546 154.275C79.0471 155.075 80.9381 155.075 82.431 154.275L154.588 115.675V103.575L79.9428 143.575L5.29736 103.575V115.675Z",
      fill: "url(#paint2_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_513",
      x1: "-0.00341797",
      y1: "51.8375",
      x2: "159.997",
      y2: "51.8375",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_513",
      x1: "5.29736",
      y1: "100.512",
      x2: "154.588",
      y2: "100.512",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint2_linear_61_513",
      x1: "5.29736",
      y1: "129.225",
      x2: "154.588",
      y2: "129.225",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var audio = attributes.audio;
    var triggersPlay = attributes.triggersPlay;
    var triggersPause = attributes.triggersPause;
    var triggersStop = attributes.triggersStop;
    var visible = attributes.visible;
    var conditions = attributes.conditions;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    var breakPointX = myStore.getBreakPoint();
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "link", postId);
    var [postGridBlockEditor, setpostGridBlockEditor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({}); // Using the hook.
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      setpostGridBlockEditor(window.postGridBlockEditor);
    }, [window.postGridBlockEditor]);

    // Wrapper CSS Class Selectors
    var wrapperSelector = blockClass;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        var wrapperX = attributes.wrapper;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function onPickCssLibraryLayers(args) {
      var textX = Object.assign({}, wrapper);
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        textX[sudoScource] = sudoScourceArgs;
      });
      setAttributes({
        wrapper: textX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var blockCssYX = {
        ...blockCssY
      };
      var items = {
        ...blockCssYX.items
      };
      var cssItems = Object.assign(items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class}`
    });
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps)(blockProps, {
      directInsert: true,
      templateInsertUpdatesSelection: true,
      renderAppender: _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.ButtonBlockAppender
    });
    var playTriggersList = {
      playOnLoad: {
        label: "Play On Load",
        args: {
          id: "playOnLoad",
          value: false
        }
      },
      playNScrollPercent: {
        label: "Play n scroll %",
        args: {
          id: "playNScrollPercent",
          value: ""
        }
      },
      playOnScrollElement: {
        label: "Play on scroll element",
        args: {
          id: "playOnScrollElement",
          value: ""
        }
      },
      playOnScrollEnd: {
        label: "Play on scroll end",
        args: {
          id: "playOnScrollEnd",
          value: false
        }
      },
      playOnMouseOver: {
        label: "Play Mouse over element",
        args: {
          id: "playOnMouseOver",
          value: false
        }
      },
      playOnMouseOut: {
        label: "Play mouse out element",
        args: {
          id: "playOnMouseOut",
          value: false
        }
      },
      playOnExit: {
        label: "Play on exit",
        args: {
          id: "playOnExit",
          value: false
        }
      }
    };
    var pauseTriggersList = {
      playNScrollPercent: {
        label: "Play n scroll %",
        args: {
          id: "playNScrollPercent",
          value: ""
        }
      },
      playOnScrollElement: {
        label: "Play on scroll element",
        args: {
          id: "playOnScrollElement",
          value: ""
        }
      },
      playOnScrollEnd: {
        label: "Play on scroll end",
        args: {
          id: "playOnScrollEnd",
          value: false
        }
      },
      playOnMouseOver: {
        label: "Play Mouse over element",
        args: {
          id: "playOnMouseOver",
          value: false
        }
      },
      playOnMouseOut: {
        label: "Play mouse out element",
        args: {
          id: "playOnMouseOut",
          value: false
        }
      },
      playOnExit: {
        label: "Play on exit",
        args: {
          id: "playOnExit",
          value: false
        }
      }
    };
    var RemoveSubmitTriggers = function ({
      title,
      index
    }) {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "cursor-pointer hover:bg-red-500 hover:text-white ",
        onClick: ev => {
          var triggersPlayX = {
            ...triggersPlay
          };
          delete triggersPlayX[index];
          setAttributes({
            triggersPlay: triggersPlayX
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, title));
    };
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_22__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.id,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          id: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "a",
        value: "a"
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryLayers
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Audio", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: "Controls?",
      help: audio.options.controls ? "Controls Enable" : "Controls disable",
      checked: audio.options.controls ? true : false,
      onChange: e => {
        var options = {
          ...audio.options,
          controls: audio.options.controls ? false : true
        };
        setAttributes({
          audio: {
            ...audio,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: "Autoplay?",
      help: audio.options.autoplay ? "Autoplay Enable" : "Autoplay disable",
      checked: audio.options.autoplay ? true : false,
      onChange: e => {
        var options = {
          ...audio.options,
          autoplay: audio.options.autoplay ? false : true
        };
        setAttributes({
          audio: {
            ...audio,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: "Muted?",
      help: audio.options.muted ? "Muted Enable" : "Muted disable",
      checked: audio.options.muted ? true : false,
      onChange: e => {
        var options = {
          ...audio.options,
          muted: audio.options.muted ? false : true
        };
        setAttributes({
          audio: {
            ...audio,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: "Loop?",
      help: audio.options.loop ? "Loop Enable" : "Loop disable",
      checked: audio.options.loop ? true : false,
      onChange: e => {
        var options = {
          ...audio.options,
          loop: audio.options.loop ? false : true
        };
        setAttributes({
          audio: {
            ...audio,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: ""
    }, "Audio Source"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("button", {
      className: "pg-font flex gap-2 justify-center my-2 cursor-pointer py-2 px-4 capitalize  bg-gray-700\t text-white font-medium rounded hover:bg-gray-600\t hover:text-white focus:outline-none focus:bg-gray-600\t",
      onClick: () => {
        var sourcesX = audio.options.sources;
        sourcesX.push({
          src: "",
          type: ""
        });
        var optionX = {
          ...audio.options,
          sources: sourcesX
        };
        setAttributes({
          audio: {
            ...audio,
            options: optionX
          }
        });
      }
    }, "Add")), audio.options.sources.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", null, audio.options.sources.map((x, i) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: `Source ${i + 1}`,
      initialOpen: false,
      key: i
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: ""
    }, "src"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      type: "text",
      value: x.src,
      onChange: newVal => {
        var sourcesX = [...audio.options.sources];
        sourcesX[i].src = newVal;
        var optionX = {
          ...audio.options,
          sources: sourcesX
        };
        setAttributes({
          audio: {
            ...audio,
            options: optionX
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: ""
    }, "type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: x.type,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("OGG", "post-grid"),
        value: "audio/ogg"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("MP3", "post-grid"),
        value: "audio/mpeg"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("WAV", "post-grid"),
        value: "audio/wav"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("AAC", "post-grid"),
        value: "audio/aac"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("MP4", "post-grid"),
        value: "audio/mp4"
      }],
      onChange: newVal => {
        var sourcesX = [...audio.options.sources];
        sourcesX[i].type = newVal;
        var optionX = {
          ...audio.options,
          sources: sourcesX
        };
        setAttributes({
          audio: {
            ...audio,
            options: optionX
          }
        });
      }
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Play Triggers", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: ""
    }, "Add Triggers"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: "Choose",
      options: playTriggersList,
      onChange: (option, index) => {
        var triggersPlayX = {
          ...triggersPlay
        };
        var index = Object.entries(triggersPlayX).length;
        triggersPlayX[index] = option.args;
        setAttributes({
          triggersPlay: triggersPlayX
        });
        // var rulesX = [...triggersPlay.rules];
        // rulesX.push({ id: option.id, value: option.value });
        // setAttributes({ triggersPlay: { rules: rulesX } });
      },
      values: ""
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "my-4"
    }, Object.entries(triggersPlay).map((group, i) => {
      var groupIndex = group[0];
      var groupData = group[1];
      var id = groupData.id;
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
        key: i,
        title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveSubmitTriggers, {
          title: playTriggersList[id] == undefined ? id : playTriggersList[id].label,
          index: groupIndex
        }),
        initialOpen: false
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, id == "playNScrollPercent" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "mb-4"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
        for: "",
        className: "font-medium text-slate-900 "
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Scroll Percent", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
        value: groupData.value,
        onChange: newVal => {
          var triggersPlayX = {
            ...triggersPlay
          };
          triggersPlayX[groupIndex]["value"] = newVal;
          setAttributes({
            triggersPlay: triggersPlayX
          });
        }
      }))), (id == "playOnLoad" || id == "playOnScrollEnd" || id == "playOnMouseOver" || id == "playOnMouseOut" || id == "playOnExit") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "No options for this condition"), id == "playOnScrollElement" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "mb-4"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
        for: "",
        className: "font-medium text-slate-900 "
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Element #ID or .Class", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
        value: groupData.value,
        onChange: newVal => {
          var triggersPlayX = {
            ...triggersPlay
          };
          triggersPlayX[groupIndex]["value"] = newVal;
          setAttributes({
            triggersPlay: triggersPlayX
          });
        }
      })))));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pause Triggers", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: ""
    }, "Add Triggers"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: "Choose",
      options: pauseTriggersList,
      onChange: (option, index) => {
        var triggersPauseX = {
          ...triggersPause
        };
        var index = Object.entries(triggersPauseX).length;
        triggersPauseX[index] = option.args;
        setAttributes({
          triggersPause: triggersPauseX
        });
      },
      values: ""
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "my-4"
    }, Object.entries(triggersPause).map((group, i) => {
      var groupIndex = group[0];
      var groupData = group[1];
      var id = groupData.id;
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
        key: i,
        title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveSubmitTriggers, {
          title: playTriggersList[id] == undefined ? id : playTriggersList[id].label,
          index: groupIndex
        }),
        initialOpen: false
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, id == "playNScrollPercent" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "mb-4"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
        for: "",
        className: "font-medium text-slate-900 "
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Scroll Percent", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
        value: groupData.value,
        onChange: newVal => {
          var triggersPauseX = {
            ...triggersPause
          };
          triggersPauseX[groupIndex]["value"] = newVal;
          setAttributes({
            triggersPause: triggersPauseX
          });
        }
      }))), (id == "playOnScrollEnd" || id == "playOnMouseOver" || id == "playOnMouseOut" || id == "playOnExit") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "No options for this condition"), id == "playOnScrollElement" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "mb-4"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
        for: "",
        className: "font-medium text-slate-900 "
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Element #ID or .Class", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
        value: groupData.value,
        onChange: newVal => {
          var triggersPauseX = {
            ...triggersPause
          };
          triggersPauseX[groupIndex]["value"] = newVal;
          setAttributes({
            triggersPause: triggersPauseX
          });
        }
      })))));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Stop Triggers", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: ""
    }, "Add Triggers"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: "Choose",
      options: pauseTriggersList,
      onChange: (option, index) => {
        var triggersStopX = {
          ...triggersStop
        };
        var index = Object.entries(triggersStopX).length;
        triggersStopX[index] = option.args;
        setAttributes({
          triggersStop: triggersStopX
        });
      },
      values: ""
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "my-4"
    }, Object.entries(triggersStop).map((group, i) => {
      var groupIndex = group[0];
      var groupData = group[1];
      var id = groupData.id;
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
        key: i,
        title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(RemoveSubmitTriggers, {
          title: playTriggersList[id] == undefined ? id : playTriggersList[id].label,
          index: groupIndex
        }),
        initialOpen: false
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, id == "playNScrollPercent" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "mb-4"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
        for: "",
        className: "font-medium text-slate-900 "
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Scroll Percent", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
        value: groupData.value,
        onChange: newVal => {
          var triggersStopX = {
            ...triggersStop
          };
          triggersStopX[groupIndex]["value"] = newVal;
          setAttributes({
            triggersStop: triggersStopX
          });
        }
      }))), (id == "playOnScrollEnd" || id == "playOnMouseOver" || id == "playOnMouseOut" || id == "playOnExit") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "No options for this condition"), id == "playOnScrollElement" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "mb-4"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
        for: "",
        className: "font-medium text-slate-900 "
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Element #ID or .Class", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
        value: groupData.value,
        onChange: newVal => {
          var triggersStopX = {
            ...triggersStop
          };
          triggersStopX[groupIndex]["value"] = newVal;
          setAttributes({
            triggersStop: triggersStopX
          });
        }
      })))));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Conditions", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_form_field_conditions__WEBPACK_IMPORTED_MODULE_20__["default"], {
      visible: conditions,
      onChange: prams => {
        setAttributes({
          conditions: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_14__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, wrapper.options.tag == "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      ...innerBlocksProps,
      onClick: handleLinkClick,
      href: postUrl,
      target: wrapper.options.linkTarget
    }, innerBlocksProps.children), wrapper.options.tag != "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagWrapper, {
      ...innerBlocksProps
    }, innerBlocksProps.children)));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.Content, null);
    //return null;
  }
});

/***/ }),

/***/ "./src/blocks/back-to-top/index.js":
/*!*****************************************!*\
  !*** ./src/blocks/back-to-top/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./block.json */ "./src/blocks/back-to-top/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _placeholder_jpg__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../placeholder.jpg */ "./src/placeholder.jpg");
/* harmony import */ var _components_block_variations_picker__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../components/block-variations-picker */ "./src/components/block-variations-picker/index.js");














const {
  RawHTML
} = wp.element;

















var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_19__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("g", {
      clipPath: "url(#clip0_165_99)"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("circle", {
      cx: "80",
      cy: "80",
      r: "80",
      fill: "url(#paint0_linear_165_99)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M40.1083 107.055L79.9188 73.6678L119.881 107.2C119.881 102.694 119.921 98.1878 120 93.6817C120 94.681 119.903 90.175 120 86.4138L79.9188 52.8L40 86.323C40.0758 93.2366 40.0975 100.096 40.1083 107.055Z",
      fill: "white"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_165_99",
      x1: "0",
      y1: "80",
      x2: "160",
      y2: "80",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("clipPath", {
      id: "clip0_165_99"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("rect", {
      width: "160",
      height: "160",
      fill: "white"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var text = attributes.text;
    var icon = attributes.icon;
    var image = attributes.image;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("isProFeature", true);
    const [isVisible, setIsVisible] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    var breakPointX = myStore.getBreakPoint();
    var [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    var [editMode, seteditMode] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    var [editModeStyles, seteditModeStyles] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
    var [styles, setstyles] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(wrapper.styles);
    const [currentPostContent, setCurrentpostContent] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "content", postId);
    const [customFields, setCustomFields] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({});
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "link", postId);
    const ALLOWED_MEDIA_TYPES = ["image"];
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    const textEnable = text.options.enable == undefined ? true : text.options.enable;
    const imageEnable = image.options.enable == undefined ? true : image.options.enable;
    // Wrapper CSS Class Selectors
    const wrapperSelector = blockClass;
    const textSelector = blockClass + " .back-to-top-text";
    const iconSelector = blockClass + " .back-to-top-icon";
    const imgSelector = blockClass + " .back-to-top-image";
    const [preview, setPreview] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(true);
    const [customText, setCustomText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(myStore.parseCustomTags(text.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_22__["default"]));
    const [currentPostImageId, setCurrentPostImageId] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(image.options.srcId);
    const [linkPickerSrcUrl, setlinkPickerSrcUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (editMode) {
        var styleObj = {
          position: {
            Desktop: "relative"
          }
        };
        var newStyle = {
          ...wrapper.styles,
          ...styleObj
        };
        seteditModeStyles(newStyle);
      } else {
        var styleObj = {
          position: {
            Desktop: "fixed !important"
          }
        };
        var newStyle = {
          ...wrapper.styles,
          ...styleObj
        };
        seteditModeStyles(newStyle);
      }
    }, [wrapper.styles]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var textX = myStore.parseCustomTags(text.options.text, _custom_tags__WEBPACK_IMPORTED_MODULE_22__["default"]);
      setCustomText(textX);
    }, [text.options.text]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[textSelector] = text;
      blockCssObj[iconSelector] = icon;
      blockCssObj[imgSelector] = image;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    function getMetaField(metaKey) {
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default()({
        path: "/post-grid/v2/get_post_meta",
        method: "POST",
        data: {
          postId: postId,
          meta_key: metaKey
        }
      }).then(res => {
        if (res["meta_value"] != undefined && res["meta_value"].length > 0) {
          customFields[metaKey] = res["meta_value"];
          setCustomFields({});
          setCustomFields(customFields);
        }
      });
    }
    const [imageSizes, setImageSizes] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
    const [postImage, setPostImage] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (currentPostImageId.length != 0 && image.options.imgSrcType == "media") {
        // setLoading(true);
        _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default()({
          path: "/wp/v2/media/" + currentPostImageId,
          method: "POST",
          data: {
            id: currentPostImageId
          }
        }).then(res => {
          setPostImage(res);
          var options = {
            ...image.options,
            srcUrl: res.source_url,
            srcId: res.id
          };
          setAttributes({
            image: {
              ...image,
              options: options
            }
          });
          // setLoading(false);
          var imgSizes = [];
          Object.keys(res.media_details.sizes).map(x => {
            var height = res.media_details.sizes[x].height;
            var width = res.media_details.sizes[x].width;
            //var crop = res[x].crop
            var label = x.replaceAll("_", " ");
            imgSizes[x] = {
              label: label + "(" + width + "*" + height + ")",
              value: x,
              height: height,
              width: width
            };
          });
          setImageSizes(imgSizes);
        });
      }
    }, [currentPostImageId]);
    var iconLinkToBasic = {
      postUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Post URL", "post-grid"),
        value: "postUrl"
      },
      homeUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Home URL", "post-grid"),
        value: "homeUrl"
      },
      authorUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author URL", "post-grid"),
        value: "authorUrl"
      },
      authorLink: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Link", "post-grid"),
        value: "authorLink"
      },
      authorMail: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Mail", "post-grid"),
        value: "authorMail",
        isPro: true
      },
      authorMeta: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Meta", "post-grid"),
        value: "authorMeta",
        isPro: true
      },
      customField: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Field", "post-grid"),
        value: "customField",
        isPro: true
      },
      customUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom URL", "post-grid"),
        value: "customUrl",
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("postGridIconLinkTo", iconLinkToBasic);
    var iconTextSourceBasic = {
      siteTitle: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Site Title", "post-grid"),
        value: "siteTitle"
      },
      tagline: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Tag line", "post-grid"),
        value: "tagline"
      },
      siteUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Site URL", "post-grid"),
        value: "siteUrl"
      },
      currentYear: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Current Year", "post-grid"),
        value: "currentYear"
      },
      currentDate: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Current Date", "post-grid"),
        value: "currentDate",
        isPro: true
      },
      postTitle: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Post title", "post-grid"),
        value: "postTitle",
        isPro: true
      }
    };
    var textSrcArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("postGridIconTextSource", iconTextSourceBasic);
    const [linkPickerExcerpt, setLinkPickerExcerpt] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [linkPickerText, setLinkPickerText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        var wrapperX = attributes.wrapper;
        var textX = attributes.text;
        var iconX = attributes.icon;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (iconX != undefined) {
          var iconY = {
            ...iconX,
            options: icon.options
          };
          setAttributes({
            icon: iconY
          });
          blockCssObj[iconSelector] = iconY;
        }
        if (textX != undefined) {
          var textY = {
            ...textX,
            options: text.options
          };
          setAttributes({
            text: textY
          });
          blockCssObj[textSelector] = textY;
        }
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }
    function setTextSrc(option, index) {
      var options = {
        ...text.options,
        src: option.value
      };
      setAttributes({
        text: {
          ...text,
          options: options
        }
      });
    }
    function setFieldLinkTo(option, index) {
      var options = {
        ...text.options,
        linkTo: option.value
      };
      setAttributes({
        text: {
          ...text,
          options: options
        }
      });
    }
    function onChangeIcon(arg) {
      var options = {
        ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: {
          ...icon,
          options: options
        }
      });
    }
    function onPickCssLibraryWrapper(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        wrapper[sudoScource] = sudoScourceArgs;
      });
      var wrapperX = Object.assign({}, wrapper);
      setAttributes({
        wrapper: wrapperX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryText(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        text[sudoScource] = sudoScourceArgs;
      });
      var textX = Object.assign({}, text);
      setAttributes({
        text: textX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleText(sudoScource, key) {
      let obj = {
        ...text
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        text: objectX
      });
      var blockCssX = {
        ...blockCssY
      };
      var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssX.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIcon(sudoScource, key) {
      let obj = {
        ...icon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        icon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onResetText(sudoSources) {
      let obj = Object.assign({}, text);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        text: obj
      });
    }
    function onResetIcon(sudoSources) {
      let obj = Object.assign({}, icon);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        icon: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onChangeStyleText(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, text);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        text: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleText(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, text);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        text: object
      });
    }
    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        icon: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddText(sudoScource, cssObj) {
      let obj = Object.assign({}, text);
      obj[sudoScource] = cssObj;
      setAttributes({
        text: obj
      });
      var selector = myStore.getElementSelector(sudoScource, textSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleImage(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, image);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        image: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleImage(sudoScource, key) {
      let obj = {
        ...image
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        image: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onAddStyleImage(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, image);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        image: object
      });
    }
    function onBulkAddImage(sudoScource, cssObj) {
      let obj = Object.assign({}, image);
      obj[sudoScource] = cssObj;
      setAttributes({
        image: obj
      });
      var selector = myStore.getElementSelector(sudoScource, imgSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onResetImage(sudoScources) {
      let obj = Object.assign({}, image);
      Object.entries(sudoScources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        image: obj
      });
    }
    function onPickCssLibraryImage(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        image[sudoScource] = sudoScourceArgs;
      });
      var imageX = Object.assign({}, image);
      setAttributes({
        image: imageX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    var [linkAttrItemsText, setlinkAttrItemsText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({}); // Using the hook.
    var [wrapAttrItems, setwrapAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({}); // Using the hook.
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var sdsd = {};
      text.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItemsText(sdsd);
    }, [text]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var sdsd = {};
      if (wrapper.options.attr != undefined) {
        wrapper.options.attr.map(x => {
          if (x.val) sdsd[x.id] = x.val;
        });
      }
      setwrapAttrItems(sdsd);
    }, [wrapper]);
    var postUrl = text.options.customUrl != undefined && text.options.customUrl.length > 0 ? text.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class} `
    });
    const blockPropsXYZ = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: `text-center inline-block mx-auto `
    });
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (editMode) {
        var styleObj = {
          position: {
            Desktop: "relative"
          }
        };
        var newStyle = {
          ...wrapper.styles,
          ...styleObj
        };
        onBulkAddWrapper("styles", newStyle);
      } else {
        if (editModeStyles != null) {
          var styleObj = {
            position: {
              Desktop: "fixed !important"
            }
          };
          var newStyle = {
            ...wrapper.styles,
            ...styleObj
          };
          onBulkAddWrapper("styles", newStyle);
        }
      }
    }, [editMode]);
    function onPickBlockVariation(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
    }
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Edit Mode?", "post-grid"),
      help: editMode ? "Edit Mode Disabled." : "Edit Mode Enabled.",
      checked: editMode,
      onChange: e => {
        seteditMode(!editMode);
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_17__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_13__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_22__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }, {
        label: "BUTTON",
        value: "button"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Offset Top", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.offsetTop,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          offsetTop: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Show After", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.showAfter,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          showAfter: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Attributes", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      // className=" cursor-pointer px-3 text-white py-1 bg-gray-700 hover:bg-gray-600"
      className: "flex gap-2 justify-center my-2 cursor-pointer py-2 px-4 capitalize tracking-wide bg-gray-700 text-white font-medium rounded hover:!bg-gray-700 hover:text-white  focus:outline-none focus:bg-gray-700",
      onClick: ev => {
        if (wrapper.options.attr == undefined) {
          wrapper.options.attr = {};
        }
        var sdsd = wrapper.options.attr.concat({
          id: "",
          val: ""
        });
        var options = {
          ...wrapper.options,
          attr: sdsd
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Add", "post-grid"))), wrapper.options.attr != undefined && wrapper.options.attr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
        className: "my-2",
        key: i
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        placeholder: "Name",
        className: "mr-2",
        value: wrapper.options.attr[i].id,
        onChange: newVal => {
          wrapper.options.attr[i].id = newVal;
          var ssdsd = wrapper.options.attr.concat([]);
          var options = {
            ...wrapper.options,
            attr: ssdsd
          };
          setAttributes({
            wrapper: {
              ...wrapper,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          wrapper.options.attr[i].val = newVal;
          var ssdsd = wrapper.options.attr.concat([]);
          var options = {
            ...wrapper.options,
            attr: ssdsd
          };
          setAttributes({
            wrapper: {
              ...wrapper,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        // className="text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close"
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          wrapper.options.attr.splice(i, 1);
          var ssdsd = wrapper.options.attr.concat([]);
          var options = {
            ...wrapper.options,
            attr: ssdsd
          };
          setAttributes({
            wrapper: {
              ...wrapper,
              options: options
            }
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"]
      }))));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_16__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_17__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Text", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_13__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable text?", "post-grid"),
      help: textEnable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Text enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Text disabled.", "post-grid"),
      checked: textEnable,
      onChange: e => {
        var options = {
          ...text.options,
          enable: text.options.enable ? false : true
        };
        setAttributes({
          text: {
            ...text,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.RichText, {
      className: "components-textarea-control__input",
      tagName: "div"
      // className="pg-text"
      ,
      value: text.options.text,
      allowedFormats: ["core/bold", "core/italic", "core/link"],
      onChange: content => {
        var options = {
          ...text.options,
          text: content
        };
        setAttributes({
          text: {
            ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Writing...")
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
      obj: text,
      onChange: onChangeStyleText,
      onAdd: onAddStyleText,
      onRemove: onRemoveStyleText,
      onBulkAdd: onBulkAddText,
      onReset: onResetText
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_16__["default"], {
      blockId: blockId,
      obj: text,
      onChange: onPickCssLibraryText
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_17__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_13__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_11__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Text", "post-grid"),
        value: "beforeText"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Text", "post-grid"),
        value: "afterText"
      }],
      onChange: newVal => {
        var options = {
          ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon,
      onReset: onResetIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_16__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_17__["default"], {
      opened: isProFeature ? false : null,
      className: "font-medium text-slate-900 "
      // title="UTM tracking"
      ,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_13__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Enable Image?", "post-grid"),
      help: imageEnable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image disabled.", "post-grid"),
      checked: imageEnable ? true : false,
      onChange: e => {
        var options = {
          ...image.options,
          enable: image.options.enable ? false : true
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image Sources", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.imgSrcType,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Media", "post-grid"),
        value: "media"
      },
      // { label: __("Custom Field","post-grid"), value: "customField" },
      {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image Source URL", "post-grid"),
        value: "customUrl"
      }
      // { label: 'Image ID', value: 'imgId' },
      ],
      onChange: newVal => {
        var options = {
          ...image.options,
          imgSrcType: newVal
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      }
    })), image.options.srcUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.MediaUploadCheck, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.MediaUpload, {
      className: "bg-gray-700 hover:bg-gray-600",
      onSelect: media => {
        // media.id
        setCurrentPostImageId(media.id);
        var options = {
          ...image.options,
          srcUrl: media.url,
          srcId: media.id
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      },
      onClose: () => {},
      allowedTypes: ALLOWED_MEDIA_TYPES,
      value: image.options.srcId,
      render: ({
        open
      }) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("img", {
        src: image.options.srcUrl,
        alt: "",
        className: "cursor-pointer",
        onClick: open
      })
    })), image.options.srcUrl.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.MediaUploadCheck, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.MediaUpload, {
      className: "bg-gray-700 hover:bg-gray-600",
      onSelect: media => {
        // media.id
        setCurrentPostImageId(media.id);
        var options = {
          ...image.options,
          srcUrl: media.url,
          srcId: media.id
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      },
      onClose: () => {},
      allowedTypes: ALLOWED_MEDIA_TYPES,
      value: image.options.srcId,
      render: ({
        open
      }) =>
      // <Button
      // 	className="my-3 bg-gray-700 hover:bg-gray-600 text-white border border-solid border-gray-300 text-center w-full"
      // 	onClick={open}>
      // 	{__("Open Media Library","post-grid")}
      // </Button>
      (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("img", {
        src: _placeholder_jpg__WEBPACK_IMPORTED_MODULE_23__,
        alt: "",
        className: "cursor-pointer",
        onClick: open
      })
    })), image.options.imgSrcType == "media" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "mt-5"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Image", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.MediaUploadCheck, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.MediaUpload, {
      className: "bg-gray-700 hover:bg-gray-600",
      onSelect: media => {
        // media.id
        setCurrentPostImageId(media.id);
        var options = {
          ...image.options,
          srcUrl: media.url,
          srcId: media.id
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      },
      onClose: () => {},
      allowedTypes: ALLOWED_MEDIA_TYPES,
      value: image.options.srcId,
      render: ({
        open
      }) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
        className: "my-3 bg-gray-700 hover:bg-gray-600 text-white border border-solid border-gray-300 text-center w-full hover:text-white ",
        onClick: open
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Open Media Library", "post-grid"))
    }))), image.options.imgSrcType == "customUrl" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image URL", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerSrcUrl ? "!bg-gray-400" : "",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"],
      onClick: ev => {
        setlinkPickerSrcUrl(prev => !prev);
      }
    }), image.options.srcUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__["default"],
      onClick: ev => {
        var options = {
          ...image.options,
          srcUrl: ""
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
        setlinkPickerSrcUrl(false);
      }
    }), linkPickerSrcUrl && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.__experimentalLinkControl, {
      settings: [],
      value: image.options.srcUrl,
      onChange: newVal => {
        var options = {
          ...image.options,
          srcUrl: newVal.url
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
        setPostImage({
          ...postImage,
          srcUrl: newVal.url,
          media_details: {
            sizes: {}
          },
          guid: {
            rendered: newVal.url
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "font-bold"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image Source URL:", "post-grid")), " ", image.options.srcUrl.length != 0 ? image.options.srcUrl : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No link", "post-grid"), " "))))), image.options.imgSrcType == "imgId" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.imgSrcImgId,
      onChange: newVal => {
        var options = {
          ...image.options,
          imgSrcImgId: newVal
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Image position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Before Text", "post-grid"),
        value: "beforeText"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("After Text", "post-grid"),
        value: "afterText"
      }],
      onChange: newVal => {
        var options = {
          ...image.options,
          position: newVal
        };
        setAttributes({
          image: {
            ...image,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
      obj: image,
      onChange: onChangeStyleImage,
      onAdd: onAddStyleImage,
      onRemove: onRemoveStyleImage,
      onBulkAdd: onBulkAddImage,
      onReset: onResetImage
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_16__["default"], {
      blockId: blockId,
      obj: image,
      onChange: onPickCssLibraryImage
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_17__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block Variations", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_library_block_variations__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockName: blockNameLast,
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockPatterns
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_17__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_18__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), wrapper.options.showAfter == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-center my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "border border-solid border-gray-300 w-[95%] rounded-md p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Click to pick a variation", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-gray-700 rounded-sm px-4 py-1 font-semibold text-lg text-white cursor-pointer",
      onClick: ev => {
        var content = '<!-- wp:post-grid/back-to-top {"wrapper":{"options":{"tag":"div","class":"pg-back-to-top","showAfter":"300","offsetTop":"0","attr":[]},"styles":{"position":{"Desktop":"relative"},"right":{"Desktop":"50px"},"bottom":{"Desktop":"50px"}}},"blockId":"pg8dd7d1541a1c","blockCssY":{"items":{".pg8dd7d1541a1c":{"position":{"Desktop":"relative"},"right":{"Desktop":"50px"},"bottom":{"Desktop":"50px"}},".pg8dd7d1541a1c .back-to-top-image":{"display":{"Desktop":"block"},"max-width":{"Desktop":"40px"},"height":{"Desktop":"auto"}}}}} /-->';
        wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Skip", "post-grid"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...blockProps,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_block_variations_picker__WEBPACK_IMPORTED_MODULE_24__["default"], {
      blockName: "back-to-top",
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockVariation
    }))))), wrapper.options.showAfter > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !editMode && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-green-200 p-2",
      onClick: ev => {
        seteditMode(true);
      }
    }, "Enable Edit - Back to Top"), wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTag, {
      ...blockProps,
      ...wrapAttrItems
    }, icon.options.position == "beforeText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), imageEnable && image.options.position == "beforeText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("img", {
      className: "back-to-top-image"
      // {...linkAttrItems}
      ,
      src: postImage.guid.rendered != undefined ? postImage.guid.rendered : "",
      alt: postImage.alt_text
    }), postImage.media_details.sizes[image.options.size[breakPointX]] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("img", {
      className: "back-to-top-image"
      // {...linkAttrItems}
      ,
      src: postImage.media_details.sizes[image.options.size[breakPointX]].source_url,
      alt: postImage.alt_text
    }))), text.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.RichText, {
      className: "text",
      tagName: "span",
      value: text.options.text,
      allowedFormats: ["core/bold", "core/italic", "core/link"],
      onChange: content => {
        var options = {
          ...text.options,
          text: content
        };
        setAttributes({
          text: {
            ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Writing...")
    }), imageEnable && image.options.position == "afterText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("img", {
      className: "back-to-top-image"
      // {...linkAttrItems}
      ,
      src: postImage.guid.rendered != undefined ? postImage.guid.rendered : "",
      alt: postImage.alt_text
    }), postImage.media_details.sizes[image.options.size[breakPointX]] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("img", {
      className: "back-to-top-image"
      // {...linkAttrItems}
      ,
      src: postImage.media_details.sizes[image.options.size[breakPointX]].source_url,
      alt: postImage.alt_text
    }))), icon.options.position == "afterText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, text.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, icon.options.position == "beforeText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), preview && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "text",
      onClick: ev => {
        setPreview(!preview);
      }
    }, customText), !preview && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, textEnable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.RichText, {
      className: "text",
      tagName: "span",
      value: customText,
      allowedFormats: ["core/bold", "core/italic", "core/link"],
      onChange: content => {
        var options = {
          ...text.options,
          text: content
        };
        setAttributes({
          text: {
            ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Writing...")
    })), icon.options.position == "afterText" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/breadcrumb/index.js":
/*!****************************************!*\
  !*** ./src/blocks/breadcrumb/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/menu.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./block.json */ "./src/blocks/breadcrumb/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_block_variations_picker__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../components/block-variations-picker */ "./src/components/block-variations-picker/index.js");















const {
  RawHTML
} = wp.element;















var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_21__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("path", {
      d: "M159.996 80.3332C159.996 80.7777 159.551 81.2221 159.551 81.6666L148.44 91.4443C147.551 91.8888 146.662 91.8888 146.218 91.4443C145.773 90.5554 145.773 89.6666 146.218 89.2221L155.996 80.7777L146.218 72.3332C145.329 71.8888 145.329 70.5554 146.218 70.111C146.662 69.2221 147.996 69.2221 148.44 70.111L159.551 79.8888C159.996 79.4443 159.996 79.8888 159.996 80.3332Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("path", {
      d: "M75.107 80.3333C75.107 80.7778 74.6626 81.2222 74.6626 81.6667L63.5515 91C62.6626 91.4444 61.7737 91.4444 61.3293 91C60.8848 90.1111 60.8848 89.2222 61.3293 88.7778L71.107 80.3333L61.3293 71.8889C60.4404 71.4444 60.4404 70.1111 61.3293 69.6667C61.7737 68.7778 63.107 68.7778 63.5515 69.6667L74.6626 79.4444C75.107 79.4444 75.107 79.8889 75.107 80.3333Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("path", {
      d: "M47.5517 69.2222H-0.00390625V91.4444H47.5517V69.2222Z",
      fill: "url(#paint0_linear_61_603)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("path", {
      d: "M36.4403 77.2222H11.1069V82.9999H36.4403V77.2222Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("path", {
      d: "M131.996 69.2222H84.8853V91.4444H132.441V69.2222H131.996Z",
      fill: "url(#paint1_linear_61_603)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("path", {
      d: "M120.885 77.2222H95.5518V82.9999H120.885V77.2222Z",
      fill: "white"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("linearGradient", {
      id: "paint0_linear_61_603",
      x1: "-0.00390625",
      y1: "80.3333",
      x2: "47.5517",
      y2: "80.3333",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("linearGradient", {
      id: "paint1_linear_61_603",
      x1: "84.8853",
      y1: "80.3333",
      x2: "132.441",
      y2: "80.3333",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var elements = attributes.elements;
    var icon = attributes.icon;
    var label = attributes.label;
    var separator = attributes.separator;
    var schema = attributes.schema;
    var link = attributes.link;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    var utmTracking = attributes.utmTracking;
    var wrapperSelector = blockClass;
    // Wrapper CSS Class Selectors
    var itemSelector = blockClass + " .item";
    var linkSelector = blockClass + " .item a";
    var iconSelector = blockClass + " .item .icon";
    var labelSelector = blockClass + " .item .label";
    var separatorSelector = blockClass + " .item .separator";
    var [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(myStore.getBreakPoint());
    var [loading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
    var [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_8__.useEntityProp)("postType", postType, "link", postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[itemSelector] = elements;
      blockCssObj[iconSelector] = icon;
      blockCssObj[labelSelector] = label;
      blockCssObj[linkSelector] = link;
      blockCssObj[separatorSelector] = separator;
      elements.items.map((x, i) => {
        var selector = `${blockClass}  .item:nth-child(${i + 1})`;
        blockCssObj[selector] = x;
      });
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    function regenerateElementStyle() {
      var iSelector = `css-block-${blockClass}`;
      var elemX = document.querySelector(iSelector);
      if (elemX != null) {
        elemX.remove();
      }
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[itemSelector] = elements;
      blockCssObj[iconSelector] = icon;
      blockCssObj[labelSelector] = label;
      blockCssObj[linkSelector] = link;
      blockCssObj[separatorSelector] = separator;
      elements.items.map((x, i) => {
        var selector = `${blockClass}  .item:nth-child(${i + 1})`;
        blockCssObj[selector] = x;
      });
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
      regenerateElementStyle();
      setTimeout(x => {
        //setAttributes({ blockCssY: { items: newValuesObjX } });
      }, 2000);
    }, [elements]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_7__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_7__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        // var blockId = attributes.blockId
        var wrapperX = attributes.wrapper;
        var iconX = attributes.icon;
        var labelX = attributes.label;
        var separatorX = attributes.separator;
        var elementsX = attributes.elements;
        // var schemaX = attributes.schema;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        if (iconX != undefined) {
          var iconY = {
            ...iconX,
            options: icon.options
          };
          setAttributes({
            icon: iconY
          });
          blockCssObj[iconSelector] = iconY;
        }
        if (labelX != undefined) {
          var labelY = {
            ...labelX,
            options: label.options
          };
          setAttributes({
            label: labelY
          });
          blockCssObj[labelSelector] = labelY;
        }
        if (separatorX != undefined) {
          var separatorY = {
            ...separatorX,
            options: separator.options
          };
          setAttributes({
            separator: separatorY
          });
          blockCssObj[separatorSelector] = separatorY;
        }
        if (elementsX != undefined) {
          var elementsY = {
            ...elementsX,
            options: elements.options
          };
          setAttributes({
            elements: elementsY
          });
          blockCssObj[itemSelector] = elementsY;
        }
        // if (schemaX != undefined) {
        // 	var schemaY = { ...schemaX, options: schema.options };
        // 	setAttributes({ schema: schemaY });
        // 	blockCssObj[schemaSelector] = schemaY;
        // }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function onPickBlockVariation(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
    }
    var breadcrumbElementsSourceBasic = [{
      id: "text",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Text", "post-grid"),
      customText: "You are here: ",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        text: "You are here: ",
        showSeparator: true,
        isLink: false
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "homePage",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Home Page Link", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        isLink: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "frontPage",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Front Page Link", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postsPage",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Posts Page Link", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postTitle",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Title", "post-grid"),
      customText: "",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        isLink: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postAuthor",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Author", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postDate",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Date", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        format: "Y-m-d",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postDay",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Day", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        format: "",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postMonth",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Month", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        format: "",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postYear",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Year", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        format: "",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postId",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Id", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postCategory",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Category", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postTag",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Tag", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "termTitle",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Term Title", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "wcShop",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("WooCommerce Shop", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "wcAccount",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("WooCommerce Account", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "searchText",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Search Text", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "archiveTitle",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Archive Title", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "404Text",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("404 Text", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "dateText",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Date Text", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        format: "Y-m-d"
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "monthText",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Month Text", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        format: "Y-m"
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "yearText",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Year Text", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        format: "Y"
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "authorName",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Author Name", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postAncestors",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Ancestors", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        count: ""
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postCategories",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Categories", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        maxCount: 3
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postTags",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Tags", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        maxCount: 3
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postTerm",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Term", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        taxonomy: "",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "postTerms",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Post Terms", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        taxonomy: "",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "termParents",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Term Parents", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true,
        count: 0
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "termAncestors",
      isPro: true,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Term Ancestors", "post-grid"),
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        taxonomy: "",
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "wcCart",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("WooCommerce Cart", "post-grid"),
      isPro: true,
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }, {
      id: "wcCheckout",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("WooCommerce Checkout", "post-grid"),
      isPro: true,
      customText: "%s",
      url: "",
      siteIcon: {
        library: "fontAwesome",
        srcType: "class",
        /*class, html, img, svg */iconSrc: ""
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ""
        },
        backgroundColor: {
          Desktop: ""
        },
        padding: {
          Desktop: ""
        },
        margin: {
          Desktop: ""
        }
      }
    }];
    let linkElementsArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)("postGridBreadcrumbElementsSource", breadcrumbElementsSourceBasic);
    // let linkElementsArgs = linkElementsArgsBasic;
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)("isProFeature", true);
    var elementSources = {
      none: {
        label: "Manual",
        value: ""
      },
      dynamic: {
        label: "Dynamic",
        value: "dynamic"
      }
    };
    function addMedia(option, index) {
      var elementsX = elements.items.push(option);
      setAttributes({
        elements: {
          ...elements,
          items: elements.items
        }
      });
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleElements(sudoScource, key) {
      let obj = {
        ...elements
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        elements: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleIcon(sudoScource, key) {
      let obj = {
        ...icon
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        icon: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleLabel(sudoScource, key) {
      let obj = {
        ...label
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        label: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleLink(sudoScource, key) {
      let obj = {
        ...link
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        link: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, linkSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onRemoveStyleSeparator(sudoScource, key) {
      let obj = {
        ...separator
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        separator: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onResetElements(sudoSources) {
      let obj = Object.assign({}, elements);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        elements: obj
      });
    }
    function onResetIcon(sudoSources) {
      let obj = Object.assign({}, icon);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        icon: obj
      });
    }
    function onResetLabel(sudoSources) {
      let obj = Object.assign({}, label);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        label: obj
      });
    }
    function onResetLink(sudoSources) {
      let obj = Object.assign({}, link);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, linkSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        link: obj
      });
    }
    function onResetSeparator(sudoSources) {
      let obj = Object.assign({}, separator);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        separator: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onChangeStyleElements(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        elements: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleElements(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        elements: object
      });
    }
    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        icon: object
      });
    }
    function onChangeStyleLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        label: object
      });
    }
    function onChangeStyleLink(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, link);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        link: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, linkSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleLink(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, link);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        link: object
      });
    }
    function onChangeStyleSeparator(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleSeparator(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        separator: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddItems(sudoScource, cssObj) {
      let obj = Object.assign({}, elements);
      obj[sudoScource] = cssObj;
      setAttributes({
        elements: obj
      });
      var selector = myStore.getElementSelector(sudoScource, itemSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddIcon(sudoScource, cssObj) {
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddLabel(sudoScource, cssObj) {
      let obj = Object.assign({}, label);
      obj[sudoScource] = cssObj;
      setAttributes({
        label: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddLink(sudoScource, cssObj) {
      let obj = Object.assign({}, link);
      obj[sudoScource] = cssObj;
      setAttributes({
        link: obj
      });
      var selector = myStore.getElementSelector(sudoScource, linkSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onBulkAddSeperator(sudoScource, cssObj) {
      let obj = Object.assign({}, separator);
      obj[sudoScource] = cssObj;
      setAttributes({
        separator: obj
      });
      var selector = myStore.getElementSelector(sudoScource, separatorSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class}`
    });
    let counts = 0;
    function onChangeStyleItem(sudoScource, newVal, attr, obj, extra) {
      var index = extra.index;
      var path = [sudoScource, attr, breakPointX];
      let objX = Object.assign({}, obj);
      const object = myStore.updatePropertyDeep(objX, path, newVal);
      var elementsX = {
        ...elements
      };
      elementsX.items[index] = object;
      setAttributes({
        elements: elementsX
      });
      var selector = `${blockClass} .item-${index}`;
      //setAttributes({ obj: object });
      var elementSelector = myStore.getElementSelector(sudoScource, selector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsCssX = Object.assign({}, blockCssY.items);
      if (itemsCssX[elementSelector] == undefined) {
        itemsCssX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsCssX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleItem(sudoScource, key, obj, extra) {
      var index = extra.index;
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      var elementsX = {
        ...elements
      };
      elementsX.items[index] = object;
      setAttributes({
        elements: elementsX
      });
      var selector = `${blockClass} .item-${index}`;
      var elementSelector = myStore.getElementSelector(sudoScource, selector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onAddStyleItem(sudoScource, key, obj, extra) {
      var index = extra.index;
      var path = [sudoScource, key, breakPointX];
      let objX = Object.assign({}, obj);
      const object = myStore.addPropertyDeep(objX, path, "");
      var elementsX = {
        ...elements
      };
      elementsX.items[index] = object;
      setAttributes({
        elements: elementsX
      });
      //setAttributes({ items: object });
      // setAttributes({ items: itemsX });
    }
    function onBulkAddItem(sudoScource, cssObj, extra) {
      var index = extra.index;
      var elementsX = {
        ...elements
      };
      var itemssX = elementsX.items[index];
      let obj = Object.assign({}, itemssX);
      obj[sudoScource] = cssObj;
      elementsX.items[index] = obj;
      setAttributes({
        elements: elementsX
      });
      var selectorX = `${blockClass} .item-${index}`;
      var selector = myStore.getElementSelector(sudoScource, selectorX);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onResetNthItem(sudoSources, extra) {
      const index = extra.index;
      var elementsX = {
        ...elements
      };
      var itemssX = elementsX.items[index];
      if (itemssX) {
        const obj = {
          ...itemssX
        };
        Object.entries(sudoSources).forEach(([sudoSource]) => {
          if (obj[sudoSource]) {
            obj[sudoSource] = {};
            const selector = `${blockClass} .item-${index}`;
            const elementSelector = myStore.getElementSelector(sudoSource, selector);
            const cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
            setAttributes({
              blockCssY: {
                items: cssObject
              }
            });
          }
        });
        elementsX.items[index] = obj;
        setAttributes({
          elements: elementsX
        });
      }
    }
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_23__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_24__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Items", "post-grid"),
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Element Sources", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_14__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: elementSources,
      buttonTitle: elements.options?.elementSource == undefined || elements.options?.elementSource.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Choose...", "post-grid") : elementSources[elements.options?.elementSource] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Choose...", "post-grid") : elementSources[elements.options?.elementSource].label,
      onChange: newVal => {
        var options = {
          ...elements.options,
          elementSource: newVal.value
        };
        setAttributes({
          elements: {
            ...elements,
            options: options
          }
        });
      },
      value: elements.options?.elementSource
    }))), elements.options?.elementSource == "dynamic" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3 p-3 bg-green-200 inline-block"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Elements will automatically generated based on page types.", "post-grid")), elements.options?.elementSource != "dynamic" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Add Element", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_14__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkElementsArgs,
      buttonTitle: "Choose",
      onChange: addMedia,
      values: ""
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__.ReactSortable, {
      list: elements.items,
      handle: ".handle",
      setList: item => {
        setAttributes({
          elements: {
            ...elements,
            items: item
          }
        });
      }
    }, elements.items.map((item, index) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      key: item.id,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          var elementsX = elements.items.splice(index, 1);
          setAttributes({
            elements: {
              ...elements,
              items: elements.items
            }
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "handle cursor-pointer bg-gray-700 hover:bg-gray-600 hover:text-white px-1 py-1"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "mx-2"
      }, item.label)),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Custom Label", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: item.customText,
      placeholder: "You Text: %s",
      onChange: newVal => {
        var elementX = {
          ...elements
        };
        var items = elementX.items;
        items[index].customText = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("p", null, "Please use ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("code", null, "%s"), " for output")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.ToggleControl, {
      label: "Is Linked?",
      help: item.options?.isLink ? "Linked to URL" : "Not linked to URL.",
      checked: item.options?.isLink ? true : false,
      onChange: e => {
        var options = {
          ...item.options,
          isLink: item.options.isLink ? false : true
        };
        elements.items[index].options = options;
        // var items = {
        // 	...items,
        // 	options: options,
        // }
        setAttributes({
          elements: {
            ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Custom URL", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: item.url,
      onChange: newVal => {
        elements.items[index].url = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: elements.items
          }
        });
      }
    })), (item.id == "postTerms" || item.id == "postTerm") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Taxonomy", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: item.options.taxonomy,
      onChange: newVal => {
        elements.items[index].options.taxonomy = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: elements.items
          }
        });
      }
    })), (item.id == "termParents" || item.id == "postAncestors") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Max Count", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: item.options.count,
      onChange: newVal => {
        elements.items[index].options.count = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("p", null, "Use ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("code", null, "-"), " (negetive sign) to count from end."))), (item.id == "dateText" || item.id == "monthText" || item.id == "yearText" || item.id == "postDate" || item.id == "postDay" || item.id == "postMonth" || item.id == "postYear") && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Date Format", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: item.options.format,
      onChange: newVal => {
        elements.items[index].options.format = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: elements.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Choose Icon", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_15__["default"], {
      library: item?.siteIcon?.library,
      srcType: item?.siteIcon?.srcType,
      iconSrc: item?.siteIcon?.iconSrc,
      onChange: arg => {
        //var options = { ...icon.options, srcType: arg.srcType, library: arg.library, iconSrc: arg.iconSrc };
        //setAttributes({ icon: { ...icon, options: options } });
        elements.items[index].siteIcon = {
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          elements: {
            ...elements,
            items: elements.items
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: item,
      extra: {
        index: index
      },
      onChange: onChangeStyleItem,
      onAdd: onAddStyleItem,
      onRemove: onRemoveStyleItem,
      onBulkAdd: onBulkAddItem,
      onReset: onResetNthItem
    })))))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.ToggleControl, {
      className: "my-3",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Display Label?", "post-grid"),
      help: elements?.options?.showLabel ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Label is displaying", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Label is hidden", "post-grid"),
      checked: elements?.options?.showLabel ? true : false,
      onChange: e => {
        var options = {
          ...elements.options,
          showLabel: elements.options.showLabel ? false : true
        };
        setAttributes({
          elements: {
            ...elements,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "flex w-full justify-between items-center"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.ToggleControl, {
      className: "my-3",
      disabled: isProFeature,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Display Icon?", "post-grid"),
      help: elements?.options?.showIcon ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Icon is displaying", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Icon is hidden", "post-grid"),
      checked: elements?.options?.showIcon ? true : false,
      onChange: e => {
        var options = {
          ...elements.options,
          showIcon: elements.options.showIcon ? false : true
        };
        setAttributes({
          elements: {
            ...elements,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", null, isProFeature && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("a", {
      target: "_blank",
      href: "https://pickplugins.com/post-grid/?utm_source=dropdownComponent&utm_term=proFeature&utm_campaign=pluginPostGrid&utm_medium="
      // x.label
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Pro", "post-grid")))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.ToggleControl, {
      className: "my-3",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Display Separator?", "post-grid"),
      help: elements?.options?.showSeparator ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Separator is displaying", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Separator is hidden", "post-grid"),
      checked: elements?.options?.showSeparator ? true : false,
      onChange: e => {
        var options = {
          ...elements.options,
          showSeparator: elements.options.showSeparator ? false : true
        };
        setAttributes({
          elements: {
            ...elements,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: elements,
      onChange: onChangeStyleElements,
      onAdd: onAddStyleElements,
      onBulkAdd: onBulkAddItems,
      onReset: onResetElements,
      onRemove: onRemoveStyleElements
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title= {__("Icon","post-grid")}
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Icon", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Icon position", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Choose Position", "post-grid"),
        value: ""
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Before Label", "post-grid"),
        value: "beforeLabel"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("After Label", "post-grid"),
        value: "afterLabel"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Before Separator", "post-grid"),
        value: "beforeSeparator"
      }, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("After Separator", "post-grid"),
        value: "afterSeparator"
      }],
      onChange: newVal => {
        var options = {
          ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: {
            ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onBulkAdd: onBulkAddIcon,
      onReset: onResetIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Label", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "styles",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: label,
      onChange: onChangeStyleLabel,
      onAdd: onAddStyleLabel,
      onBulkAdd: onBulkAddLabel,
      onReset: onResetLabel,
      onRemove: onRemoveStyleLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Link", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "styles",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: link,
      onChange: onChangeStyleLink,
      onAdd: onAddStyleLink,
      onBulkAdd: onBulkAddLink,
      onReset: onResetLink,
      onRemove: onRemoveStyleLink
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Separator", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Separator Text", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.__experimentalInputControl, {
      value: separator.options.text,
      onChange: newVal => {
        var options = {
          ...separator.options,
          text: newVal
        };
        setAttributes({
          separator: {
            ...separator,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: separator,
      onChange: onChangeStyleSeparator,
      onAdd: onAddStyleSeparator,
      onBulkAdd: onBulkAddSeperator,
      onReset: onResetSeparator,
      onRemove: onRemoveStyleSeparator
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 "
      // title="Schema"
      ,
      opened: isProFeature ? false : null,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "flex justify-between w-full gap-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Schema", "post-grid")), isProFeature ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white",
        onClick: ev => {
          window.open("https://comboblocks.com/pricing/", "_blank");
        }
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Pro", "post-grid")) : "", " "),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_10__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Enable Schema?", "post-grid"),
      help: schema.options.enable ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Schema Enabled", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Schema Disabled.", "post-grid"),
      checked: schema.options.enable ? true : false,
      onChange: e => {
        var options = {
          ...schema.options,
          enable: schema.options.enable ? false : true
        };
        setAttributes({
          schema: {
            ...schema,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Block Variations", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_library_block_variations__WEBPACK_IMPORTED_MODULE_22__["default"], {
      blockName: blockNameLast,
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockPatterns
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_17__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), elements.items.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "flex justify-center  my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "border border-solid border-gray-300 w-[95%] rounded-md p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Click to pick a variation", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "bg-gray-700 rounded-sm px-4 py-1 font-semibold text-lg text-white cursor-pointer",
      onClick: ev => {
        var content = '<!-- wp:post-grid/breadcrumb {"wrapper":{"options":{"tag":"div","class":"pg-breadcrumb"},"styles":{"display":{"Desktop":"flex"},"margin":{"Desktop":"0px 0px 0px 0px"},"padding":{"Desktop":"0px 0px 0px 0px"},"backgroundColor":{"Desktop":"#dedddd"},"border":{"Desktop":"1px solid #a6a0fb"},"lineHeight":[],"maxWidth":[],"width":[],"height":[],"borderRadius":{"Desktop":"5px 5px 5px 5px"},"gap":[],"flexDirection":[],"flexWrap":{"Tablet":"wrap !important"},"overflow":{"Mobile":"hidden"}}},"label":{"options":{"class":""},"styles":{"color":[],"fontSize":[],"fontFamily":[],"fontStyle":[],"fontWeight":[],"listStyle":[]}},"link":{"options":[],"styles":{"color":{"Desktop":"#5196e4 !important"},"fontSize":[],"fontFamily":[],"fontStyle":[],"fontWeight":[],"margin":{"Desktop":"0px 10px 0px 10px"},"padding":{"Desktop":"5px 0px 5px 0px"},"textDecoration":{"Desktop":"none #000000 wavy 1px !important"}}},"elements":{"options":{"linkTarget":"_blank","showLabel":true,"showSeparator":true,"showIcon":false,"iconPositon":"beforeLabel"},"styles":{"color":{"Desktop":"#5196e4 !important"},"fontSize":{"Desktop":"16px"},"fontFamily":[],"fontStyle":[],"fontWeight":[],"display":[],"padding":{"Tablet":"10px 10px 10px 20px","Desktop":"0px 10px 0px 10px"},"backgroundColor":{"Tablet":"#dedddd"},"borderRadius":{"Tablet":"5px 5px 5px 5px"},"border":{"Tablet":"1px solid #a6a0fb"},"listStyle":{"Desktop":"none"},"lineHeight":{"Desktop":"40px"}},"items":[{"id":"text","label":"Text","customText":"You are here:","url":"","siteIcon":{"srcType":"class","library":"fontAwesome","iconSrc":"fas fa-caret-right"},"options":{"text":"You are here: ","showSeparator":true,"isLink":false},"styles":[],"chosen":false,"selected":false},{"id":"homePage","label":"Home Page Link","customText":"","url":"","siteIcon":{"srcType":"class","library":"iconFont","iconSrc":"fas fa-caret-right"},"options":{"showSeparator":true,"isLink":true},"styles":[],"chosen":false,"selected":false},{"id":"postTitle","label":"Post Title","customText":"","url":"","siteIcon":{"srcType":"class","library":"fontAwesome","iconSrc":"fas fa-caret-right"},"options":{"showSeparator":true,"isLink":true},"styles":[],"chosen":false,"selected":false}]},"blockCssY":{"items":{".pg07261194bc7a":{"display":{"Desktop":"flex"},"margin":{"Desktop":"0px 0px 0px 0px"},"padding":{"Desktop":"0px 0px 0px 0px"},"background-color":{"Desktop":"#dedddd"},"border":{"Desktop":"1px solid #a6a0fb"},"border-radius":{"Desktop":"5px 5px 5px 5px"},"flex-wrap":{"Tablet":"wrap !important"},"overflow":{"Mobile":"hidden"}},".pg07261194bc7a .item":{"color":{"Desktop":"#5196e4 !important"},"font-size":{"Desktop":"16px"},"padding":{"Tablet":"10px 10px 10px 20px","Desktop":"0px 10px 0px 10px"},"background-color":{"Tablet":"#dedddd"},"border-radius":{"Tablet":"5px 5px 5px 5px"},"border":{"Tablet":"1px solid #a6a0fb"},"list-style":{"Desktop":"none"},"line-height":{"Desktop":"40px"}},".pg07261194bc7a .item:items":{"0":{"id":"text","label":"Text","customText":"You are here:","url":"","siteIcon":{"srcType":"class","library":"fontAwesome","iconSrc":"fas fa-caret-right"},"options":{"text":"You are here: ","showSeparator":true,"isLink":false},"styles":[],"chosen":false,"selected":false},"1":{"id":"homePage","label":"Home Page Link","customText":"","url":"","siteIcon":{"srcType":"class","library":"iconFont","iconSrc":"fas fa-caret-right"},"options":{"showSeparator":true,"isLink":true},"styles":[],"chosen":false,"selected":false},"2":{"id":"postTitle","label":"Post Title","customText":"","url":"","siteIcon":{"srcType":"class","library":"fontAwesome","iconSrc":"fas fa-caret-right"},"options":{"showSeparator":true,"isLink":true},"styles":[],"chosen":false,"selected":false}},".pg07261194bc7a .item .icon":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"margin":{"Desktop":"0px 10px 0px 0px"}},".pg07261194bc7a .item a":{"color":{"Desktop":"#5196e4 !important"},"margin":{"Desktop":"0px 10px 0px 10px"},"padding":{"Desktop":"5px 0px 5px 0px"},"text-decoration":{"Desktop":"none #000000 wavy 1px !important"}},".pg07261194bc7a .item .separator":{"color":{"Desktop":"#000000 !important"},"font-size":{"Desktop":"18px"},"font-family":{"Desktop":"Poppins"},"font-style":{"Desktop":"normal"},"font-weight":{"Desktop":"400"},"margin":{"Desktop":"0px 10px 0px 10px"}},".pg07261194bc7a  .item:nth-child(1):id":{"0":"t","1":"e","2":"x","3":"t"},".pg07261194bc7a  .item:nth-child(1):label":{"0":"T","1":"e","2":"x","3":"t"},".pg07261194bc7a  .item:nth-child(1):customText":{"0":"Y","1":"o","2":"u","3":" ","4":"a","5":"r","6":"e","7":" ","8":"h","9":"e","10":"r","11":"e","12":":"},".pg07261194bc7a  .item:nth-child(1):siteIcon":{"srcType":"class","library":"fontAwesome","iconSrc":"fas fa-caret-right"},".pg07261194bc7a  .item:nth-child(2):id":{"0":"h","1":"o","2":"m","3":"e","4":"P","5":"a","6":"g","7":"e"},".pg07261194bc7a  .item:nth-child(2):label":{"0":"H","1":"o","2":"m","3":"e","4":" ","5":"P","6":"a","7":"g","8":"e","9":" ","10":"L","11":"i","12":"n","13":"k"},".pg07261194bc7a  .item:nth-child(2):siteIcon":{"srcType":"class","library":"iconFont","iconSrc":"fas fa-caret-right"},".pg07261194bc7a  .item:nth-child(3):id":{"0":"p","1":"o","2":"s","3":"t","4":"T","5":"i","6":"t","7":"l","8":"e"},".pg07261194bc7a  .item:nth-child(3):label":{"0":"P","1":"o","2":"s","3":"t","4":" ","5":"T","6":"i","7":"t","8":"l","9":"e"},".pg07261194bc7a  .item:nth-child(3):siteIcon":{"srcType":"class","library":"fontAwesome","iconSrc":"fas fa-caret-right"}}},"blockId":"pg07261194bc7a"} /-->';
        wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
      }
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)("Skip", "post-grid"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      ...blockProps,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(_components_block_variations_picker__WEBPACK_IMPORTED_MODULE_25__["default"], {
      blockName: "breadcrumb",
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockVariation
    }))))), elements.options?.elementSource == "dynamic" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("div", {
      className: "my-3 p-3 bg-green-200"
    }, "Elements will automatically generated based on page types."), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("ol", {
      ...blockProps
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("li", {
      className: "item item-0"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("a", {
      href: "#home"
    }, elements.options.showIcon && icon.options.position === "beforeLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "icon fas fa-home"
    }), elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "label"
    }, "Home"), elements.options.showIcon && icon.options.position === "afterLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "icon fas fa-home"
    }))), elements.options.showSeparator && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements.options.showIcon && icon.options.position === "beforeSeparator" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "icon fas fa-home"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "separator"
    }, separator.options.text), elements.options.showIcon && icon.options.position === "afterSeparator" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "icon fas fa-home"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("li", {
      className: "item item-1"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("a", {
      href: "#new-page"
    }, elements.options.showIcon && icon.options.position === "beforeLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "icon fas fa-file-alt"
    }), elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "label"
    }, "New Page"), elements.options.showIcon && icon.options.position === "afterLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
      className: "icon fas fa-file-alt"
    }))))), elements.options?.elementSource != "dynamic" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements.items.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("ol", {
      ...blockProps
    }, elements.items.map((x, index) => {
      counts++;
      const showSeparator = counts < elements.items.length;
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("li", {
        className: "item item-" + index,
        key: index
      }, x.options?.isLink == true && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("a", {
        href: x.url
      }, elements.options.showIcon && icon.options.position == "beforeLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), x.customText, elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "label"
      }, x.customText.length > 0 ? x.customText : x.label), elements.options.showIcon && icon.options.position == "afterLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })), x.options?.isLink == false && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements?.options?.showIcon && icon.options.position == "beforeLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements?.options?.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "label"
      }, x.customText.length > 0 ? x.customText : x.label), elements?.options?.showIcon && icon.options.position == "afterLabel" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })), elements.options?.showSeparator && showSeparator && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements?.options?.showIcon && icon.options.position == "beforeSeparator" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), showSeparator && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: "separator"
      }, separator.options.text), elements?.options?.showIcon && icon.options.position == "afterSeparator" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })));
    }))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/business-hours/index.js":
/*!********************************************!*\
  !*** ./src/blocks/business-hours/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/menu.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./block.json */ "./src/blocks/business-hours/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_block_variations_picker__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/block-variations-picker */ "./src/components/block-variations-picker/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_23__);















const {
  RawHTML
} = wp.element;














var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_18__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M157.275 48.4749L82.63 5.675C81.0376 4.775 78.9477 4.775 77.3552 5.675L2.70979 48.4749C0.122083 49.9749 -0.773663 53.175 0.719246 55.775C1.21688 56.675 1.91343 57.375 2.80917 57.875L77.4546 98.075C79.0471 98.875 80.9382 98.875 82.5306 98.075L157.176 57.875C159.764 56.475 160.759 53.275 159.366 50.675C158.868 49.775 158.072 48.9749 157.275 48.4749ZM79.9428 87.275L16.345 53.075L79.9428 16.575L143.541 53.075L79.9428 87.275Z",
      fill: "url(#paint0_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M82.5306 126.175L154.588 86.3748V74.1748L79.9428 115.375L5.29736 74.1748V86.3748L77.3553 126.175C79.0472 127.075 80.9382 127.075 82.5306 126.175Z",
      fill: "url(#paint1_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M5.29736 115.675L77.4546 154.275C79.0471 155.075 80.9381 155.075 82.431 154.275L154.588 115.675V103.575L79.9428 143.575L5.29736 103.575V115.675Z",
      fill: "url(#paint2_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_513",
      x1: "-0.00341797",
      y1: "51.8375",
      x2: "159.997",
      y2: "51.8375",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_513",
      x1: "5.29736",
      y1: "100.512",
      x2: "154.588",
      y2: "100.512",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint2_linear_61_513",
      x1: "5.29736",
      y1: "129.225",
      x2: "154.588",
      y2: "129.225",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var items = attributes.items;
    var label = attributes.label;
    var timesWrap = attributes.timesWrap;
    var startTime = attributes.startTime;
    var endTime = attributes.endTime;
    var closed = attributes.closed;
    var elements = attributes.elements;
    var separator = attributes.separator;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    var breakPointX = myStore.getBreakPoint();
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "link", postId);
    const CustomTagWrapper = `${wrapper.options.tag}`;
    var postUrl = wrapper.options.customUrl != undefined && wrapper.options.customUrl.length > 0 ? wrapper.options.customUrl : currentPostUrl;
    var linkToArgsBasic = {
      postUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Post URL", "post-grid"),
        value: "postUrl"
      },
      homeUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Home URL", "post-grid"),
        value: "homeUrl"
      },
      authorUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author URL", "post-grid"),
        value: "authorUrl"
      },
      authorLink: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Link", "post-grid"),
        value: "authorLink"
      },
      authorMail: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Mail", "post-grid"),
        value: "authorMail",
        isPro: true
      },
      authorMeta: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Meta", "post-grid"),
        value: "authorMeta",
        isPro: true
      },
      customField: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Field", "post-grid"),
        value: "customField",
        isPro: true
      },
      customUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom URL", "post-grid"),
        value: "customUrl",
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("linkToArgs", linkToArgsBasic);
    // Wrapper CSS Class Selectors
    var wrapperSelector = blockClass;
    var itemsSelector = blockClass + " .item";
    // var itemSelector = blockClass + " .item";
    var labelSelector = blockClass + " .label";
    var timesWrapSelector = blockClass + " .times-wrap";
    var startTimeSelector = blockClass + " .start-time";
    var endTimeSelector = blockClass + " .end-time";
    var separatorSelector = blockClass + " .separator";
    var closedSelector = blockClass + " .closed";
    // var saturdaySelector = blockClass + " .saturday";
    // var sundaySelector = blockClass + " .sunday";
    // var mondaySelector = blockClass + " .monday";
    // var tuesdaySelector = blockClass + " .tuesday";
    // var wednesdaySelector = blockClass + " .wednesday";
    // var thursdaySelector = blockClass + " .thursday";
    // var fridaySelector = blockClass + " .friday";
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      blockCssObj[itemsSelector] = items;
      // blockCssObj[itemSelector] = elements;
      blockCssObj[labelSelector] = label;
      blockCssObj[timesWrapSelector] = timesWrap;
      blockCssObj[startTimeSelector] = startTime;
      blockCssObj[endTimeSelector] = endTime;
      blockCssObj[separatorSelector] = separator;
      blockCssObj[closedSelector] = closed;
      elements.items.map((x, i) => {
        var selector = `${blockClass} .item-${i}`;
        blockCssObj[selector] = x;
      });
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var itemX = blockCssRules;
      setAttributes({
        blockCssY: {
          items: itemX
        }
      });
    }, [blockId]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        var wrapperX = attributes.wrapper;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }
    function onPickCssLibraryWrapper(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        wrapper[sudoScource] = sudoScourceArgs;
      });
      var wrapperX = Object.assign({}, wrapper);
      setAttributes({
        wrapper: wrapperX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryitems(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        items[sudoScource] = sudoScourceArgs;
      });
      var itemsX = Object.assign({}, items);
      setAttributes({
        items: itemsX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, itemsSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibrarylabel(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        label[sudoScource] = sudoScourceArgs;
      });
      var labelX = Object.assign({}, label);
      setAttributes({
        label: labelX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibrarytimesWrap(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        timesWrap[sudoScource] = sudoScourceArgs;
      });
      var timesWrapX = Object.assign({}, timesWrap);
      setAttributes({
        timesWrap: timesWrapX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, timesWrapSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibrarystartTime(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        startTime[sudoScource] = sudoScourceArgs;
      });
      var startTimeX = Object.assign({}, startTime);
      setAttributes({
        startTime: startTimeX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, startTimeSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryendTime(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        endTime[sudoScource] = sudoScourceArgs;
      });
      var endTimeX = Object.assign({}, endTime);
      setAttributes({
        endTime: endTimeX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, endTimeSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryseparator(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        separator[sudoScource] = sudoScourceArgs;
      });
      var separatorX = Object.assign({}, separator);
      setAttributes({
        separator: separatorX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onPickCssLibraryclosed(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        closed[sudoScource] = sudoScourceArgs;
      });
      var closedX = Object.assign({}, closed);
      setAttributes({
        closed: closedX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, closedSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function setFieldLinkTo(option, index) {
      var options = {
        ...wrapper.options,
        linkTo: option.value
      };
      setAttributes({
        wrapper: {
          ...wrapper,
          options: options
        }
      });
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStylelabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStylelabel(sudoScource, key) {
      let obj = {
        ...label
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        label: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetlabel(sudoSources) {
      let obj = Object.assign({}, label);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        label: obj
      });
    }
    function onAddStylelabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        label: object
      });
    }
    function onBulkAddlabel(sudoScource, cssObj) {
      let obj = Object.assign({}, label);
      obj[sudoScource] = cssObj;
      setAttributes({
        label: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyletimesWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, timesWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        timesWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, timesWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyletimesWrap(sudoScource, key) {
      let obj = {
        ...timesWrap
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        timesWrap: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, timesWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResettimesWrap(sudoSources) {
      let obj = Object.assign({}, timesWrap);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, timesWrapSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        timesWrap: obj
      });
    }
    function onAddStyletimesWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, timesWrap);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        timesWrap: object
      });
    }
    function onBulkAddtimesWrap(sudoScource, cssObj) {
      let obj = Object.assign({}, timesWrap);
      obj[sudoScource] = cssObj;
      setAttributes({
        timesWrap: obj
      });
      var selector = myStore.getElementSelector(sudoScource, timesWrapSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStylestartTime(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, startTime);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        startTime: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, startTimeSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStylestartTime(sudoScource, key) {
      let obj = {
        ...startTime
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        startTime: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, startTimeSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetstartTime(sudoSources) {
      let obj = Object.assign({}, startTime);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, startTimeSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        startTime: obj
      });
    }
    function onAddStylestartTime(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, startTime);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        startTime: object
      });
    }
    function onBulkAddstartTime(sudoScource, cssObj) {
      let obj = Object.assign({}, startTime);
      obj[sudoScource] = cssObj;
      setAttributes({
        startTime: obj
      });
      var selector = myStore.getElementSelector(sudoScource, startTimeSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleendTime(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, endTime);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        endTime: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, endTimeSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleendTime(sudoScource, key) {
      let obj = {
        ...endTime
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        endTime: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, endTimeSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetendTime(sudoSources) {
      let obj = Object.assign({}, endTime);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, endTimeSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        endTime: obj
      });
    }
    function onAddStyleendTime(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, endTime);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        endTime: object
      });
    }
    function onBulkAddendTime(sudoScource, cssObj) {
      let obj = Object.assign({}, endTime);
      obj[sudoScource] = cssObj;
      setAttributes({
        endTime: obj
      });
      var selector = myStore.getElementSelector(sudoScource, endTimeSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleclosed(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, closed);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        closed: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, closedSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleclosed(sudoScource, key) {
      let obj = {
        ...closed
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        closed: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, closedSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetclosed(sudoSources) {
      let obj = Object.assign({}, closed);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, closedSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        closed: obj
      });
    }
    function onAddStyleclosed(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, closed);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        closed: object
      });
    }
    function onBulkAddclosed(sudoScource, cssObj) {
      let obj = Object.assign({}, closed);
      obj[sudoScource] = cssObj;
      setAttributes({
        closed: obj
      });
      var selector = myStore.getElementSelector(sudoScource, closedSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleseparator(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleseparator(sudoScource, key) {
      let obj = {
        ...separator
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        separator: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetseparator(sudoSources) {
      let obj = Object.assign({}, separator);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        separator: obj
      });
    }
    function onAddStyleseparator(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        separator: object
      });
    }
    function onBulkAddseparator(sudoScource, cssObj) {
      let obj = Object.assign({}, separator);
      obj[sudoScource] = cssObj;
      setAttributes({
        separator: obj
      });
      var selector = myStore.getElementSelector(sudoScource, separatorSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleitems(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, items);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        items: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemsSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleitems(sudoScource, key) {
      let obj = {
        ...items
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        items: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemsSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetitems(sudoSources) {
      let obj = Object.assign({}, items);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, itemsSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        items: obj
      });
    }
    function onAddStyleitems(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, items);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        items: object
      });
    }
    function onBulkAdditems(sudoScource, cssObj) {
      let obj = Object.assign({}, items);
      obj[sudoScource] = cssObj;
      setAttributes({
        items: obj
      });
      var selector = myStore.getElementSelector(sudoScource, itemsSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleItem(sudoScource, newVal, attr, obj, extra) {
      var index = extra.index;
      var path = [sudoScource, attr, breakPointX];
      let objX = Object.assign({}, obj);
      const object = myStore.updatePropertyDeep(objX, path, newVal);
      var elementsX = {
        ...elements
      };
      elementsX.items[index] = object;
      setAttributes({
        elements: elementsX
      });
      var selector = `${blockClass} .item-${index}`;
      //setAttributes({ obj: object });
      var elementSelector = myStore.getElementSelector(sudoScource, selector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsCssX = Object.assign({}, blockCssY.items);
      if (itemsCssX[elementSelector] == undefined) {
        itemsCssX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsCssX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleItem(sudoScource, key, obj, extra) {
      var index = extra.index;
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      var elementsX = {
        ...elements
      };
      elementsX.items[index] = object;
      setAttributes({
        elements: elementsX
      });
      var selector = `${blockClass} .item-${index}`;
      var elementSelector = myStore.getElementSelector(sudoScource, selector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onAddStyleItem(sudoScource, key, obj, extra) {
      var index = extra.index;
      var path = [sudoScource, key, breakPointX];
      let objX = Object.assign({}, obj);
      const object = myStore.addPropertyDeep(objX, path, "");
      var elementsX = {
        ...elements
      };
      elementsX.items[index] = object;
      setAttributes({
        elements: elementsX
      });
      //setAttributes({ items: object });
      // setAttributes({ items: itemsX });
    }
    function onBulkAddItem(sudoScource, cssObj, extra) {
      var index = extra.index;
      var elementsX = {
        ...elements
      };
      var itemssX = elementsX.items[index];
      let obj = Object.assign({}, itemssX);
      obj[sudoScource] = cssObj;
      elementsX.items[index] = obj;
      setAttributes({
        elements: elementsX
      });
      var selectorX = `${blockClass} .item-${index}`;
      var selector = myStore.getElementSelector(sudoScource, selectorX);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onResetNthItem(sudoSources, extra) {
      const index = extra.index;
      var elementsX = {
        ...elements
      };
      var itemssX = elementsX.items[index];
      if (itemssX) {
        const obj = {
          ...itemssX
        };
        Object.entries(sudoSources).forEach(([sudoSource]) => {
          if (obj[sudoSource]) {
            obj[sudoSource] = {};
            const selector = `${blockClass} .item-${index}`;
            const elementSelector = myStore.getElementSelector(sudoSource, selector);
            const cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
            setAttributes({
              blockCssY: {
                items: cssObject
              }
            });
          }
        });
        elementsX.items[index] = obj;
        setAttributes({
          elements: elementsX
        });
      }
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class}`
    });
    //const isParentOfSelectedBlock = useSelect((select) => select('core/block-editor').hasSelectedInnerBlock(clientId, true))
    // const innerBlocksProps = useInnerBlocksProps(blockProps, {
    // 	directInsert: true,
    // 	templateInsertUpdatesSelection: true,
    // 	renderAppender: InnerBlocks.ButtonBlockAppender,
    // });
    // const hasInnerBlocks = useSelect(
    // 	(select) => select(blockEditorStore).getBlocks(clientId).length > 0,
    // 	[clientId]
    // );
    function onPickBlockVariation(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
    }
    const {
      replaceInnerBlocks
    } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.store);
    const TimeDisplay = ({
      time
    }) => {
      const formatTime = time => {
        const [hours, minutes] = time.split(":");
        let formattedHours = parseInt(hours, 10);
        const period = formattedHours >= 12 ? "PM" : "AM";
        formattedHours = formattedHours % 12 || 12; // Convert 0 to 12 for 12 AM
        return `${formattedHours}:${minutes} ${period}`;
      };
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", null, formatTime(time));
    };
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_21__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.id,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          id: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      },
      // { label: "a", value: "a" },
      {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), wrapper.options.tag == "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link To", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkToArgs,
      buttonTitle: wrapper.options.linkTo == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid") : linkToArgs[wrapper.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), wrapper.options.linkTo == "authorMeta" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Meta Key", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), wrapper.options.linkTo == "customField" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Meta Key", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), wrapper.options.linkTo == "customUrl" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Url", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : "",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), wrapper.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
      onClick: ev => {
        var options = {
          ...wrapper.options,
          customUrl: ""
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.__experimentalLinkControl, {
      settings: [],
      value: wrapper.options.customUrl,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          customUrl: newVal.url
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", wrapper.options.customUrl.length != 0 ? wrapper.options.customUrl : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No link", "post-grid"), " ")))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link Target", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.linkTarget,
      options: [{
        label: "_self",
        value: "_self"
      }, {
        label: "_blank",
        value: "_blank"
      }, {
        label: "_parent",
        value: "_parent"
      }, {
        label: "_top",
        value: "_top"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          linkTarget: newVal
        };
        setAttributes({
          text: {
            ...text,
            options: options
          }
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Items", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react_sortablejs__WEBPACK_IMPORTED_MODULE_23__.ReactSortable, {
      list: elements.items,
      handle: ".handle",
      setList: item => {
        setAttributes({
          elements: {
            ...elements,
            items: item
          }
        });
      }
    }, elements.items.map((item, index) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      key: item.id,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "handle cursor-pointer bg-gray-700 hover:bg-gray-600 hover:text-white px-1 py-1"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
        className: "mx-2"
      }, item.label)),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.label,
      onChange: newVal => {
        var elementX = {
          ...elements
        };
        var items = [...elements.items];
        items[index].label = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Time", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      type: "time",
      value: item.start ? item.start : startTime.options.start,
      onChange: newVal => {
        var elementX = {
          ...elements
        };
        var items = elementX.items;
        items[index].start = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("End Time", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      type: "time",
      value: item.end ? item.end : endTime.options.end,
      onChange: newVal => {
        var elementX = {
          ...elements
        };
        var items = elementX.items;
        items[index].end = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Closed?", "post-grid"),
      help: item.status ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Closed", "post-grid") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Open", "post-grid"),
      checked: item.status ? true : false,
      onChange: e => {
        var elementX = {
          ...elements
        };
        var items = elementX.items;
        items[index].status = !items[index].status;
        setAttributes({
          elements: {
            ...elements,
            items: items
          }
        });
      }
    })), item.status && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      for: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Closed Text", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.closeText ? item.closeText : closed.options.closeText,
      onChange: newVal => {
        var elementX = {
          ...elements
        };
        var itemsX = elementX.items;
        itemsX[index].closeText = newVal;
        setAttributes({
          elements: {
            ...elements,
            items: itemsX
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: item,
      extra: {
        index: index
      },
      onChange: onChangeStyleItem,
      onAdd: onAddStyleItem,
      onRemove: onRemoveStyleItem,
      onBulkAdd: onBulkAddItem,
      onReset: onResetNthItem
    })))))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: items,
      onChange: onChangeStyleitems,
      onAdd: onAddStyleitems,
      onRemove: onRemoveStyleitems,
      onBulkAdd: onBulkAdditems,
      onReset: onResetitems
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: items,
      onChange: onPickCssLibraryitems
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Label", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: label,
      onChange: onChangeStylelabel,
      onAdd: onAddStylelabel,
      onRemove: onRemoveStylelabel,
      onBulkAdd: onBulkAddlabel,
      onReset: onResetlabel
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: label,
      onChange: onPickCssLibrarylabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Times Wrap", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: timesWrap,
      onChange: onChangeStyletimesWrap,
      onAdd: onAddStyletimesWrap,
      onRemove: onRemoveStyletimesWrap,
      onBulkAdd: onBulkAddtimesWrap,
      onReset: onResettimesWrap
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: timesWrap,
      onChange: onPickCssLibrarytimesWrap
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Time", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Start Time", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      type: "time",
      value: startTime.options.start,
      onChange: newVal => {
        var options = {
          ...startTime.options,
          start: newVal
        };
        setAttributes({
          startTime: {
            ...startTime,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: startTime,
      onChange: onChangeStylestartTime,
      onAdd: onAddStylestartTime,
      onRemove: onRemoveStylestartTime,
      onBulkAdd: onBulkAddstartTime,
      onReset: onResetstartTime
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: startTime,
      onChange: onPickCssLibrarystartTime
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("End Time", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("End Time", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      type: "time",
      value: endTime.options.end,
      onChange: newVal => {
        var options = {
          ...endTime.options,
          end: newVal
        };
        setAttributes({
          endTime: {
            ...endTime,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: endTime,
      onChange: onChangeStyleendTime,
      onAdd: onAddStyleendTime,
      onRemove: onRemoveStyleendTime,
      onBulkAdd: onBulkAddendTime,
      onReset: onResetendTime
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: endTime,
      onChange: onPickCssLibraryendTime
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Separator", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Separator", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: separator.options.separator,
      onChange: newVal => {
        var options = {
          ...separator.options,
          separator: newVal
        };
        setAttributes({
          separator: {
            ...separator,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: separator,
      onChange: onChangeStyleseparator,
      onAdd: onAddStyleseparator,
      onRemove: onRemoveStyleseparator,
      onBulkAdd: onBulkAddseparator,
      onReset: onResetseparator
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: separator,
      onChange: onPickCssLibraryseparator
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Closed", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Closed Text", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: closed.options.closeText,
      onChange: newVal => {
        var options = {
          ...closed.options,
          closeText: newVal
        };
        setAttributes({
          closed: {
            ...closed,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: closed,
      onChange: onChangeStyleclosed,
      onAdd: onAddStyleclosed,
      onRemove: onRemoveStyleclosed,
      onBulkAdd: onBulkAddclosed,
      onReset: onResetclosed
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: closed,
      onChange: onPickCssLibraryclosed
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block Variations", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__["default"], {
      blockName: blockNameLast,
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockPatterns
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_14__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements.items[0].start.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-center my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "border border-solid border-gray-300 w-[95%] rounded-md p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Click to pick a variation", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "bg-gray-700 rounded-sm px-4 py-1 font-semibold text-lg text-white cursor-pointer",
      onClick: ev => {
        var content = '<!-- wp:post-grid/business-hours {"elements":{"options":{"tag":"div","class":"item"},"styles":{"display":{"Desktop":"flex"},"borderBottom":{"Desktop":"1px solid #fafafa"},"padding":{"Desktop":"11px 0px 10px 0px"},"alignItems":{"Desktop":"center"},"justifyContent":{"Desktop":"space-between"},"color":{"Desktop":"#3b3b3b"},"fontFamily":{"Desktop":"Poppins"},"fontSize":{"Desktop":"20px"},"fontWeight":{"Desktop":"500"}},"items":[{"id":"saturday","label":"Saturday","class":"business-hours-day","status":"true","start":"10:00","end":"","closeText":"","styles":{"color":{"Desktop":"#fa2d2d"}},"chosen":false,"selected":false},{"id":"sunday","label":"Sunday","class":"business-hours-day","status":"true","start":"","end":"","closeText":"","styles":{"color":{"Desktop":"#fa2d2d"}},"chosen":false,"selected":false},{"id":"monday","label":"Monday","class":"business-hours-day","status":"","start":"","end":"","closeText":"","styles":{},"chosen":false,"selected":false},{"id":"tuesday","label":"Tuesday","class":"business-hours-day","status":"","start":"","end":"","closeText":"","styles":{},"chosen":false,"selected":false},{"id":"wednesday","label":"Wednesday","class":"business-hours-day","status":"","start":"","end":"","closeText":"","styles":{},"chosen":false,"selected":false},{"id":"thursday","label":"Thursday","class":"business-hours-day","status":"","start":"","end":"","closeText":"","styles":{},"chosen":false,"selected":false},{"id":"friday","label":"Friday","class":"business-hours-day","status":"","start":"","end":"","closeText":"","styles":{},"chosen":false,"selected":false}]},"blockId":"pge3ad2b0434ac","blockCssY":{"items":{".pge3ad2b0434ac":{"background-color":{"Desktop":"#F1F7F9"},"padding":{"Desktop":"20px 20px 20px 20px"},"box-shadow":{"Desktop":"0px 10px 10px 0px #0000001a"}},".pge3ad2b0434ac .item":{"display":{"Desktop":"flex"},"border-bottom":{"Desktop":"1px solid #fafafa"},"padding":{"Desktop":"11px 0px 10px 0px"},"align-items":{"Desktop":"center"},"justify-content":{"Desktop":"space-between"},"color":{"Desktop":"#3b3b3b"},"font-family":{"Desktop":"Poppins"},"font-size":{"Desktop":"20px"},"font-weight":{"Desktop":"500"}},".pge3ad2b0434ac .label":{"margin-right":{"Desktop":"auto"}},".pge3ad2b0434ac .times-wrap":{"margin-left":{"Desktop":"auto"},"display":{"Desktop":"flex"},"justify-content":{"Desktop":"flex-end"},"gap":{"Desktop":"10px"}},".pge3ad2b0434ac .start-time":{"display":{"Desktop":"block"},"background-color":{"Desktop":"#F1F7F9"}},".pge3ad2b0434ac .end-time":{"display":{"Desktop":"block"},"background-color":{"Desktop":"#F1F7F9"}},".pge3ad2b0434ac .separator":{"display":{"Desktop":"block"},"background-color":{"Desktop":"#F1F7F9"}},".pge3ad2b0434ac .closed":{"color":{"Desktop":"#fa2d2d"}},".pge3ad2b0434ac .item-0:id":{"0":"s","1":"a","2":"t","3":"u","4":"r","5":"d","6":"a","7":"y"},".pge3ad2b0434ac .item-0:label":{"0":"S","1":"a","2":"t","3":"u","4":"r","5":"d","6":"a","7":"y"},".pge3ad2b0434ac .item-0:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"},".pge3ad2b0434ac .item-0:status":{"0":"t","1":"r","2":"u","3":"e"},".pge3ad2b0434ac .item-0:start":{"0":"1","1":"0","2":":","3":"0","4":"0"},".pge3ad2b0434ac .item-0:closeText":{"0":"a","1":"v","2":"c"},".pge3ad2b0434ac .item-0":{"color":{"Desktop":"#fa2d2d"}},".pge3ad2b0434ac .item-1:id":{"0":"s","1":"u","2":"n","3":"d","4":"a","5":"y"},".pge3ad2b0434ac .item-1:label":{"0":"S","1":"u","2":"n","3":"d","4":"a","5":"y"},".pge3ad2b0434ac .item-1:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"},".pge3ad2b0434ac .item-1:status":{"0":"t","1":"r","2":"u","3":"e"},".pge3ad2b0434ac .item-1":{"color":{"Desktop":"#fa2d2d"}},".pge3ad2b0434ac .item-2:id":{"0":"m","1":"o","2":"n","3":"d","4":"a","5":"y"},".pge3ad2b0434ac .item-2:label":{"0":"M","1":"o","2":"n","3":"d","4":"a","5":"y"},".pge3ad2b0434ac .item-2:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"},".pge3ad2b0434ac .item-3:id":{"0":"t","1":"u","2":"e","3":"s","4":"d","5":"a","6":"y"},".pge3ad2b0434ac .item-3:label":{"0":"T","1":"u","2":"e","3":"s","4":"d","5":"a","6":"y"},".pge3ad2b0434ac .item-3:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"},".pge3ad2b0434ac .item-4:id":{"0":"w","1":"e","2":"d","3":"n","4":"e","5":"s","6":"d","7":"a","8":"y"},".pge3ad2b0434ac .item-4:label":{"0":"W","1":"e","2":"d","3":"n","4":"e","5":"s","6":"d","7":"a","8":"y"},".pge3ad2b0434ac .item-4:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"},".pge3ad2b0434ac .item-5:id":{"0":"t","1":"h","2":"u","3":"r","4":"s","5":"d","6":"a","7":"y"},".pge3ad2b0434ac .item-5:label":{"0":"T","1":"h","2":"u","3":"r","4":"s","5":"d","6":"a","7":"y"},".pge3ad2b0434ac .item-5:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"},".pge3ad2b0434ac .item-6:id":{"0":"f","1":"r","2":"i","3":"d","4":"a","5":"y"},".pge3ad2b0434ac .item-6:label":{"0":"F","1":"r","2":"i","3":"d","4":"a","5":"y"},".pge3ad2b0434ac .item-6:class":{"0":"b","1":"u","2":"s","3":"i","4":"n","5":"e","6":"s","7":"s","8":"-","9":"h","10":"o","11":"u","12":"r","13":"s","14":"-","15":"d","16":"a","17":"y"}}}} /-->';
        wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
      }
    }, "Skip")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      ...blockProps,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_block_variations_picker__WEBPACK_IMPORTED_MODULE_22__["default"], {
      blockName: "business-hours",
      blockId: blockId,
      clientId: clientId,
      onChange: onPickBlockVariation
    }))))), elements.items[0].start.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagWrapper, {
      ...blockProps
    }, elements.items.map((x, index) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "item item-" + index,
      key: index
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "label"
    }, x.label), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "times-wrap"
    }, x.status ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "closed"
    }, x.closeText ? x.closeText : closed.options.closeText, " ") : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "start-time"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(TimeDisplay, {
      time: x.start ? x.start : startTime.options.start
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "separator"
    }, separator.options.separator), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "end-time"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(TimeDisplay, {
      time: x.end ? x.end : endTime.options.end
    })))))))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.Content, null);
    //return null;
  }
});

/***/ }),

/***/ "./src/blocks/chart/index.js":
/*!***********************************!*\
  !*** ./src/blocks/chart/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/media-and-text.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./block.json */ "./src/blocks/chart/block.json");
/* harmony import */ var _components_library_block_variations__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/library-block-variations */ "./src/components/library-block-variations/index.js");
/* harmony import */ var _components_form_field_conditions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/form-field-conditions */ "./src/components/form-field-conditions/index.js");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");
/* harmony import */ var _components_tooltip__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/tooltip */ "./src/components/tooltip/index.js");
/* harmony import */ var _components_tilt__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../components/tilt */ "./src/components/tilt/index.js");
/* harmony import */ var _components_animate_on__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../components/animate-on */ "./src/components/animate-on/index.js");
/* harmony import */ var _components_typing_text__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../components/typing-text */ "./src/components/typing-text/index.js");
/* harmony import */ var _components_chart_options__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../components/chart-options */ "./src/components/chart-options/index.js");














const {
  RawHTML
} = wp.element;


















var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_18__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M157.275 48.4749L82.63 5.675C81.0376 4.775 78.9477 4.775 77.3552 5.675L2.70979 48.4749C0.122083 49.9749 -0.773663 53.175 0.719246 55.775C1.21688 56.675 1.91343 57.375 2.80917 57.875L77.4546 98.075C79.0471 98.875 80.9382 98.875 82.5306 98.075L157.176 57.875C159.764 56.475 160.759 53.275 159.366 50.675C158.868 49.775 158.072 48.9749 157.275 48.4749ZM79.9428 87.275L16.345 53.075L79.9428 16.575L143.541 53.075L79.9428 87.275Z",
      fill: "url(#paint0_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M82.5306 126.175L154.588 86.3748V74.1748L79.9428 115.375L5.29736 74.1748V86.3748L77.3553 126.175C79.0472 127.075 80.9382 127.075 82.5306 126.175Z",
      fill: "url(#paint1_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M5.29736 115.675L77.4546 154.275C79.0471 155.075 80.9381 155.075 82.431 154.275L154.588 115.675V103.575L79.9428 143.575L5.29736 103.575V115.675Z",
      fill: "url(#paint2_linear_61_513)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_61_513",
      x1: "-0.00341797",
      y1: "51.8375",
      x2: "159.997",
      y2: "51.8375",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_61_513",
      x1: "5.29736",
      y1: "100.512",
      x2: "154.588",
      y2: "100.512",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint2_linear_61_513",
      x1: "5.29736",
      y1: "129.225",
      x2: "154.588",
      y2: "129.225",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  transforms: {
    from: [{
      type: "block",
      blocks: ["core/quote"],
      transform: (attributes, innerBlocks) => {
        return (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)("post-grid/layers", {
          wrapper: {
            options: {
              tag: "div",
              class: "pg-layers",
              id: "",
              linkTo: "postUrl",
              linkToAuthorMeta: "",
              linkToCustomMeta: "",
              linkTarget: "_blank",
              customUrl: ""
            }
          }
        }, innerBlocks);
      }
    }, {
      type: "block",
      blocks: ["core/buttons"],
      transform: (attributes, innerBlocks) => {
        var innerBlockX = innerBlocks.map((item, index) => {
          return {
            clientId: item.clientId,
            name: "post-grid/icon",
            innerBlocks: [],
            attributes: {
              wrapper: {
                options: {
                  tag: "div",
                  class: "pg-icon",
                  attr: []
                }
              },
              text: {
                options: {
                  enable: true,
                  text: "Custom Text",
                  src: "",
                  linkTo: "",
                  linkToAuthorMeta: "",
                  linkToCustomMeta: "",
                  linkTarget: "_blank",
                  customUrl: "",
                  linkAttr: [],
                  class: ""
                }
              },
              icon: {
                options: {
                  enable: true,
                  library: "fontAwesome",
                  srcType: "class",
                  iconSrc: "fas fa-check-circle",
                  position: "beforeText",
                  class: "text-icon"
                }
              },
              prefix: {
                options: {
                  text: "",
                  class: "prefix"
                }
              },
              postfix: {
                options: {
                  text: "",
                  class: "postfix"
                }
              },
              utmTracking: {
                enable: false,
                id: "",
                source: "",
                medium: "",
                campaign: "",
                term: "",
                content: ""
              },
              blockId: "",
              linkAttr: [],
              blockCssY: {
                items: {}
              }
            }
          };
        });
        return (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)("post-grid/layers", {
          wrapper: {
            options: {
              tag: "div",
              class: "pg-layers",
              id: "",
              linkTo: "postUrl",
              linkToAuthorMeta: "",
              linkToCustomMeta: "",
              linkTarget: "_blank",
              customUrl: ""
            }
          }
        }, innerBlockX);
      }
    }, {
      type: "block",
      blocks: ["post-grid/layer"],
      transform: (attributes, innerBlocks) => {
        return (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)("post-grid/layers", {
          wrapper: {
            options: {
              tag: "div",
              class: "pg-layers",
              id: "",
              linkTo: "postUrl",
              linkToAuthorMeta: "",
              linkToCustomMeta: "",
              linkTarget: "_blank",
              customUrl: ""
            }
          }
        }, innerBlocks);
      }
    }],
    to: [{
      type: "block",
      blocks: ["post-grid/grid-wrap"],
      transform: (attributes, innerBlocks) => {
        return (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)("post-grid/grid-wrap", {
          wrapper: {
            options: {
              tag: "div",
              class: "pg-grid-wrap"
            }
          }
        }, innerBlocks);
      }
    }, {
      type: "block",
      blocks: ["post-grid/info-box-item"],
      transform: (attributes, innerBlocks) => {
        return (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)("post-grid/info-box-item", {
          wrapper: {
            options: {
              tag: "div",
              class: "pg-info-box-item"
            }
          }
        }, innerBlocks);
      }
    }]
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var animation = attributes.animation;
    var legend = attributes.legend;
    var title = attributes.title;
    var subtitle = attributes.subtitle;
    var tooltip = attributes.tooltip;
    var layout = attributes.layout;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var conditions = attributes.conditions;
    var item = attributes.item;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    var breakPointX = myStore.getBreakPoint();
    var [optionData, setoptionData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({
      addons: {
        enabled: ["visibility", "animateOn", "tilt", "tooltip", "lightbox", "utmTracking", "lazyLoad"]
      }
    });
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)("postType", postType, "link", postId);
    var [postGridBlockEditor, setpostGridBlockEditor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)({}); // Using the hook.
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      setpostGridBlockEditor(window.postGridBlockEditor);
    }, [window.postGridBlockEditor]);
    // useEffect(() => {
    // 	apiFetch({
    // 		path: "/post-grid/v2/get_options",
    // 		method: "POST",
    // 		data: { option: "post_grid_block_editor" },
    // 	}).then((res) => {
    // 		if (res.length != 0) {
    // 			setoptionData({ ...res });
    // 		}
    // 	});
    // }, []);
    const CustomTagWrapper = `${wrapper.options.tag}`;
    var postUrl = wrapper.options.customUrl != undefined && wrapper.options.customUrl.length > 0 ? wrapper.options.customUrl : currentPostUrl;
    var linkToArgsBasic = {
      postUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Post URL", "post-grid"),
        value: "postUrl"
      },
      homeUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Home URL", "post-grid"),
        value: "homeUrl"
      },
      authorUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author URL", "post-grid"),
        value: "authorUrl"
      },
      authorLink: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Link", "post-grid"),
        value: "authorLink"
      },
      authorMail: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Mail", "post-grid"),
        value: "authorMail",
        isPro: true
      },
      authorMeta: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Meta", "post-grid"),
        value: "authorMeta",
        isPro: true
      },
      customField: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Field", "post-grid"),
        value: "customField",
        isPro: true
      },
      customUrl: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom URL", "post-grid"),
        value: "customUrl",
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)("linkToArgs", linkToArgsBasic);
    // Wrapper CSS Class Selectors
    var wrapperSelector = blockClass;
    var itemSelector = blockClass + " .pg-layer";
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/block-editor").getBlockRootClientId(clientId);
    function onPickBlockPatterns(content, action) {
      const {
        parse
      } = wp.blockSerializationDefaultParser;
      var blocks = content.length > 0 ? parse(content) : "";
      const attributes = blocks[0].attrs;
      if (action == "insert") {
        const position = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)("core/editor").getBlockInsertionPoint(parentClientId);
        wp.data.dispatch("core/block-editor").insertBlocks(wp.blocks.parse(content), position.index, position.rootClientId);
      }
      if (action == "applyStyle") {
        var wrapperX = attributes.wrapper;
        var itemX = attributes.item;
        var blockCssYX = attributes.blockCssY;
        var blockCssObj = {};
        if (wrapperX != undefined) {
          var wrapperY = {
            ...wrapperX,
            options: wrapper.options
          };
          setAttributes({
            wrapper: wrapperY
          });
          blockCssObj[wrapperSelector] = wrapperY;
        }
        if (itemX != undefined) {
          var itemY = {
            ...itemX,
            options: item.options
          };
          setAttributes({
            item: itemY
          });
          blockCssObj[itemSelector] = itemY;
        }
        var blockCssRules = myStore.getBlockCssRules(blockCssObj);
        var items = blockCssRules;
        setAttributes({
          blockCssY: {
            items: items
          }
        });
      }
      if (action == "replace") {
        if (confirm("Do you want to replace?")) {
          wp.data.dispatch("core/block-editor").replaceBlock(clientId, wp.blocks.parse(content));
        }
      }
    }
    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }
    function onPickCssLibraryLayers(args) {
      var textX = Object.assign({}, wrapper);
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        textX[sudoScource] = sudoScourceArgs;
      });
      setAttributes({
        wrapper: textX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var blockCssYX = {
        ...blockCssY
      };
      var items = {
        ...blockCssYX.items
      };
      var cssItems = Object.assign(items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function setFieldLinkTo(option, index) {
      var options = {
        ...wrapper.options,
        linkTo: option.value
      };
      setAttributes({
        wrapper: {
          ...wrapper,
          options: options
        }
      });
    }
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onChangeStyleItem(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, item);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        item: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onAddStyleItem(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, item);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        item: object
      });
    }
    function onBulkAddItem(sudoScource, cssObj) {
      let obj = Object.assign({}, item);
      obj[sudoScource] = cssObj;
      setAttributes({
        item: obj
      });
      var selector = myStore.getElementSelector(sudoScource, itemSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    function onResetItem(sudoSources) {
      let obj = Object.assign({}, item);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        item: obj
      });
    }
    function onRemoveStyleItem(sudoScource, key) {
      let obj = {
        ...item
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        item: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class}`
    });
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps)(blockProps, {
      directInsert: true,
      templateInsertUpdatesSelection: true,
      renderAppender: _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.ButtonBlockAppender
    });
    var legendProps = {
      display: {
        label: "Display",
        id: "display",
        value: true
      },
      position: {
        label: "Position",
        id: "position",
        value: "top"
      },
      align: {
        label: "Align",
        id: "align",
        value: "center"
      },
      maxHeight: {
        label: "Max Height",
        id: "maxHeight",
        value: null
      },
      maxWidth: {
        label: "Max Width",
        id: "maxWidth",
        value: null
      },
      fullSize: {
        label: "Full Size",
        id: "fullSize",
        value: true
      },
      reverse: {
        label: "Reverse",
        id: "reverse",
        value: false
      },
      rtl: {
        label: "RTL",
        id: "rtl",
        value: false
      },
      textDirection: {
        label: "Text Direction",
        id: "textDirection",
        value: "ltr"
      },
      labels: {
        label: "Labels",
        id: "labels",
        value: {}
      },
      title: {
        label: "Title",
        id: "title",
        value: {}
      }
    };
    var titleProps = {
      display: {
        label: "Display",
        id: "display",
        value: false
      },
      position: {
        label: "Position",
        id: "position",
        value: "top"
      },
      align: {
        label: "Align",
        id: "align",
        value: "center"
      },
      text: {
        label: "Text",
        id: "text",
        value: ""
      },
      padding: {
        label: "Padding",
        id: "padding",
        value: 10
      },
      color: {
        label: "Color",
        id: "color",
        value: "#666"
      },
      font: {
        label: "Font",
        id: "font",
        value: {
          family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
          size: 12,
          style: "normal",
          weight: "bold",
          lineHeight: 1.2
        }
      },
      fullSize: {
        label: "Full Size",
        id: "fullSize",
        value: true
      }
    };
    var subtitleProps = {
      display: {
        label: "Display",
        id: "display",
        value: false
      },
      position: {
        label: "Position",
        id: "position",
        value: "top"
      },
      align: {
        label: "Align",
        id: "align",
        value: "center"
      },
      text: {
        label: "Text",
        id: "text",
        value: ""
      },
      padding: {
        label: "Padding",
        id: "padding",
        value: 10
      },
      color: {
        label: "Color",
        id: "color",
        value: "#666"
      },
      font: {
        label: "Font",
        id: "font",
        value: {
          family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
          size: 12,
          style: "normal",
          weight: "bold",
          lineHeight: 1.2
        }
      },
      fullSize: {
        label: "Full Size",
        id: "fullSize",
        value: true
      }
    };
    var tooltipProps = {
      enabled: {
        label: "Enabled",
        id: "enabled",
        value: true
      },
      intersect: {
        label: "Intersect",
        id: "intersect",
        value: true
      },
      position: {
        label: "Position",
        id: "position",
        value: "average"
      },
      backgroundColor: {
        label: "Background Color",
        id: "backgroundColor",
        value: "rgba(0, 0, 0, 0.8)"
      },
      titleColor: {
        label: "Title Color",
        id: "titleColor",
        value: "#fff"
      },
      titleFont: {
        label: "Title Font",
        id: "titleFont",
        value: {
          family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
          size: 12,
          style: "normal",
          weight: "bold"
        }
      },
      titleAlign: {
        label: "Title Align",
        id: "titleAlign",
        value: "left"
      },
      titleSpacing: {
        label: "Title Spacing",
        id: "titleSpacing",
        value: 2
      },
      titleMarginBottom: {
        label: "Title Margin Bottom",
        id: "titleMarginBottom",
        value: 6
      },
      bodyColor: {
        label: "Body Color",
        id: "bodyColor",
        value: "#fff"
      },
      bodyFont: {
        label: "Body Font",
        id: "bodyFont",
        value: {
          family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
          size: 12,
          style: "normal",
          weight: "bold"
        }
      },
      bodyAlign: {
        label: "Body Align",
        id: "bodyAlign",
        value: "left"
      },
      bodySpacing: {
        label: "Body Spacing",
        id: "bodySpacing",
        value: 2
      },
      footerColor: {
        label: "Footer Color",
        id: "footerColor",
        value: "#fff"
      },
      footerFont: {
        label: "Footer Font",
        id: "footerFont",
        value: {
          family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
          size: 12,
          style: "normal",
          weight: "bold"
        }
      },
      footerAlign: {
        label: "Footer Align",
        id: "footerAlign",
        value: "left"
      },
      footerSpacing: {
        label: "Footer Spacing",
        id: "footerSpacing",
        value: 2
      },
      footerMarginTop: {
        label: "Footer Margin Top",
        id: "footerMarginTop",
        value: 6
      },
      padding: {
        label: "Padding",
        id: "padding",
        value: 6
      },
      caretPadding: {
        label: "Caret Padding",
        id: "caretPadding",
        value: 2
      },
      caretSize: {
        label: "Caret Size",
        id: "caretSize",
        value: 5
      },
      cornerRadius: {
        label: "Corner Radius",
        id: "cornerRadius",
        value: 6
      },
      multiKeyBackground: {
        label: "Multi Key Background",
        id: "multiKeyBackground",
        value: "#fff"
      },
      displayColors: {
        label: "Display Colors",
        id: "displayColors",
        value: true
      },
      boxPadding: {
        label: "Box Padding",
        id: "boxPadding",
        value: 0
      },
      usePointStyle: {
        label: "Use Point Style",
        id: "usePointStyle",
        value: false
      },
      borderColor: {
        label: "Border Color",
        id: "borderColor",
        value: "rgba(0, 0, 0, 0)"
      },
      borderWidth: {
        label: "Border Width",
        id: "borderWidth",
        value: 0
      },
      rtl: {
        label: "RTL",
        id: "rtl",
        value: false
      },
      textDirection: {
        label: "Text Direction",
        id: "textDirection",
        value: "ltr"
      },
      xAlign: {
        label: "X Align",
        id: "xAlign",
        value: undefined
      },
      yAlign: {
        label: "Y Align",
        id: "yAlign",
        value: undefined
      }
    };
    var layoutProps = {
      padding: {
        label: "Padding",
        id: "padding",
        value: {
          top: 0,
          right: 0,
          bottom: 0,
          left: 0
        }
      },
      autoPadding: {
        label: "Auto Padding",
        id: "autoPadding",
        value: true
      }
    };
    var animationProps = {
      animation: {
        label: "Animation",
        id: "animation",
        value: {
          duration: {
            label: "Duration",
            id: "duration",
            value: 1000
          },
          easing: {
            label: "Easing",
            id: "easing",
            value: "easeOutQuart"
          },
          delay: {
            label: "Delay",
            id: "delay",
            value: 0
          },
          loop: {
            label: "Loop",
            id: "loop",
            value: false
          }
        }
      },
      animations: {
        label: "Animations",
        id: "animations",
        value: {
          colors: {
            label: "Colors",
            id: "colors",
            value: {
              type: "color",
              properties: ["borderColor", "backgroundColor"]
            }
          },
          numbers: {
            label: "Numbers",
            id: "numbers",
            value: {
              type: "number",
              properties: ["x", "y", "borderWidth", "radius", "tension"]
            }
          }
        }
      },
      transitions: {
        label: "Transitions",
        id: "transitions",
        value: {
          active: {
            label: "Active",
            id: "active",
            value: {
              animation: {
                duration: 400
              }
            }
          },
          resize: {
            label: "Resize",
            id: "resize",
            value: {
              animation: {
                duration: 0
              }
            }
          },
          show: {
            label: "Show",
            id: "show",
            value: {
              animations: {
                colors: {
                  from: "transparent"
                },
                visible: {
                  type: "boolean",
                  from: false
                }
              }
            }
          },
          hide: {
            label: "Hide",
            id: "hide",
            value: {
              animations: {
                colors: {
                  to: "transparent"
                },
                visible: {
                  type: "boolean",
                  to: false
                }
              }
            }
          }
        }
      }
    };
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
        className: "tab-style"
      }, {
        name: "css",
        title: "CSS Library",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"],
        className: "tab-css"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_22__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.id,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          id: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "a",
        value: "a"
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), wrapper.options.tag == "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link To", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkToArgs,
      buttonTitle: wrapper.options.linkTo == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid") : linkToArgs[wrapper.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), wrapper.options.linkTo == "authorMeta" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Author Meta Key", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), wrapper.options.linkTo == "customField" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Meta Key", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    })), wrapper.options.linkTo == "customUrl" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Custom Url", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : "",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), wrapper.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
      onClick: ev => {
        var options = {
          ...wrapper.options,
          customUrl: ""
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.__experimentalLinkControl, {
      settings: [],
      value: wrapper.options.customUrl,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          customUrl: newVal.url
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", wrapper.options.customUrl.length != 0 ? wrapper.options.customUrl : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No link", "post-grid"), " ")))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Link Target", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.linkTarget,
      options: [{
        label: "_self",
        value: "_self"
      }, {
        label: "_blank",
        value: "_blank"
      }, {
        label: "_parent",
        value: "_parent"
      }, {
        label: "_top",
        value: "_top"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          linkTarget: newVal
        };
        setAttributes({
          text: {
            ...text,
            options: options
          }
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_12__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryLayers
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Item", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: item,
      onChange: onChangeStyleItem,
      onAdd: onAddStyleItem,
      onRemove: onRemoveStyleItem,
      onBulkAdd: onBulkAddItem,
      onReset: onResetItem
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Legend", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_chart_options__WEBPACK_IMPORTED_MODULE_27__["default"], {
      obj: legend,
      props: legendProps,
      objFor: "legend",
      onChange: prams => {
        setAttributes({
          legend: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Title", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_chart_options__WEBPACK_IMPORTED_MODULE_27__["default"], {
      obj: title,
      props: titleProps,
      objFor: "title",
      onChange: prams => {
        setAttributes({
          title: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Subtitle", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_chart_options__WEBPACK_IMPORTED_MODULE_27__["default"], {
      obj: subtitle,
      props: subtitleProps,
      objFor: "subtitle",
      onChange: prams => {
        setAttributes({
          subtitle: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Tooltip", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_chart_options__WEBPACK_IMPORTED_MODULE_27__["default"], {
      obj: tooltip,
      props: tooltipProps,
      objFor: "tooltip",
      onChange: prams => {
        setAttributes({
          tooltip: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Layout", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_chart_options__WEBPACK_IMPORTED_MODULE_27__["default"], {
      obj: layout,
      props: layoutProps,
      objFor: "layout",
      onChange: prams => {
        setAttributes({
          layout: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Animation", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_chart_options__WEBPACK_IMPORTED_MODULE_27__["default"], {
      obj: animation,
      props: animationProps,
      objFor: "animation",
      onChange: prams => {
        setAttributes({
          animation: prams
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      id: "PGEndOfPanels"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_13__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Visibility", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_visible__WEBPACK_IMPORTED_MODULE_14__["default"], {
      visible: visible,
      onChange: prams => {
        setAttributes({
          visible: prams
        });
      }
    })))), JSON.stringify(legend), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, wrapper.options.tag == "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("a", {
      ...innerBlocksProps,
      onClick: handleLinkClick,
      href: postUrl,
      target: wrapper.options.linkTarget
    }, innerBlocksProps.children), wrapper.options.tag != "a" && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(CustomTagWrapper, {
      ...innerBlocksProps
    }, innerBlocksProps.children)));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.Content, null);
    //return null;
  }
});

/***/ }),

/***/ "./src/blocks/content-slider-item/index.js":
/*!*************************************************!*\
  !*** ./src/blocks/content-slider-item/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _components_visible__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/visible */ "./src/components/visible/index.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./block.json */ "./src/blocks/content-slider-item/block.json");
/* harmony import */ var _components_css_class_picker__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-class-picker */ "./src/components/css-class-picker/index.js");
/* harmony import */ var _custom_tags__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../custom-tags */ "./src/custom-tags.js");











const {
  RawHTML
} = wp.element;












var myStore = wp.data.select("postgrid-shop");
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_18__, {
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: "#fff0",
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: "#fff",
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("svg", {
      width: "160",
      height: "160",
      viewBox: "0 0 160 160",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M28.9122 58H2.22402C1.63417 58 1.06848 58.2343 0.6514 58.6514C0.234316 59.0685 0 59.6342 0 60.224V82.4642C0 83.054 0.234316 83.6197 0.6514 84.0368C1.06848 84.4539 1.63417 84.6882 2.22402 84.6882H28.9122C29.5021 84.6882 30.0678 84.4539 30.4848 84.0368C30.9019 83.6197 31.1362 83.054 31.1362 82.4642V60.224C31.1362 59.6342 30.9019 59.0685 30.4848 58.6514C30.0678 58.2343 29.5021 58 28.9122 58ZM26.6882 80.2402H4.44803V62.448H26.6882V80.2402Z",
      fill: "url(#paint0_linear_67_1013)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M75.617 64.6719H40.0327V69.1199H75.617V64.6719Z",
      fill: "url(#paint1_linear_67_1013)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M66.7209 73.5679H40.0327V78.0159H66.7209V73.5679Z",
      fill: "url(#paint2_linear_67_1013)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M113.296 58H86.6073C86.0175 58 85.4518 58.2343 85.0347 58.6514C84.6176 59.0685 84.3833 59.6342 84.3833 60.224V82.4642C84.3833 83.054 84.6176 83.6197 85.0347 84.0368C85.4518 84.4539 86.0175 84.6882 86.6073 84.6882H113.296C113.885 84.6882 114.451 84.4539 114.868 84.0368C115.285 83.6197 115.52 83.054 115.52 82.4642V60.224C115.52 59.6342 115.285 59.0685 114.868 58.6514C114.451 58.2343 113.885 58 113.296 58ZM111.072 80.2402H88.8313V62.448H111.072V80.2402Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M160 64.6719H124.416V69.1199H160V64.6719Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("path", {
      d: "M151.104 73.5679H124.416V78.0159H151.104V73.5679Z",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("circle", {
      cx: "80",
      cy: "98.6885",
      r: "4",
      fill: "#C15940"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("circle", {
      cx: "98",
      cy: "98.6885",
      r: "4",
      fill: "url(#paint3_linear_67_1013)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("circle", {
      cx: "62",
      cy: "98.6885",
      r: "4",
      fill: "url(#paint4_linear_67_1013)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint0_linear_67_1013",
      x1: "0",
      y1: "71.3441",
      x2: "31.1362",
      y2: "71.3441",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint1_linear_67_1013",
      x1: "40.0327",
      y1: "66.8959",
      x2: "75.617",
      y2: "66.8959",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint2_linear_67_1013",
      x1: "40.0327",
      y1: "75.7919",
      x2: "66.7209",
      y2: "75.7919",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint3_linear_67_1013",
      x1: "94",
      y1: "98.6885",
      x2: "102",
      y2: "98.6885",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("linearGradient", {
      id: "paint4_linear_67_1013",
      x1: "58",
      y1: "98.6885",
      x2: "66",
      y2: "98.6885",
      gradientUnits: "userSpaceOnUse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      stopColor: "#FC7F64"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("stop", {
      offset: "1",
      stopColor: "#FF9D42"
    }))))
  },
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockName = props.name;
    var blockNameLast = blockName.split("/")[1];
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : "pg" + clientId.split("-").pop();
    var blockClass = "." + blockIdX;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var blockCssY = attributes.blockCssY;
    var postId = context["postId"];
    var postType = context["postType"];
    var breakPointX = myStore.getBreakPoint();
    // Wrapper CSS Class Selectors
    var wrapperSelector = blockClass;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockIdX = "pg" + clientId.split("-").pop();
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var blockCssObj = {};
      blockCssObj[wrapperSelector] = wrapper;
      var blockCssRules = myStore.getBlockCssRules(blockCssObj);
      var items = blockCssRules;
      setAttributes({
        blockCssY: {
          items: items
        }
      });
    }, [blockId]);
    function generateElementSudoCss(obj) {
      var stylesObj = {};
      Object.entries(obj).map(args => {
        var sudoSrc = args[0];
        var sudoArgs = args[1];
        if (sudoSrc != "options") {
          var selector = myStore.getElementSelector(sudoSrc, wrapperSelector);
          Object.entries(args[1]).map(x => {
            var attr = x[0];
            var cssPropty = myStore.cssAttrParse(attr);
            if (stylesObj[selector] == undefined) {
              stylesObj[selector] = {};
            }
            if (stylesObj[selector][cssPropty] == undefined) {
              stylesObj[selector][cssPropty] = {};
            }
            stylesObj[selector][cssPropty] = x[1];
          });
        }
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      var elementCss = generateElementSudoCss(wrapper);
    }, [wrapper]);
    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);
      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }
      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }
    function onRemoveStyleWrapper(sudoScource, key) {
      let obj = {
        ...wrapper
      };
      var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
      var isEmpty = Object.entries(object[sudoScource][key]).length == 0 ? true : false;
      var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
      setAttributes({
        wrapper: objectX
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      var isEmptyX = cssObject[cssPropty] == undefined ? false : true;
      var cssObjectX = isEmptyX ? myStore.deletePropertyDeep(cssObject, [cssPropty]) : cssObject;
      setAttributes({
        blockCssY: {
          items: cssObjectX
        }
      });
    }
    function onResetWrapper(sudoSources) {
      let obj = Object.assign({}, wrapper);
      Object.entries(sudoSources).map(args => {
        var sudoScource = args[0];
        if (obj[sudoScource] == undefined) {} else {
          obj[sudoScource] = {};
          var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
          var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector]);
          setAttributes({
            blockCssY: {
              items: cssObject
            }
          });
        }
      });
      setAttributes({
        wrapper: obj
      });
    }
    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, "");
      setAttributes({
        wrapper: object
      });
    }
    function onBulkAddWrapper(sudoScource, cssObj) {
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);
        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }
        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }
        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = {
        ...blockCssY.items
      };
      var cssItemsX = {
        ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId);
    }, [blockCssY]);
    const MY_TEMPLATE = [
      //['core/paragraph', { placeholder: '', content: 'Hello Text...' }],
    ];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps)({
      className: ` ${blockId} ${wrapper.options.class} splide__slide `
    });
    //const isParentOfSelectedBlock = useSelect((select) => select('core/block-editor').hasSelectedInnerBlock(clientId, true))
    // const ALLOWED_BLOCKS = ["post-grid/terms-query-item"];
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps)(blockProps, {
      // allowedBlocks: ALLOWED_BLOCKS,
      template: MY_TEMPLATE,
      //orientation: 'horizontal',
      templateInsertUpdatesSelection: true,
      renderAppender: _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InnerBlocks.ButtonBlockAppender
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("div", {
      className: "pg-setting-input-text"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_toggle__WEBPACK_IMPORTED_MODULE_16__["default"], {
      className: "font-medium text-slate-900 ",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper", "post-grid"),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "options",
        title: "Options",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: "tab-settings"
      }, {
        name: "styles",
        title: "Styles",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: "tab-style"
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_css_class_picker__WEBPACK_IMPORTED_MODULE_19__["default"], {
      tags: _custom_tags__WEBPACK_IMPORTED_MODULE_20__["default"],
      label: "CSS Class",
      placeholder: "Add Class",
      value: wrapper.options.class,
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Block ID", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: blockId,
      disabled: true,
      onChange: newVal => {
        setAttributes({
          blockId: newVal
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("label", {
      htmlFor: "",
      className: "font-medium text-slate-900 "
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Wrapper Tag", "post-grid")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Choose", "post-grid"),
        value: ""
      }, {
        label: "H1",
        value: "h1"
      }, {
        label: "H2",
        value: "h2"
      }, {
        label: "H3",
        value: "h3"
      }, {
        label: "H4",
        value: "h4"
      }, {
        label: "H5",
        value: "h5"
      }, {
        label: "H6",
        value: "h6"
      }, {
        label: "SPAN",
        value: "span"
      }, {
        label: "DIV",
        value: "div"
      }, {
        label: "P",
        value: "p"
      }],
      onChange: newVal => {
        var options = {
          ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_12__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_13__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper,
      onReset: onResetWrapper
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)("li", {
      ...innerBlocksProps
    }, innerBlocksProps.children));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var visible = attributes.visible;
    var blockId = attributes.blockId;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useBlockProps.save({
      className: ` ${blockId} pg-content-slider-item`
    });
    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children);
  }
});

/***/ }),

/***/ "./src/blocks/content-slider/index.js":
/*!********************************************!*\
  !*** ./src/blocks/content-slider/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = 