<?php

/** 
 * Kaya Studio - Admin Dashboard Class
 * Manages Kaya Studio admin main page for plugins.
 *
 * @version 1.0.1
 */

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly
}

if (!class_exists('WP_KayaStudio_Plugins_Admin_Dashboard'))
{
	class WP_KayaStudio_Plugins_Admin_Dashboard
	{
		/**
		 * Menu Page Slug
		 */
		public static $_pageSlug = 'kayastudio-plugins-admin-main-page';

		/**
		 * Main Initialisation
		 * Adds admin menu and enqueue scripts.
		 */
		public static function init()
		{
			add_action('admin_menu', array(__CLASS__, 'addAdminMenuPage'));
			add_action('admin_enqueue_scripts', array(__CLASS__, 'addAdminCssJs'));
		}

		/**
		 * Adds admin main menu
		 * Adds a top-level menu and a submenu for Kaya Studio admin main page.
		 */
		public static function addAdminMenuPage()
		{
			if (!self::checkAdminMenuItem(self::$_pageSlug))
			{
				// add main page
				add_menu_page(
					'Kaya Studio',
					'Kaya Studio',
					'edit_posts',
					self::$_pageSlug,
					array(__CLASS__, 'doAdminMainPage'),
					'data:image/svg+xml;base64,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',
					'150'
				);
				add_submenu_page(
					self::$_pageSlug,
					'Kaya Studio',
					'Kaya Studio',
					'edit_posts',
					self::$_pageSlug,
					array(__CLASS__, 'doAdminMainPage')
				);
			}
		}

		/**
		 * Displays admin main page
		 * Includes the main page and display it.
		 */
		public static function doAdminMainPage()
		{
			if (is_file(plugin_dir_path(__FILE__) . '../includes/kayastudio-admin-page.php'))
			{
				include_once plugin_dir_path(__FILE__) . '../includes/kayastudio-admin-page.php';
				kayastudio_plugins_admin_doMainPage();
			}
		}

		/**
		 * Adds admin main menu styles and scripts
		 * Registers and enqueue styles and scripts for Kaya Studio admin main page.
		 *
		 * @param int $hook Hook suffix for the current admin page.
		 */
		public static function addAdminCssJs($hook)
		{
			if (isset($hook) && !empty($hook) && get_plugin_page_hookname(self::$_pageSlug, self::$_pageSlug) === $hook)
			{
				wp_register_style('kayastudio_wp_admin_css', plugin_dir_url(__FILE__) . '../css/kayastudio-admin-page-pkg.min.css', false, '1.0.0');
				wp_enqueue_style('kayastudio_wp_admin_css');
			}
		}

		/**
		 * Checks menu items.
		 * Finds if the slug is present as item in administration menu.
		 *
		 * @return bool
		 */
		public static function checkAdminMenuItem($handle, $sub = false)
		{
			if (!is_admin() || (defined('DOING_AJAX') && DOING_AJAX))
				return false;

			global $menu, $submenu;
			$check_menu = $sub ? $submenu : $menu;

			if (empty($check_menu))
				return false;

			foreach ($check_menu as $k => $item)
			{
				if ($sub)
				{
					foreach ($item as $sm)
					{
						if ($handle == $sm[2])
							return true;
					}
				}
				else
				{
					if ($handle == $item[2])
						return true;
				}
			}

			return false;
		}
	}
}
