<?php

require_once "DatabaseConnection.php";

class CustomQueries 
{ 
 
    private $DB;
    
    public function __construct($host, $user, $password, $database)
    {
        $this->DB = new DatabaseConnection($host, $user, $password, $database); 

        $this->DB->connect();
    }

    function showCasas($casa = 0, $type = 2)
    {
        $res = $this->getCasas($type);
        $data1[0] = "";
        foreach($res as $key=>$data)
        {
            $menu_item = 301 + $key;
            if(intval($key) === intval($casa))
            {
                $class ="class=\"menu-item menu-item-type-post_type menu-item-object-page current-menu-item page_item page-item-288 current_page_item menu-item-{$menu_item} active\"";
                $class ="class=\"menu-item menu-item-type-post_type menu-item-object-page current-menu-item page_item page-item-288 current_page_item menu-item-{$menu_item} active\"";
                $classLink = 'aria-current="page"';
            }
            else
            {
                $class = "class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-{$menu_item}\"";
                $classLink = '';
            }                
            $data1[0] .= " <li id=\"menu-item-301\"{$class}>
            <a href=\"https://salesianos.space/secretaria/miembros/?casa={$key}\" {$classLink}><span>{$data}</span></a>
            </li>".PHP_EOL;
        }
        $data1[1] = $res;
        return $data1;

    }

    function showUserxCasa($casa)
    {
        $result = "";
        $res = $this->getUsrxCasa($casa, 2);
        $user_id = -1;
        $result .=  "<table border=1>\n";
        $result .=  "<tr>\n<th>Apellidos</th>\n<th>Nombres</th>\n";
        foreach($res as $key=>$data)
        {
            // print_r($data);
            if($data["usd_usr_id"] !== $user_id)
            {
                $user_id =$data["usd_usr_id"];
                $result .=   "\t<tr bgcolor=''>\n";
            }
            if($data["usd_usf_id"] === "1")
                $result .=   "\t \t<td>".$data["usd_value"]."</td>\n";
            if($data["usd_usf_id"] === "2")
                $result .=   "\t \t<td>".$data["usd_value"]."</td>\n</tr>\n";    
        }
        $result .=   "</table>";        
        return $result;
    }

    function generateUserBox($data)
    {
        $result ="         
            <div onclick=\"\" class=\"team_member team-member u-trans-all-2s eluidd50653df hidden-zn_dummy_value hidden-zn_dummy_value hidden-zn_dummy_value hidden-zn_dummy_value 
            zn-anim-fadeIn zn-anim-duration--1000 teambox--light element-scheme--light teambox-style--hover is-animating\" data-anim-delay=\"700ms\" style=\"animation-delay: 700ms;\">".PHP_EOL."
            <a href=\"#\" class=\"grayHover team-member-link\" target=\"_self\" itemprop=\"url\">".PHP_EOL."
            <img class=\"team-member-img\" src=\"{$data["photo"]}\" width=\"120\" height=\"120\" >".PHP_EOL."
            </a>".PHP_EOL."
            <h4 class=\"team-member-name\" itemscope=\"itemscope\" itemtype=\"https://schema.org/Person\">{$data["miembro"]}</h4>".PHP_EOL."
            <h6 class=\"team-member-pos\">Cualificación: {$data["Cualif"]}</h6>".PHP_EOL."
            <div class=\"details team-member-details\">".PHP_EOL."
            <div class=\"desc team-member-desc\"><p>Fecha Nacimiento: {$data["fechaNac"]}</p></div></div>".PHP_EOL."
            <!-- end details -->
            </div>".PHP_EOL;
        return $result;

    }


    function showBoxUser($records, $modo = 1)
    {

        $result = "";
        if($modo == 2)
            $result = $this->tableHeader(0);
        $usuario = [
            "user_id" => -1,
            "uuid" => "",
            "nombre" => "",
            "apellido" => "",
            "fechaNac" => "",
            "genero" => 1,
            "Cualif" => "",
            "telefono" => ""
        ];
        $non = false;
        $cualifArray = $this->getcualificacion();
        
        foreach($records as $key=>$data)
        {
           
            if($data["usd_usr_id"] !== $usuario["user_id"])
            {
                if($usuario["user_id"] !== -1)
                {
                    $cssSombreado = "style=\"background-color: #ffffff;\"";
                    if($non)
                        $cssSombreado = "style=\"background-color: #f2f2f2;\"";
                    $non = !$non;
                    $fa_gen = ($usuario["genero"] === 1) ? "mars" : "venus";
                    $gen_desc = ($usuario["genero"] === 1) ? "Masculino" : "Femenino";
            
                    $usuario["photo"] = "https://salesianos.space/secretaria/adm/adm_program/modules/profile/profile_photo_show.php?user_uuid={$usuario["uuid"]}";
                    $usuario["miembro"] = $usuario["nombre"]." ".$usuario["apellido"]."<i class=\"fas fa-{$fa_gen}  fa-fw\" data-toggle=\"tooltip\"  data-original-title=\"{$gen_desc}\"></i>";
                    if($modo == 1)
                        $result .= $this->generateUserBox($usuario);
                    if($modo == 2)
                        $result .= $this->showTableUser($usuario, $cssSombreado);

                }
                $usuario = [
                    "user_id" => $data["usd_usr_id"],
                    "uuid" => $data["usr_uuid"],
                    "nombre" => "",
                    "apellido" => "",
                    "fechaNac" => "",
                    "genero" => 1,
                    "Cualif" => "",
                    "telefono" => ""
                ];
            }
            
            switch($data["usd_usf_id"])
            {
                case 1: $usuario["apellido"] = $data["usd_value"];
                        break;
                case 2: $usuario["nombre"]  = $data["usd_value"];
                        break;
                case 7: $usuario["telefono"]  = $data["usd_value"];
                        break;                                                        
                case 9: $usuario["fechaNac"]  = $data["usd_value"];
                        break;
                case 10: $usuario["genero"]  = $data["usd_value"];
                        break;        
                case 23: $usuario["Cualif"]  = $cualifArray[intval($data["usd_value"])-1];
                        break;                                              
            }

        }
        if($modo == 2)
            $result .= $this->tableHeader(1);
        return $result;
    }

    function tableHeader($footer=0)
    {
        $result =   "</tbody></table>  ";  
        if($footer==0)
        {
            $result =  "<table  style=\"border: none; border-collapse: collapse; width: 100%;\">\n";
            $col_style = " style=\"border: none; text-align: center; vertical-align: middle; padding: 10px;\"";
            $result .=  "<thead>\n<tr>\n<th {$col_style} ><h2>Nombres y Apellidos</h2></th>\n
                         <th {$col_style}><h2>Cargo</h2></th>\n
                         <th {$col_style}><h2>Contacto</h2></th>\n
                         <th {$col_style}><h2>Foto</h2></th>\n</tr>\n</thead>\n<tbody>\n";
        }
        return $result;

    }
  

    function showTableUser($data, $Csssombreado)
    {
        $col_style = " style=\"border: none; text-align: center; vertical-align: middle; padding: 10px;\"";
        return  "            <tr {$Csssombreado}>
                                    <td {$col_style}>{$data["miembro"]} </td>
                                    <td {$col_style}>{$data["Cualif"]} </td>
                                    <td {$col_style}>{$data["telefono"]} </td>
                                    <td {$col_style}><a href=\"#\" class=\"grayHover team-member-link\" target=\"_self\" itemprop=\"url\">".PHP_EOL."
                                         <img class=\"team-member-img\" src=\"{$data["photo"]}\" width=\"120\" height=\"120\" >".PHP_EOL."
                                        </a>
                                    </td>";                                                                                                            
    }

    function showUserCasas($casa, $type=2, $modo = 1)
    {
        $res = $this->getUsrxCasa($casa, $type);
        return $this->showBoxUser($res, $modo);



        
    }

    
    function getCasas($type=1)
    {
        if($type === 1)
            $type_casa = 'CASA';
        else
            $type_casa = 'CASA_2';
        $query = "select * from adm_user_fields where usf_name_intern='{$type_casa}'";
        $result =$this->DB->query2Array($query);

        $casas = $result[0]["usf_value_list"];
        $arrayCasas = explode("\n", $casas);
          return $arrayCasas;
  //     return $result;
    }

    
    function getcualificacion()
    {
        $query = "select * from adm_user_fields where usf_id=23";
        $result =$this->DB->query2Array($query);

        $resultf = $result[0]["usf_value_list"];
        $arrayCualf = explode("\n", $resultf);
          return $arrayCualf;
  //     return $result;
    }    
    
    function getUsrxCasa($casa_id, $type=1)
    {
        if($type === 1)
            $type_casa = 24;
        else
            $type_casa = 32;
        $casa_id = $casa_id + 1;
        //$query = "select * from adm_user_data where usd_usr_id in (select usd_usr_id from adm_user_data where usd_usf_id={$type_casa} and usd_value={$casa_id})";
        $query = "select d.*, u.usr_uuid from adm_user_data d, adm_users u where  d.usd_usr_id=u.usr_id and d.usd_usr_id in 
                (select usd_usr_id from adm_user_data where usd_usf_id={$type_casa} and usd_value={$casa_id}) order by d.usd_usr_id, d.usd_usf_id;";

        $result =$this->DB->query2Array($query);
        return $result;
        
    }
    
    function getUserData($id)
    {
        $query = "select * from adm_user_data where usd_usr_id=$id";
        $result =$this->DB->query2Array($query);
        return $result;
    }
}
// $casa = isset($_GET["casa"]) && !empty($_GET["casa"]) ? $_GET["casa"] : 0;
// $g_adm_srv  = 'localhost';     // Host
// $g_adm_port = null;     // Port
// $g_adm_db   = 'sa13sp4s_adm';     // Database-Name
// $g_adm_usr  = 'sa13sp4s_adm'; // Username
// $g_adm_pw   = '=2&.6bez!p2E'; // Password



