<?php
if (!defined('ABSPATH')) exit;  // if direct access

add_filter('post_grid_layout_elements', 'post_grid_pro_wck_layout_elements', 5);

function post_grid_pro_wck_layout_elements($elements_group)
{

    $elements_group['wck'] = array(
        'group_title' => 'WCK - Custom Fields Creator',
        'items' => array(
            'wck_text' => array('name' => __('Text', 'post-grid')),
            'wck_textarea' => array('name' => __('Textarea', 'post-grid')),
            'wck_number' => array('name' => __('Number', 'post-grid')),
            //            'wck_range'=>array('name' =>__('Range','post-grid')),
            //            'wck_email'=>array('name' =>__('Email','post-grid')),
            //            'wck_url'=>array('name' =>__('URL','post-grid')),
            //            'wck_password'=>array('name' =>__('Password','post-grid')),


            //            'wck_link'=>array('name' =>__('Link','post-grid')),
            //            'wck_post_object'=>array('name' =>__('Post object','post-grid')),
            //            'wck_page_link'=>array('name' =>__('Page link','post-grid')),
            //            'wck_taxonomy'=>array('name' =>__('Taxonomy','post-grid')),
            //            'wck_user'=>array('name' =>__('User','post-grid')),
            //            'wck_relationship'=>array('name' =>__('Relationship','post-grid')),

            'wck_upload' => array('name' => __('Upload', 'post-grid')),
            //            'wck_file'=>array('name' =>__('File','post-grid')),
            'wck_wysiwyg' => array('name' => __('Wysiwyg', 'post-grid')),
            //            'wck_oembed'=>array('name' =>__('oEmbed','post-grid')),

            'wck_select' => array('name' => __('Select', 'post-grid')),
            'wck_checkbox' => array('name' => __('Checkbox', 'post-grid')),
            'wck_radio' => array('name' => __('Radio', 'post-grid')),
            //            'wck_buttongroup'=>array('name' =>__('Button group','post-grid')),
            //            'wck_true_false'=>array('name' =>__('True / False','post-grid')),

            //            'wck_date_picker'=>array('name' =>__('Date picker','post-grid')),
            'wck_time_picker' => array('name' => __('Time picker', 'post-grid')),
            //            'wck_datetime_picker'=>array('name' =>__('Datetime picker','post-grid')),
            //            'wck_google_map'=>array('name' =>__('Google Map','post-grid')),
            //'wck_colorpicker'=>array('name' =>__('Color picker','post-grid')),


        ),
    );

    return $elements_group;
}




add_action('post_grid_layout_element_option_wck_text', 'post_grid_layout_element_option_wck_text');
function post_grid_layout_element_option_wck_text($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Text', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_text',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_text]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_text', 'post_grid_layout_element_wck_text');
function post_grid_layout_element_wck_text($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_text ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_text', 'post_grid_layout_element_css_wck_text', 10);
function post_grid_layout_element_css_wck_text($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}





add_action('post_grid_layout_element_option_wck_textarea', 'post_grid_layout_element_option_wck_textarea');
function post_grid_layout_element_option_wck_textarea($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Textarea', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_textarea',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_textarea]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_textarea', 'post_grid_layout_element_wck_textarea');
function post_grid_layout_element_wck_textarea($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_textarea ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_textarea', 'post_grid_layout_element_css_wck_textarea', 10);
function post_grid_layout_element_css_wck_textarea($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}





add_action('post_grid_layout_element_option_wck_number', 'post_grid_layout_element_option_wck_number');
function post_grid_layout_element_option_wck_number($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Number', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_number',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_number]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_number', 'post_grid_layout_element_wck_number');
function post_grid_layout_element_wck_number($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_number ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_number', 'post_grid_layout_element_css_wck_number', 10);
function post_grid_layout_element_css_wck_number($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_email', 'post_grid_layout_element_option_wck_email');
function post_grid_layout_element_option_wck_email($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Email', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Email: &lt;a href="mailto:%s">Send mail&lt;/a></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Email: %s',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_email',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_email]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_email', 'post_grid_layout_element_wck_email');
function post_grid_layout_element_wck_email($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = isset($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_email ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_email', 'post_grid_layout_element_css_wck_email', 10);
function post_grid_layout_element_css_wck_email($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_url', 'post_grid_layout_element_option_wck_url');
function post_grid_layout_element_option_wck_url($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = isset($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK URL', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Link: &lt;a href="%s">Visit link&lt;/a></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Link: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_url',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_url]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_url', 'post_grid_layout_element_wck_url');
function post_grid_layout_element_wck_url($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);



    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);
    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_url ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_url', 'post_grid_layout_element_css_wck_url', 10);
function post_grid_layout_element_css_wck_url($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_range', 'post_grid_layout_element_option_wck_range');
function post_grid_layout_element_option_wck_range($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Range', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>value: %s</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_range',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_range]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_range', 'post_grid_layout_element_wck_range');
function post_grid_layout_element_wck_range($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_range ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_range', 'post_grid_layout_element_css_wck_range', 10);
function post_grid_layout_element_css_wck_range($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_wysiwyg', 'post_grid_layout_element_option_wck_wysiwyg');
function post_grid_layout_element_option_wck_wysiwyg($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Wysiwyg', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_wysiwyg',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_wysiwyg]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_wysiwyg', 'post_grid_layout_element_wck_wysiwyg');
function post_grid_layout_element_wck_wysiwyg($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);



    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_wysiwyg ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_wysiwyg', 'post_grid_layout_element_css_wck_wysiwyg', 10);
function post_grid_layout_element_css_wck_wysiwyg($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_upload', 'post_grid_layout_element_option_wck_upload');
function post_grid_layout_element_option_wck_upload($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = isset($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Image', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Value: %s</code>,<br> Return type: File URL<br> <code>File: &lt;a href="%s">Click to Download&lt;/a> </code> <br> Return type: File ID<br> <code>File id: %s</code> <br> Return type: File Array<br> <code>Link HTML: &lt;a href="{url}">{filename}&lt;/a> </code> <br> <code>Image HTML: &lt;img src="{url}"/> </code> <br>Parameter<br> <code>{ID}, {id}, {title}, {filename}, {filesize}, {url}, {link}, {alt}, {author}, {description}, {caption}, {name}, {date}, {mime_type}, {icon},{width}, {height} </code> <br>Sizes parameter:<br> <code>{sizes_$id} => {sizes_thumbnail}</code><br><code> {sizes_$id-width} => {sizes_thumbnail-width}</code><br><code> {sizes_$id-height} => {sizes_thumbnail-height}</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Image: %s',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_upload',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_upload]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_upload', 'post_grid_layout_element_wck_upload');
function post_grid_layout_element_wck_upload($args)
{


    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $attachment_id = get_post_meta($post_id, $wck_key, true);




    if (!empty($attachment_id)) :

        $wck_value = wp_get_attachment_metadata($attachment_id);


        if (is_array($wck_value)) {


            $sizes = isset($wck_value['sizes']) ? $wck_value['sizes'] : array();
            $sizes_arr = array();
            foreach ($sizes as $sizeIndex => $size) {
                $sizes_arr['{sizes_' . $sizeIndex . '}'] = $size;
            }



            $vars = array(
                '{ID}' => $attachment_id,
                '{id}' => $attachment_id,
                '{title}' => isset($wck_value['title']) ? $wck_value['title'] : '',
                '{filename}' => isset($wck_value['filename']) ? $wck_value['filename'] : '',
                '{filesize}' => isset($wck_value['filesize']) ? number_format($wck_value['filesize'] / 1008, 2) . 'KB' : '',
                '{url}' => wp_get_attachment_image_url($attachment_id),
                '{link}' => isset($wck_value['link']) ? $wck_value['link'] : '',
                '{alt}' => isset($wck_value['alt']) ? $wck_value['alt'] : '',
                '{author}' => isset($wck_value['author']) ? $wck_value['author'] : '',
                '{description}' => isset($wck_value['description']) ? $wck_value['description'] : '',
                '{caption}' => isset($wck_value['caption']) ? $wck_value['caption'] : '',
                '{name}' => isset($wck_value['name']) ? $wck_value['name'] : '',
                '{date}' => isset($wck_value['date']) ? $wck_value['date'] : '',
                '{mime_type}' => isset($wck_value['mime_type']) ? $wck_value['mime_type'] : '',
                '{icon}' => isset($wck_value['icon']) ? $wck_value['icon'] : '',
                '{width}' => isset($wck_value['width']) ? $wck_value['width'] : '',
                '{height}' => isset($wck_value['height']) ? $wck_value['height'] : '',
            );

            $vars = array_merge($vars, $sizes_arr);


            $wck_value = strtr($wrapper_html, $vars);
        } else {
            $wck_value = sprintf($wrapper_html, $wck_value);
        }


    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_file ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_upload', 'post_grid_layout_element_css_wck_upload', 10);
function post_grid_layout_element_css_wck_upload($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_file', 'post_grid_layout_element_option_wck_file');
function post_grid_layout_element_option_wck_file($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = isset($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK File', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Value: %s</code>,<br> Return type: File URL<br> <code>File: &lt;a href="%s">Click to Download&lt;/a> </code> <br> Return type: File ID<br> <code>File id: %s</code> <br> Return type: File Array<br> <code>Link HTML: &lt;a href="{url}">{filename}&lt;/a> </code> <br> <code>Image HTML: &lt;img src="{url}"/> </code> <br>Parameter<br> <code>{ID}, {id}, {title}, {filename}, {filesize}, {url}, {link}, {alt}, {author}, {description}, {caption}, {name}, {date}, {mime_type}, {icon},{width}, {height} </code> <br>Sizes parameter:<br> <code>{sizes_$id} => {sizes_thumbnail}</code><br><code> {sizes_$id-width} => {sizes_thumbnail-width}</code><br><code> {sizes_$id-height} => {sizes_thumbnail-height}</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_file',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_file]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_file', 'post_grid_layout_element_wck_file');
function post_grid_layout_element_wck_file($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);


    if (!empty($wck_value)) :

        if (is_array($wck_value)) {


            $sizes = isset($wck_value['sizes']) ? $wck_value['sizes'] : array();
            $sizes_arr = array();
            foreach ($sizes as $sizeIndex => $size) {
                $sizes_arr['{sizes_' . $sizeIndex . '}'] = $size;
            }

            $vars = array(
                '{ID}' => isset($wck_value['ID']) ? $wck_value['ID'] : '',
                '{id}' => isset($wck_value['id']) ? $wck_value['id'] : '',
                '{title}' => isset($wck_value['title']) ? $wck_value['title'] : '',
                '{filename}' => isset($wck_value['filename']) ? $wck_value['filename'] : '',
                '{filesize}' => isset($wck_value['filesize']) ? number_format($wck_value['filesize'] / 1008, 2) . 'KB' : '',
                '{url}' => isset($wck_value['url']) ? $wck_value['url'] : '',
                '{link}' => isset($wck_value['link']) ? $wck_value['link'] : '',
                '{alt}' => isset($wck_value['alt']) ? $wck_value['alt'] : '',
                '{author}' => isset($wck_value['author']) ? $wck_value['author'] : '',
                '{description}' => isset($wck_value['description']) ? $wck_value['description'] : '',
                '{caption}' => isset($wck_value['caption']) ? $wck_value['caption'] : '',
                '{name}' => isset($wck_value['name']) ? $wck_value['name'] : '',
                '{date}' => isset($wck_value['date']) ? $wck_value['date'] : '',
                '{mime_type}' => isset($wck_value['mime_type']) ? $wck_value['mime_type'] : '',
                '{icon}' => isset($wck_value['icon']) ? $wck_value['icon'] : '',
                '{width}' => isset($wck_value['width']) ? $wck_value['width'] : '',
                '{height}' => isset($wck_value['height']) ? $wck_value['height'] : '',

            );

            $vars = array_merge($vars, $sizes_arr);



            $wck_value = strtr($wrapper_html, $vars);
        } else {
            $wck_value = sprintf($wrapper_html, $wck_value);
        }


    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_file ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_file', 'post_grid_layout_element_css_wck_file', 10);
function post_grid_layout_element_css_wck_file($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_select', 'post_grid_layout_element_option_wck_select');
function post_grid_layout_element_option_wck_select($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $item_wrapper_html = !empty($element_data['item_wrapper_html']) ? $element_data['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Select', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'item_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Item wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, use <code>%s</code> to replace output. <br>Return Format: Label or Value<br> ex: <code>Value: %s</code> <br>Return Format: Both(Array)<br> ex: <code>Label: %s</code> <code>Value: %s</code> list item ex: <code>&lt;li>%s&lt;/li></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $item_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Value: %s</code>, <code>Values: %s</code> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_select',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_select]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_select', 'post_grid_layout_element_wck_select');
function post_grid_layout_element_wck_select($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $item_wrapper_html = !empty($element['item_wrapper_html']) ? $element['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);



    $html = '';

    if (!empty($wck_value)) :

        if (is_array($wck_value)) {
            foreach ($wck_value as $_items) {
                $html .= sprintf($item_wrapper_html, $_items);
            }
        } else {
            $html = sprintf($item_wrapper_html, $wck_value);
        }


        $html = sprintf($wrapper_html, $html);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_select ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_select', 'post_grid_layout_element_css_wck_select', 10);
function post_grid_layout_element_css_wck_select($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_checkbox', 'post_grid_layout_element_option_wck_checkbox');
function post_grid_layout_element_option_wck_checkbox($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $item_wrapper_html = !empty($element_data['item_wrapper_html']) ? $element_data['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Checkbox', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'item_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Item wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, use <code>%s</code> to replace output. <br>Return Format: Label or Value<br> ex: <code>Value: %s</code> <br>Return Format: Both(Array)<br> ex: <code>Label: %s</code> <code>Value: %s</code> list item ex: <code>&lt;li>%s&lt;/li></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $item_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Value: %s</code>, <code>Values: %s</code> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_checkbox',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_checkbox]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_checkbox', 'post_grid_layout_element_wck_checkbox');
function post_grid_layout_element_wck_checkbox($args)
{


    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $item_wrapper_html = !empty($element['item_wrapper_html']) ? $element['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    $html = '';

    if (!empty($wck_value)) :

        if (is_array($wck_value)) {
            foreach ($wck_value as $_items) {
                $html .= sprintf($item_wrapper_html, $_items);
            }
        } else {
            $html = sprintf($item_wrapper_html, $wck_value);
        }


        $html = sprintf($wrapper_html, $html);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_checkbox ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_checkbox', 'post_grid_layout_element_css_wck_checkbox', 10);
function post_grid_layout_element_css_wck_checkbox($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_radio', 'post_grid_layout_element_option_wck_radio');
function post_grid_layout_element_option_wck_radio($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $item_wrapper_html = !empty($element_data['item_wrapper_html']) ? $element_data['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Radio', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'item_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Item wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, use <code>%s</code> to replace output. <br>Return Format: Label or Value<br> ex: <code>Value: %s</code> list item ex: <code>&lt;li>%s&lt;/li></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $item_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Value: %s</code>, <code>Values: %s</code> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_radio',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_radio]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_radio', 'post_grid_layout_element_wck_radio');
function post_grid_layout_element_wck_radio($args)
{


    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $item_wrapper_html = !empty($element['item_wrapper_html']) ? $element['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);



    $html = '';

    if (!empty($wck_value)) :

        if (is_array($wck_value)) {


            if (is_array($wck_value)) {
                $value = $wck_value['value'];
                $label = $wck_value['label'];

                //$html .= $label.$value;
                $html .= sprintf($item_wrapper_html, $label, $value);
            } else {
                $html .= sprintf($wrapper_html, $wck_value);
            }
        } else {
            $html = sprintf($item_wrapper_html, $wck_value);
        }


        $html = sprintf($wrapper_html, $html);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_radio ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_radio', 'post_grid_layout_element_css_wck_radio', 10);
function post_grid_layout_element_css_wck_radio($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_buttongroup', 'post_grid_layout_element_option_wck_buttongroup');
function post_grid_layout_element_option_wck_buttongroup($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $item_wrapper_html = !empty($element_data['item_wrapper_html']) ? $element_data['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Button group', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'item_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Item wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, use <code>%s</code> to replace output. <br>Return Format: Label or Value<br> ex: <code>Value: %s</code> <br>list item ex: <code>&lt;li>%1$s : %2$s&lt;/li></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $item_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Links: %s</code>, <code>Values: %s</code> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_buttongroup',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_buttongroup]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_buttongroup', 'post_grid_layout_element_wck_buttongroup');
function post_grid_layout_element_wck_buttongroup($args)
{


    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $item_wrapper_html = !empty($element['item_wrapper_html']) ? $element['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);



    $html = '';

    if (!empty($wck_value)) :

        if (is_array($wck_value)) {


            if (is_array($wck_value)) {
                $value = $wck_value['value'];
                $label = $wck_value['label'];

                //$html .= $label.$value;
                $html .= sprintf($item_wrapper_html, $label, $value);
            } else {
                $html .= sprintf($wrapper_html, $wck_value);
            }
        } else {
            $html = sprintf($item_wrapper_html, $wck_value);
        }


        $html = sprintf($wrapper_html, $html);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_buttongroup ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_buttongroup', 'post_grid_layout_element_css_wck_buttongroup', 10);
function post_grid_layout_element_css_wck_buttongroup($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_page_link', 'post_grid_layout_element_option_wck_page_link');
function post_grid_layout_element_option_wck_page_link($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $link_wrapper_html = !empty($element_data['link_wrapper_html']) ? $element_data['link_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Page link', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'link_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Link wrapper html', 'post-grid'),
                'details'    => __('Write link wrapper html, use <code>%s</code> to replace output. ex: <code>&lt;a href="%s">Visit link&lt;/a></code> list item ex: <code>&lt;li>&lt;a href="%s">Visit link&lt;/a>&lt;/li></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $link_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Link: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Links: %s</code>, <code>&lt;a href="%s">Visit link&lt;/a></code> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Link: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_page_link',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_page_link]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_page_link', 'post_grid_layout_element_wck_page_link');
function post_grid_layout_element_wck_page_link($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $link_wrapper_html = !empty($element['link_wrapper_html']) ? $element['link_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);



    if (!empty($wck_value)) :
        $html = '';

        if (is_array($wck_value)) :
            foreach ($wck_value as $link) :

                $html .= sprintf($link_wrapper_html, $link);

            endforeach;
        else :
            $html = $wck_value;

        endif;



        $html = sprintf($wrapper_html, $html);
    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_page_link ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_page_link', 'post_grid_layout_element_css_wck_page_link', 10);
function post_grid_layout_element_css_wck_page_link($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_taxonomy', 'post_grid_layout_element_option_wck_taxonomy');
function post_grid_layout_element_option_wck_taxonomy($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $item_wrapper_html = !empty($element_data['item_wrapper_html']) ? $element_data['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Taxonomy', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'item_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Item wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, <br> <code>Link HTML: &lt;a href="{term_link}">{name}&lt;/a> </code> <br> <code>List HTML: &lt;li>&lt;a href="{term_link}">{name}&lt;/a>&lt;/li> </code>  <br>Parameter<br> <code>{term_id}, {term_link},{name}, {term_group}, {slug},{term_taxonomy_id}, {taxonomy}, {description}, {count} </code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $item_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Tags: %s</code>, <br> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Link: %s',
            );

            $settings_tabs_field->generate_field($args);



            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_taxonomy',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_taxonomy]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_taxonomy', 'post_grid_layout_element_wck_taxonomy');
function post_grid_layout_element_wck_taxonomy($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $item_wrapper_html = !empty($element['item_wrapper_html']) ? $element['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';




    $wck_value = get_post_meta($post_id, $wck_key, true);



    if (!empty($wck_value)) :

        $term_html = '';
        foreach ($wck_value as $term) {

            //echo esc_html($item_wrapper_html);

            if (is_object($term)) {
                $vars = array(
                    '{term_id}' => isset($term->term_id) ? $term->term_id : '',
                    '{term_link}' => get_term_link($term->term_id),
                    '{name}' => isset($term->name) ? $term->name : '',
                    '{slug}' => isset($term->slug) ? $term->slug : '',
                    '{term_taxonomy_id}' => isset($term->term_taxonomy_id) ? $term->term_taxonomy_id : '',
                    '{taxonomy}' => isset($term->taxonomy) ? $term->taxonomy : '',
                    '{description}' => isset($term->description) ? $term->description : '',
                    '{count}' => isset($term->count) ? $term->count : '',
                );

                $term_html .= strtr($item_wrapper_html, $vars);
            } else {
                $term_html .= sprintf($item_wrapper_html, $term);
            }
        }



        $html = sprintf($wrapper_html, $term_html);


    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_taxonomy ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_taxonomy', 'post_grid_layout_element_css_wck_taxonomy', 10);
function post_grid_layout_element_css_wck_taxonomy($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_user', 'post_grid_layout_element_option_wck_user');
function post_grid_layout_element_option_wck_user($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK User', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, <br> <code>Link HTML: &lt;a href="{user_posts_url}">{display_name}&lt;/a> </code> <br>Parameter<br> <code>{ID}, {user_login},{user_nicename}, {user_email}, {user_url},{display_name}, {user_posts_url}, {user_avtar} </code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_user',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_user]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_user', 'post_grid_layout_element_wck_user');
function post_grid_layout_element_wck_user($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);




    if (!empty($wck_value)) :

        if (is_object($wck_value)) {

            $vars = array(
                '{ID}' => isset($wck_value->ID) ? $wck_value->ID : '',
                '{user_login}' => isset($wck_value->user_login) ? $wck_value->user_login : '',
                '{user_nicename}' => isset($wck_value->user_nicename) ? $wck_value->user_nicename : '',
                '{user_email}' => isset($wck_value->user_email) ? $wck_value->user_email : '',
                '{user_url}' => isset($wck_value->user_url) ? $wck_value->user_url : '',
                '{display_name}' => isset($wck_value->display_name) ? $wck_value->display_name : '',
                '{user_posts_url}' => get_author_posts_url($wck_value->ID),
                '{user_avtar}' => get_avatar($wck_value->ID),


            );

            $html = strtr($wrapper_html, $vars);
        } elseif (is_array($wck_value)) {
        } else {
            $html = sprintf($wrapper_html, $wck_value);
        }

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_user ">
            <?php echo esc_html($html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_user', 'post_grid_layout_element_css_wck_user', 10);
function post_grid_layout_element_css_wck_user($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}




add_action('post_grid_layout_element_option_wck_date_picker', 'post_grid_layout_element_option_wck_date_picker');
function post_grid_layout_element_option_wck_date_picker($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Date picker', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Date: %s</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_date_picker',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_date_picker]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_date_picker', 'post_grid_layout_element_wck_date_picker');
function post_grid_layout_element_wck_date_picker($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);
    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_date_picker ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_date_picker', 'post_grid_layout_element_css_wck_date_picker', 10);
function post_grid_layout_element_css_wck_date_picker($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}





add_action('post_grid_layout_element_option_wck_time_picker', 'post_grid_layout_element_option_wck_time_picker');
function post_grid_layout_element_option_wck_time_picker($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Time picker', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Date: %s</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_time_picker',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_time_picker]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_time_picker', 'post_grid_layout_element_wck_time_picker');
function post_grid_layout_element_wck_time_picker($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_time_picker ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_time_picker', 'post_grid_layout_element_css_wck_time_picker', 10);
function post_grid_layout_element_css_wck_time_picker($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}




add_action('post_grid_layout_element_option_wck_datetime_picker', 'post_grid_layout_element_option_wck_datetime_picker');
function post_grid_layout_element_option_wck_datetime_picker($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Datetime picker', 'post-grid'); ?> -
                <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Date: %s</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_datetime_picker',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_datetime_picker]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_datetime_picker', 'post_grid_layout_element_wck_datetime_picker');
function post_grid_layout_element_wck_datetime_picker($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_datetime_picker ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_datetime_picker', 'post_grid_layout_element_css_wck_datetime_picker', 10);
function post_grid_layout_element_css_wck_datetime_picker($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_google_map', 'post_grid_layout_element_option_wck_google_map');
function post_grid_layout_element_option_wck_google_map($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Google map', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_google_map',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_google_map]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_google_map', 'post_grid_layout_element_wck_google_map');
function post_grid_layout_element_wck_google_map($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_google_map ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_google_map', 'post_grid_layout_element_css_wck_google_map', 10);
function post_grid_layout_element_css_wck_google_map($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}




add_action('post_grid_layout_element_option_wck_colorpicker', 'post_grid_layout_element_option_wck_colorpicker');
function post_grid_layout_element_option_wck_colorpicker($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Color picker', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_colorpicker',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_colorpicker]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_colorpicker', 'post_grid_layout_element_wck_colorpicker');
function post_grid_layout_element_wck_colorpicker($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_colorpicker ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_colorpicker', 'post_grid_layout_element_css_wck_colorpicker', 10);
function post_grid_layout_element_css_wck_colorpicker($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_link', 'post_grid_layout_element_option_wck_link');
function post_grid_layout_element_option_wck_link($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = isset($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Link', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Link: %s</code> or <code>Link: &lt;a href="%s">Visit link&lt/a> </code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Link: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_link',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_link]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_link', 'post_grid_layout_element_wck_link');
function post_grid_layout_element_wck_link($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';




    $wck_value = get_post_meta($post_id, $wck_key, true);



    if (!empty($wck_value)) :

        if (is_array($wck_value)) :
            $title = isset($wck_value['title']) ? $wck_value['title'] : '';
            $url = isset($wck_value['url']) ? $wck_value['url'] : '';
            $target = isset($wck_value['target']) ? $wck_value['target'] : '';

            $wck_value = "<a target='$target' href='$url'>$title</a>";

        endif;

        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_link ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_link', 'post_grid_layout_element_css_wck_link', 10);
function post_grid_layout_element_css_wck_link($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_post_object', 'post_grid_layout_element_option_wck_post_object');
function post_grid_layout_element_option_wck_post_object($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Text', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_post_object',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_post_object]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_post_object', 'post_grid_layout_element_wck_post_object');
function post_grid_layout_element_wck_post_object($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_post_object ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_post_object', 'post_grid_layout_element_css_wck_post_object', 10);
function post_grid_layout_element_css_wck_post_object($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_oembed', 'post_grid_layout_element_option_wck_oembed');
function post_grid_layout_element_option_wck_oembed($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Text', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_oembed',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_oembed]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_oembed', 'post_grid_layout_element_wck_oembed');
function post_grid_layout_element_wck_oembed($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_oembed ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_oembed', 'post_grid_layout_element_css_wck_oembed', 10);
function post_grid_layout_element_css_wck_oembed($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_password', 'post_grid_layout_element_option_wck_password');
function post_grid_layout_element_option_wck_password($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Text', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Pass: %s</code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Password: %s',
            );

            $settings_tabs_field->generate_field($args);



            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_password',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_password]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_password', 'post_grid_layout_element_wck_password');
function post_grid_layout_element_wck_password($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';





    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_password ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_password', 'post_grid_layout_element_css_wck_password', 10);
function post_grid_layout_element_css_wck_password($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}


add_action('post_grid_layout_element_option_wck_relationship', 'post_grid_layout_element_option_wck_relationship');
function post_grid_layout_element_option_wck_relationship($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $item_wrapper_html = !empty($element_data['item_wrapper_html']) ? $element_data['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Relationship', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'item_wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Item wrapper html', 'post-grid'),
                'details'    => __('Write item wrapper html, list item example <br>Post title <code>&lt;li>{post_title}&lt;/li></code><br> Title link: <code>&lt;li>&lt;a href="{permalink}">{post_title}&lt;/a> &lt;/li></code> <br> Post parameters<br> {ID}, {post_author}, {post_date}, {post_date_gmt}, {post_content}, {post_title}, {post_excerpt}, {post_status}, {comment_status}, {ping_status},{post_password}, {post_name}, {post_type}, {comment_count}, {permalink}', 'post-grid'),
                'type'        => 'text',
                'value'        => $item_wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Value: %s</code>, <code>Values: %s</code> list item wrapper ex: <code>&lt;ul>%s&lt;/ul></code>', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_relationship',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_relationship]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_relationship', 'post_grid_layout_element_wck_relationship');
function post_grid_layout_element_wck_relationship($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $item_wrapper_html = !empty($element['item_wrapper_html']) ? $element['item_wrapper_html'] : '%s';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';




    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :





        $post_html = '';

        foreach ($wck_value as $post_item) :

            $vars = array(
                '{ID}' => isset($post_item->ID) ? $post_item->ID : '',
                '{post_author' => isset($post_item->post_author) ? $post_item->post_author : '',
                '{post_date}' => isset($post_item->post_date) ? $post_item->post_date : '',
                '{post_date_gmt}' => isset($post_item->post_date_gmt) ? $post_item->post_date_gmt : '',
                '{post_content}' => isset($post_item->post_content) ? $post_item->post_content : '',
                '{post_title}' => isset($post_item->post_title) ? $post_item->post_title : '',
                '{post_excerpt}' => isset($post_item->post_excerpt) ? $post_item->post_excerpt : '',
                '{post_status}' => isset($post_item->post_status) ? $post_item->post_status : '',
                '{comment_status}' => isset($post_item->comment_status) ? $post_item->comment_status : '',
                '{ping_status}' => isset($post_item->ping_status) ? $post_item->ping_status : '',
                '{post_password}' => isset($post_item->post_password) ? $post_item->post_password : '',
                '{post_name}' => isset($post_item->post_name) ? $post_item->post_name : '',
                '{post_type}' => isset($post_item->post_type) ? $post_item->post_type : '',
                '{comment_count}' => isset($post_item->comment_count) ? $post_item->comment_count : '',
                '{permalink}' => get_permalink($post_item->ID),

            );

            $post_html .= strtr($item_wrapper_html, $vars);


        endforeach;

        $post_html = sprintf($wrapper_html, $post_html);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_relationship ">
            <?php echo esc_html($post_html); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_relationship', 'post_grid_layout_element_css_wck_relationship', 10);
function post_grid_layout_element_css_wck_relationship($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}



add_action('post_grid_layout_element_option_wck_true_false', 'post_grid_layout_element_option_wck_true_false');
function post_grid_layout_element_option_wck_true_false($parameters)
{

    $settings_tabs_field = new settings_tabs_field();

    $input_name = isset($parameters['input_name']) ? $parameters['input_name'] : '{input_name}';
    $element_data = isset($parameters['element_data']) ? $parameters['element_data'] : array();
    $element_index = isset($parameters['index']) ? $parameters['index'] : '';

    $wck_key = isset($element_data['wck_key']) ? $element_data['wck_key'] : '';
    $wrapper_html = !empty($element_data['wrapper_html']) ? $element_data['wrapper_html'] : '%s';

    $color = isset($element_data['color']) ? $element_data['color'] : '';
    $font_size = isset($element_data['font_size']) ? $element_data['font_size'] : '';
    $font_family = isset($element_data['font_family']) ? $element_data['font_family'] : '';
    $margin = isset($element_data['margin']) ? $element_data['margin'] : '';
    $text_align = isset($element_data['text_align']) ? $element_data['text_align'] : '';

    $css = isset($element_data['css']) ? $element_data['css'] : '';
    $css_hover = isset($element_data['css_hover']) ? $element_data['css_hover'] : '';



?>
    <div class="item">
        <div class="element-title header ">
            <span class="remove" onclick="jQuery(this).parent().parent().remove()"><i class="fas fa-times"></i></span>
            <span class="sort"><i class="fas fa-sort"></i></span>

            <span class="expand"><?php echo __('WCK Text', 'post-grid'); ?> - <?php echo esc_html($wck_key); ?></span>
        </div>
        <div class="element-options options">

            <?php

            $args = array(
                'id'        => 'wck_key',
                'css_id'        => $element_index . '_text',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('WCK key', 'post-grid'),
                'details'    => __('Write WCK meta key or field name.', 'post-grid'),
                'type'        => 'text',
                'value'        => $wck_key,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'wrapper_html',
                'css_id'        => $element_index . '_wrapper_html',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Wrapper html', 'post-grid'),
                'details'    => __('Write wrapper html, use <code>%s</code> to replace output. ex: <code>Values: %s</code> <code>Is true: Yes</code> ', 'post-grid'),
                'type'        => 'text',
                'value'        => $wrapper_html,
                'default'        => '',
                'placeholder'        => 'Value: %s',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'color',
                'css_id'        => $element_index . '_wck_true_false',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Color', 'post-grid'),
                'details'    => __('Title text color.', 'post-grid'),
                'type'        => 'colorpicker',
                'value'        => $color,
                'default'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'font_size',
                'css_id'        => $element_index . '_font_size',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Font size', 'post-grid'),
                'details'    => __('Set font size.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_size,
                'default'        => '',
                'placeholder'        => '14px',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'font_family',
                'css_id'        => $element_index . '_font_family',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Font family', 'post-grid'),
                'details'    => __('Set font family.', 'post-grid'),
                'type'        => 'text',
                'value'        => $font_family,
                'default'        => '',
                'placeholder'        => 'Open Sans',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'margin',
                'css_id'        => $element_index . '_margin',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Margin', 'post-grid'),
                'details'    => __('Set margin.', 'post-grid'),
                'type'        => 'text',
                'value'        => $margin,
                'default'        => '',
                'placeholder'        => '5px 0',
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'text_align',
                'css_id'        => $element_index . '_text_align',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Text align', 'post-grid'),
                'details'    => __('Choose text align.', 'post-grid'),
                'type'        => 'select',
                'value'        => $text_align,
                'default'        => 'left',
                'args'        => array('left' => __('Left', 'post-grid'), 'right' => __('Right', 'post-grid'), 'center' => __('Center', 'post-grid')),
            );

            $settings_tabs_field->generate_field($args);


            $args = array(
                'id'        => 'css',
                'css_id'        => $element_index . '_css',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Custom CSS', 'post-grid'),
                'details'    => __('Set csutom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);

            $args = array(
                'id'        => 'css_hover',
                'css_id'        => $element_index . '_css_hover',
                'parent' => $input_name . '[wck_true_false]',
                'title'        => __('Hover CSS', 'post-grid'),
                'details'    => __('Set hover custom CSS.', 'post-grid'),
                'type'        => 'textarea',
                'value'        => $css_hover,
                'default'        => '',
                'placeholder'        => '',
            );

            $settings_tabs_field->generate_field($args);


            ob_start();
            ?>
            <textarea readonly type="text" onclick="this.select();">.element_<?php echo esc_attr($element_index); ?>{}</textarea>
            <?php

            $html = ob_get_clean();

            $args = array(
                'id'        => 'use_css',
                'title'        => __('Use of CSS', 'post-grid'),
                'details'    => __('Use following class selector to add custom CSS for this element.', 'post-grid'),
                'type'        => 'custom_html',
                'html'        => $html,

            );

            $settings_tabs_field->generate_field($args);

            ?>

        </div>
    </div>
    <?php

}



add_action('post_grid_layout_element_wck_true_false', 'post_grid_layout_element_wck_true_false');
function post_grid_layout_element_wck_true_false($args)
{

    $element  = isset($args['element']) ? $args['element'] : array();
    $elementIndex  = isset($args['index']) ? $args['index'] : '';
    $post_id = isset($args['post_id']) ? $args['post_id'] : '';

    if (empty($post_id)) return;

    $title = get_the_title($post_id);

    $custom_class = isset($element['custom_class']) ? $element['custom_class'] : '';
    $wck_key = isset($element['wck_key']) ? $element['wck_key'] : '';
    $wrapper_html = !empty($element['wrapper_html']) ? $element['wrapper_html'] : '%s';
    $boolean_html = !empty($element['boolean_html']) ? $element['boolean_html'] : '';






    $wck_value = get_post_meta($post_id, $wck_key, true);

    if (!empty($wck_value)) :
        $wck_value = sprintf($wrapper_html, $wck_value);

    ?>
        <div class="element element_<?php echo esc_attr($elementIndex); ?> <?php echo esc_attr($custom_class); ?> wck_true_false ">
            <?php echo esc_html($wck_value); ?>
        </div>
    <?php
    endif;
}



add_action('post_grid_layout_element_css_wck_true_false', 'post_grid_layout_element_css_wck_true_false', 10);
function post_grid_layout_element_css_wck_true_false($args)
{


    $index = isset($args['index']) ? $args['index'] : '';
    $element = isset($args['element']) ? $args['element'] : array();
    $layout_id = isset($args['layout_id']) ? $args['layout_id'] : '';

    $color = isset($element['color']) ? $element['color'] : '';
    $font_size = isset($element['font_size']) ? $element['font_size'] : '';
    $font_family = isset($element['font_family']) ? $element['font_family'] : '';
    $margin = isset($element['margin']) ? $element['margin'] : '';
    $text_align = isset($element['text_align']) ? $element['text_align'] : 'left';

    $css = isset($element['css']) ? $element['css'] : '';
    $css_hover = isset($element['css_hover']) ? $element['css_hover'] : '';

    ?>
    <style type="text/css">
        .layout-<?php echo esc_attr($layout_id);
                ?>.element_<?php echo esc_attr($index);

                            ?> {
            <?php if (!empty($color)) : ?>color: <?php echo esc_attr($color);
                                                    ?>;
            <?php endif;
            ?><?php if (!empty($font_size)) : ?>font-size: <?php echo esc_attr($font_size);
                                                            ?>;
            <?php endif;
            ?><?php if (!empty($font_family)) : ?>font-family: <?php echo esc_attr($font_family);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($margin)) : ?>margin: <?php echo esc_attr($margin);
                                                        ?>;
            <?php endif;
            ?><?php if (!empty($text_align)) : ?>text-align: <?php echo esc_attr($text_align);
                                                                ?>;
            <?php endif;
            ?><?php if (!empty($css)) : ?><?php echo esc_attr($css);
                                            ?><?php endif;
                                                ?>
        }

        <?php if (!empty($css_hover)) : ?>.layout-<?php echo esc_attr($layout_id);
                                                    ?>.element_<?php echo esc_attr($index);

                                                                ?>:hover {
            <?php echo esc_attr($css_hover);
            ?>
        }

        <?php endif;
        ?>
    </style>
<?php
}
