(function($) {

	$.fn.beforeAfter = function( options ) {
		return this.each(function(e){
			new beforeAfter($(this), options);
		});
	}

	beforeAfter = function(element, options) {

		var dragBar;

		// DefaultSettings
		this.options = $.extend({
			auto     : true,
			position : 'vertical',
			revealOnClick: false
		}, options);

		dragBar = element.find('.beforeAfter-dragBar');

		element.addClass('beforeAfter--' + this.options.position );
		// Cache the active element
		this.activeElement = element;
		this.dragBar = dragBar;

		// Set initial after image width
		this.setAfterImageWidth();
		if( this.options.auto ){
			element.on('mouseover', this.startDrag.bind(this));
			element.on('mouseout', function(){
				$(document).off('mousemove', this.onMouseMove);
			});
		}
		else {

			// Add event listeners
			dragBar.on('mousedown touchstart', this.startDrag.bind(this));

			if ( this.options.revealOnClick ){

				element.on('click', this.onMouseMove.bind(this));
			}

			// Disable move on mouseup
			$(document).on('mouseup touchend touchcancel', function(){
				$(document).off('mousemove', this.onMouseMove);
			});
		}

		$(window).on('resize', this.setAfterImageWidth.bind(this));

	}


  beforeAfter.prototype.startDrag = function(event) {
	event.preventDefault();
	$(document).on('mousemove touchmove', this.onMouseMove.bind(this));

  }

  beforeAfter.prototype.setAfterImageWidth = function() {
	var imageWidth, afterImage;
	// Set the after image height
	imageWidth = $('> img', this.activeElement).outerWidth();
	afterImage = $( '.beforeAfter-imgAfter img', this.activeElement );
	afterImage.css('width', imageWidth);
  }

  beforeAfter.prototype.onMouseMove = function(event) {
	if(event.pageX || event.pageY) {
		event.preventDefault();
	}
	if( this.options.position === 'vertical' ) {
		// Check if it's a mouse or touch event and pass along the correct value
		var moveX = (event.pageX) ? event.pageX : event.originalEvent.touches[0].pageX;
		var parentOffset = this.activeElement.offset();
		var relX = moveX - parentOffset.left;
		var maxL = (this.activeElement.outerWidth() - this.dragBar.outerWidth());

		//Prevent going off limits
		if(relX > maxL) relX = maxL;
		else if(relX < 0) relX = 0;

		var widthValue = relX*100/this.activeElement.outerWidth();

		this.dragBar.css('left', widthValue + '%');
		this.activeElement.find('.beforeAfter-imgAfter').css('width', widthValue + '%');

	}
	else{
		var moveY = (event.pageY) ? event.pageY : event.originalEvent.touches[0].pageY;
		var parentOffset = this.activeElement.offset();

		var relY = moveY - parentOffset.top;
		var maxT = (this.activeElement.outerHeight() - this.dragBar.outerHeight());

		//Prevent going off limits
		if(relY > maxT) relY = maxT;
		else if(relY < 0) relY = 0;

		var heightValue = relY*100/this.activeElement.outerHeight()+'%';

		this.dragBar.css('top', heightValue);
		this.activeElement.find('.beforeAfter-imgAfter').css('height', heightValue );
	}
  }

 function ZnHook_beforeAfter(scope) {

	var BFcontainer = scope ? scope.find('.beforeAfter') : $('.beforeAfter');

	BFcontainer.each(function(){
		var el = $(this);
		var options = {
			auto:			el.data('auto') === 1,
			position:		el.data('position'),
			revealOnClick:  el.data('reveal') === 1
		}
		el.beforeAfter(options);
	});
 }


	ZnHook_beforeAfter();
	// Refresh events on new content
	$(document).on('ZnNewContent',function(e){
		ZnHook_beforeAfter( e.content );
	});

}(jQuery));